/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.path;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.PathRef;
import com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import com.jayway.jsonpath.internal.path.PathToken;
import com.jayway.jsonpath.internal.path.PredicateContextImpl;
import java.util.Collection;
import java.util.Collections;

public class PredicatePathToken
extends PathToken {
    private final Collection<Predicate> predicates;

    PredicatePathToken(Predicate filter2) {
        this.predicates = Collections.singletonList(filter2);
    }

    PredicatePathToken(Collection<Predicate> predicates) {
        this.predicates = predicates;
    }

    @Override
    public void evaluate(String currentPath, PathRef ref, Object model, EvaluationContextImpl ctx) {
        if (ctx.jsonProvider().isMap(model)) {
            if (this.accept(model, ctx.rootDocument(), ctx.configuration(), ctx)) {
                PathRef op;
                PathRef pathRef = op = ctx.forUpdate() ? ref : PathRef.NO_OP;
                if (this.isLeaf()) {
                    ctx.addResult(currentPath, op, model);
                } else {
                    this.next().evaluate(currentPath, op, model, ctx);
                }
            }
        } else if (ctx.jsonProvider().isArray(model)) {
            int idx = 0;
            Iterable<?> objects = ctx.jsonProvider().toIterable(model);
            for (Object idxModel : objects) {
                if (this.accept(idxModel, ctx.rootDocument(), ctx.configuration(), ctx)) {
                    this.handleArrayIndex(idx, currentPath, model, ctx);
                }
                ++idx;
            }
        } else if (this.isUpstreamDefinite()) {
            throw new InvalidPathException(String.format("Filter: %s can not be applied to primitives. Current context is: %s", this.toString(), model));
        }
    }

    public boolean accept(Object obj, Object root, Configuration configuration, EvaluationContextImpl evaluationContext) {
        PredicateContextImpl ctx = new PredicateContextImpl(obj, root, configuration, evaluationContext.documentEvalCache());
        for (Predicate predicate : this.predicates) {
            try {
                if (predicate.apply(ctx)) continue;
                return false;
            }
            catch (InvalidPathException e2) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getPathFragment() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i2 = 0; i2 < this.predicates.size(); ++i2) {
            if (i2 != 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean isTokenDefinite() {
        return false;
    }
}

