/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.spi.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.spi.json.AbstractJsonProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class JacksonJsonNodeJsonProvider
extends AbstractJsonProvider {
    private static final ObjectMapper defaultObjectMapper = new ObjectMapper();
    protected ObjectMapper objectMapper;

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public JacksonJsonNodeJsonProvider() {
        this(defaultObjectMapper);
    }

    public JacksonJsonNodeJsonProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public Object parse(String json2) throws InvalidJsonException {
        try {
            return this.objectMapper.readTree(json2);
        }
        catch (IOException e2) {
            throw new InvalidJsonException(e2, json2);
        }
    }

    @Override
    public Object parse(byte[] json2) throws InvalidJsonException {
        try {
            return this.objectMapper.readTree(json2);
        }
        catch (IOException e2) {
            throw new InvalidJsonException(e2, new String(json2, StandardCharsets.UTF_8));
        }
    }

    @Override
    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        try {
            return this.objectMapper.readTree(new InputStreamReader(jsonStream, charset));
        }
        catch (IOException e2) {
            throw new InvalidJsonException(e2);
        }
    }

    @Override
    public String toJson(Object obj) {
        if (!(obj instanceof JsonNode)) {
            throw new JsonPathException("Not a JSON Node");
        }
        return obj.toString();
    }

    @Override
    public Object createArray() {
        return JsonNodeFactory.instance.arrayNode();
    }

    @Override
    public Object createMap() {
        return JsonNodeFactory.instance.objectNode();
    }

    @Override
    public Object unwrap(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof JsonNode)) {
            return o;
        }
        JsonNode e2 = (JsonNode)o;
        if (e2.isValueNode()) {
            if (e2.isTextual()) {
                return e2.asText();
            }
            if (e2.isBoolean()) {
                return e2.asBoolean();
            }
            if (e2.isInt()) {
                return e2.asInt();
            }
            if (e2.isLong()) {
                return e2.asLong();
            }
            if (e2.isBigInteger()) {
                return e2.bigIntegerValue();
            }
            if (e2.isDouble()) {
                return e2.doubleValue();
            }
            if (e2.isFloat()) {
                return Float.valueOf(e2.floatValue());
            }
            if (e2.isBigDecimal()) {
                return e2.decimalValue();
            }
            if (e2.isNull()) {
                return null;
            }
        }
        return o;
    }

    @Override
    public boolean isArray(Object obj) {
        return obj instanceof ArrayNode || obj instanceof List;
    }

    @Override
    public Object getArrayIndex(Object obj, int idx) {
        return this.toJsonArray(obj).get(idx);
    }

    @Override
    public void setArrayIndex(Object array, int index, Object newValue) {
        if (!this.isArray(array)) {
            throw new UnsupportedOperationException();
        }
        ArrayNode arrayNode = this.toJsonArray(array);
        if (index == arrayNode.size()) {
            arrayNode.add(this.createJsonElement(newValue));
        } else {
            arrayNode.set(index, this.createJsonElement(newValue));
        }
    }

    @Override
    public Object getMapValue(Object obj, String key2) {
        ObjectNode jsonObject = this.toJsonObject(obj);
        JsonNode o = jsonObject.get(key2);
        if (!jsonObject.has(key2)) {
            return UNDEFINED;
        }
        return o;
    }

    @Override
    public void setProperty(Object obj, Object key2, Object value2) {
        if (this.isMap(obj)) {
            this.setValueInObjectNode((ObjectNode)obj, key2, value2);
        } else {
            ArrayNode array;
            int index = key2 != null ? (key2 instanceof Integer ? (Integer)key2 : Integer.parseInt(key2.toString())) : array.size();
            if (index == (array = (ArrayNode)obj).size()) {
                array.add(this.createJsonElement(value2));
            } else {
                array.set(index, this.createJsonElement(value2));
            }
        }
    }

    @Override
    public void removeProperty(Object obj, Object key2) {
        if (this.isMap(obj)) {
            this.toJsonObject(obj).remove(key2.toString());
        } else {
            ArrayNode array = this.toJsonArray(obj);
            int index = key2 instanceof Integer ? (Integer)key2 : Integer.parseInt(key2.toString());
            array.remove(index);
        }
    }

    @Override
    public boolean isMap(Object obj) {
        return obj instanceof ObjectNode;
    }

    @Override
    public Collection<String> getPropertyKeys(Object obj) {
        ArrayList<String> keys2 = new ArrayList<String>();
        Iterator<String> iter = this.toJsonObject(obj).fieldNames();
        while (iter.hasNext()) {
            keys2.add(iter.next());
        }
        return keys2;
    }

    @Override
    public int length(Object obj) {
        if (this.isArray(obj)) {
            return this.toJsonArray(obj).size();
        }
        if (this.isMap(obj)) {
            return this.toJsonObject(obj).size();
        }
        if (obj instanceof TextNode) {
            TextNode element = (TextNode)obj;
            return element.size();
        }
        throw new JsonPathException("length operation can not applied to " + (obj != null ? obj.getClass().getName() : "null"));
    }

    @Override
    public Iterable<?> toIterable(Object obj) {
        ArrayNode arr = this.toJsonArray(obj);
        final Iterator<JsonNode> iterator2 = arr.iterator();
        return new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){

                    @Override
                    public boolean hasNext() {
                        return iterator2.hasNext();
                    }

                    @Override
                    public Object next() {
                        return JacksonJsonNodeJsonProvider.this.unwrap(iterator2.next());
                    }
                };
            }
        };
    }

    private JsonNode createJsonElement(Object o) {
        if (o != null) {
            if (o instanceof JsonNode) {
                return (JsonNode)o;
            }
            return this.objectMapper.valueToTree(o);
        }
        return null;
    }

    private ArrayNode toJsonArray(Object o) {
        return (ArrayNode)o;
    }

    private ObjectNode toJsonObject(Object o) {
        return (ObjectNode)o;
    }

    private void setValueInObjectNode(ObjectNode objectNode, Object key2, Object value2) {
        if (value2 instanceof JsonNode) {
            objectNode.set(key2.toString(), (JsonNode)value2);
        } else if (value2 instanceof String) {
            objectNode.put(key2.toString(), (String)value2);
        } else if (value2 instanceof Integer) {
            objectNode.put(key2.toString(), (Integer)value2);
        } else if (value2 instanceof Long) {
            objectNode.put(key2.toString(), (Long)value2);
        } else if (value2 instanceof Short) {
            objectNode.put(key2.toString(), (Short)value2);
        } else if (value2 instanceof BigInteger) {
            objectNode.put(key2.toString(), (BigInteger)value2);
        } else if (value2 instanceof Double) {
            objectNode.put(key2.toString(), (Double)value2);
        } else if (value2 instanceof Float) {
            objectNode.put(key2.toString(), (Float)value2);
        } else if (value2 instanceof BigDecimal) {
            objectNode.put(key2.toString(), (BigDecimal)value2);
        } else if (value2 instanceof Boolean) {
            objectNode.put(key2.toString(), (Boolean)value2);
        } else if (value2 instanceof byte[]) {
            objectNode.put(key2.toString(), (byte[])value2);
        } else if (value2 == null) {
            objectNode.set(key2.toString(), null);
        } else {
            objectNode.set(key2.toString(), this.createJsonElement(value2));
        }
    }
}

