/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

final class BadMap<K, V> {
    private final int size;
    private final Entry[] entries;
    private static final Entry[] emptyEntries = new Entry[0];
    private static final int[] primes = new int[]{2, 5, 11, 17, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997, 1009, 2053, 3079, 4057, 7103, 10949, 16069, 32609, 65867, 104729};

    BadMap() {
        this(0, emptyEntries);
    }

    private BadMap(int size2, Entry[] entries2) {
        this.size = size2;
        this.entries = entries2;
    }

    BadMap<K, V> copyingPut(K k2, V v) {
        int newSize = this.size + 1;
        Entry[] newEntries = newSize > this.entries.length ? new Entry[BadMap.nextPrime(newSize * 2 - 1)] : new Entry[this.entries.length];
        if (newEntries.length == this.entries.length) {
            System.arraycopy(this.entries, 0, newEntries, 0, this.entries.length);
        } else {
            BadMap.rehash(this.entries, newEntries);
        }
        int hash = Math.abs(k2.hashCode());
        BadMap.store(newEntries, hash, k2, v);
        return new BadMap<K, V>(newSize, newEntries);
    }

    private static <K, V> void store(Entry[] entries2, int hash, K k2, V v) {
        int i2 = hash % entries2.length;
        Entry old = entries2[i2];
        entries2[i2] = new Entry(hash, k2, v, old);
    }

    private static void store(Entry[] entries2, Entry e2) {
        int i2 = e2.hash % entries2.length;
        Entry old = entries2[i2];
        entries2[i2] = old == null && e2.next == null ? e2 : new Entry(e2.hash, e2.key, e2.value, old);
    }

    private static void rehash(Entry[] src, Entry[] dest) {
        for (Entry entry : src) {
            while (entry != null) {
                BadMap.store(dest, entry);
                entry = entry.next;
            }
        }
    }

    V get(K k2) {
        if (this.entries.length == 0) {
            return null;
        }
        int hash = Math.abs(k2.hashCode());
        int i2 = hash % this.entries.length;
        Entry e2 = this.entries[i2];
        if (e2 == null) {
            return null;
        }
        return (V)e2.find(k2);
    }

    private static int nextPrime(int i2) {
        for (int p : primes) {
            if (p <= i2) continue;
            return p;
        }
        return primes[primes.length - 1];
    }

    static final class Entry {
        final int hash;
        final Object key;
        final Object value;
        final Entry next;

        Entry(int hash, Object k2, Object v, Entry next2) {
            this.hash = hash;
            this.key = k2;
            this.value = v;
            this.next = next2;
        }

        Object find(Object k2) {
            if (this.key.equals(k2)) {
                return this.value;
            }
            if (this.next != null) {
                return this.next.find(k2);
            }
            return null;
        }
    }
}

