/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.ConfigNumber;
import com.typesafe.config.impl.SerializedConfigValue;
import java.io.ObjectStreamException;
import java.io.Serializable;

final class ConfigLong
extends ConfigNumber
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final long value;

    ConfigLong(ConfigOrigin origin2, long value2, String originalText) {
        super(origin2, originalText);
        this.value = value2;
    }

    @Override
    public ConfigValueType valueType() {
        return ConfigValueType.NUMBER;
    }

    @Override
    public Long unwrapped() {
        return this.value;
    }

    @Override
    String transformToString() {
        String s2 = super.transformToString();
        if (s2 == null) {
            return Long.toString(this.value);
        }
        return s2;
    }

    @Override
    protected long longValue() {
        return this.value;
    }

    @Override
    protected double doubleValue() {
        return this.value;
    }

    @Override
    protected ConfigLong newCopy(ConfigOrigin origin2) {
        return new ConfigLong(origin2, this.value, this.originalText);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedConfigValue(this);
    }
}

