/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ConfigReference;
import com.typesafe.config.impl.MemoKey;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveMemos;
import com.typesafe.config.impl.ResolveResult;
import com.typesafe.config.impl.ResolveSource;
import com.typesafe.config.impl.ResolveStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

final class ResolveContext {
    private final ResolveMemos memos;
    private final ConfigResolveOptions options;
    private final Path restrictToChild;
    private final List<AbstractConfigValue> resolveStack;
    private final Set<AbstractConfigValue> cycleMarkers;

    ResolveContext(ResolveMemos memos, ConfigResolveOptions options2, Path restrictToChild, List<AbstractConfigValue> resolveStack, Set<AbstractConfigValue> cycleMarkers) {
        this.memos = memos;
        this.options = options2;
        this.restrictToChild = restrictToChild;
        this.resolveStack = resolveStack;
        this.cycleMarkers = cycleMarkers;
    }

    private static Set<AbstractConfigValue> newCycleMarkers() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    ResolveContext(ConfigResolveOptions options2, Path restrictToChild) {
        this(new ResolveMemos(), options2, restrictToChild, new ArrayList<AbstractConfigValue>(), ResolveContext.newCycleMarkers());
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "ResolveContext restrict to child " + restrictToChild);
        }
    }

    ResolveContext addCycleMarker(AbstractConfigValue value2) {
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "++ Cycle marker " + value2 + "@" + System.identityHashCode(value2));
        }
        if (this.cycleMarkers.contains(value2)) {
            throw new ConfigException.BugOrBroken("Added cycle marker twice " + value2);
        }
        Set<AbstractConfigValue> copy2 = ResolveContext.newCycleMarkers();
        copy2.addAll(this.cycleMarkers);
        copy2.add(value2);
        return new ResolveContext(this.memos, this.options, this.restrictToChild, this.resolveStack, copy2);
    }

    ResolveContext removeCycleMarker(AbstractConfigValue value2) {
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "-- Cycle marker " + value2 + "@" + System.identityHashCode(value2));
        }
        Set<AbstractConfigValue> copy2 = ResolveContext.newCycleMarkers();
        copy2.addAll(this.cycleMarkers);
        copy2.remove(value2);
        return new ResolveContext(this.memos, this.options, this.restrictToChild, this.resolveStack, copy2);
    }

    private ResolveContext memoize(MemoKey key2, AbstractConfigValue value2) {
        ResolveMemos changed = this.memos.put(key2, value2);
        return new ResolveContext(changed, this.options, this.restrictToChild, this.resolveStack, this.cycleMarkers);
    }

    ConfigResolveOptions options() {
        return this.options;
    }

    boolean isRestrictedToChild() {
        return this.restrictToChild != null;
    }

    Path restrictToChild() {
        return this.restrictToChild;
    }

    ResolveContext restrict(Path restrictTo) {
        if (restrictTo == this.restrictToChild) {
            return this;
        }
        return new ResolveContext(this.memos, this.options, restrictTo, this.resolveStack, this.cycleMarkers);
    }

    ResolveContext unrestricted() {
        return this.restrict(null);
    }

    String traceString() {
        String separator = ", ";
        StringBuilder sb = new StringBuilder();
        for (AbstractConfigValue value2 : this.resolveStack) {
            if (!(value2 instanceof ConfigReference)) continue;
            sb.append(((ConfigReference)value2).expression().toString());
            sb.append(separator);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - separator.length());
        }
        return sb.toString();
    }

    private ResolveContext pushTrace(AbstractConfigValue value2) {
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "pushing trace " + value2);
        }
        ArrayList<AbstractConfigValue> copy2 = new ArrayList<AbstractConfigValue>(this.resolveStack);
        copy2.add(value2);
        return new ResolveContext(this.memos, this.options, this.restrictToChild, copy2, this.cycleMarkers);
    }

    ResolveContext popTrace() {
        ArrayList<AbstractConfigValue> copy2 = new ArrayList<AbstractConfigValue>(this.resolveStack);
        AbstractConfigValue old = (AbstractConfigValue)copy2.remove(this.resolveStack.size() - 1);
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth() - 1, "popped trace " + old);
        }
        return new ResolveContext(this.memos, this.options, this.restrictToChild, copy2, this.cycleMarkers);
    }

    int depth() {
        if (this.resolveStack.size() > 30) {
            throw new ConfigException.BugOrBroken("resolve getting too deep");
        }
        return this.resolveStack.size();
    }

    ResolveResult<? extends AbstractConfigValue> resolve(AbstractConfigValue original, ResolveSource source2) throws AbstractConfigValue.NotPossibleToResolve {
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "resolving " + original + " restrictToChild=" + this.restrictToChild + " in " + source2);
        }
        return this.pushTrace(original).realResolve(original, source2).popTrace();
    }

    private ResolveResult<? extends AbstractConfigValue> realResolve(AbstractConfigValue original, ResolveSource source2) throws AbstractConfigValue.NotPossibleToResolve {
        MemoKey fullKey = new MemoKey(original, null);
        MemoKey restrictedKey = null;
        AbstractConfigValue cached = this.memos.get(fullKey);
        if (cached == null && this.isRestrictedToChild()) {
            restrictedKey = new MemoKey(original, this.restrictToChild());
            cached = this.memos.get(restrictedKey);
        }
        if (cached != null) {
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace(this.depth(), "using cached resolution " + cached + " for " + original + " restrictToChild " + this.restrictToChild());
            }
            return ResolveResult.make(this, cached);
        }
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "not found in cache, resolving " + original + "@" + System.identityHashCode(original));
        }
        if (this.cycleMarkers.contains(original)) {
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace(this.depth(), "Cycle detected, can't resolve; " + original + "@" + System.identityHashCode(original));
            }
            throw new AbstractConfigValue.NotPossibleToResolve(this);
        }
        ResolveResult<? extends AbstractConfigValue> result2 = original.resolveSubstitutions(this, source2);
        Object resolved2 = result2.value;
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "resolved to " + resolved2 + "@" + System.identityHashCode(resolved2) + " from " + original + "@" + System.identityHashCode(resolved2));
        }
        ResolveContext withMemo = result2.context;
        if (resolved2 == null || ((AbstractConfigValue)resolved2).resolveStatus() == ResolveStatus.RESOLVED) {
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace(this.depth(), "caching " + fullKey + " result " + resolved2);
            }
            withMemo = withMemo.memoize(fullKey, (AbstractConfigValue)resolved2);
        } else if (this.isRestrictedToChild()) {
            if (restrictedKey == null) {
                throw new ConfigException.BugOrBroken("restrictedKey should not be null here");
            }
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace(this.depth(), "caching " + restrictedKey + " result " + resolved2);
            }
            withMemo = withMemo.memoize(restrictedKey, (AbstractConfigValue)resolved2);
        } else if (this.options().getAllowUnresolved()) {
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace(this.depth(), "caching " + fullKey + " result " + resolved2);
            }
            withMemo = withMemo.memoize(fullKey, (AbstractConfigValue)resolved2);
        } else {
            throw new ConfigException.BugOrBroken("resolveSubstitutions() did not give us a resolved object");
        }
        return ResolveResult.make(withMemo, resolved2);
    }

    static AbstractConfigValue resolve(AbstractConfigValue value2, AbstractConfigObject root, ConfigResolveOptions options2) {
        ResolveSource source2 = new ResolveSource(root);
        ResolveContext context = new ResolveContext(options2, null);
        try {
            return context.resolve((AbstractConfigValue)value2, (ResolveSource)source2).value;
        }
        catch (AbstractConfigValue.NotPossibleToResolve e2) {
            throw new ConfigException.BugOrBroken("NotPossibleToResolve was thrown from an outermost resolve", e2);
        }
    }
}

