/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.Datatypes;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.StringUnionOperations;
import dk.brics.automaton.Transition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public final class BasicAutomata {
    private BasicAutomata() {
    }

    public static Automaton makeEmpty() {
        Automaton a2 = new Automaton();
        a2.initial = new State();
        a2.deterministic = true;
        return a2;
    }

    public static Automaton makeEmptyString() {
        Automaton a2 = new Automaton();
        a2.singleton = "";
        a2.deterministic = true;
        return a2;
    }

    public static Automaton makeAnyString() {
        State s2;
        Automaton a2 = new Automaton();
        a2.initial = s2 = new State();
        s2.accept = true;
        s2.transitions.add(new Transition('\u0000', '\uffff', s2));
        a2.deterministic = true;
        return a2;
    }

    public static Automaton makeAnyChar() {
        return BasicAutomata.makeCharRange('\u0000', '\uffff');
    }

    public static Automaton makeChar(char c2) {
        Automaton a2 = new Automaton();
        a2.singleton = Character.toString(c2);
        a2.deterministic = true;
        return a2;
    }

    public static Automaton makeCharRange(char min2, char max2) {
        if (min2 == max2) {
            return BasicAutomata.makeChar(min2);
        }
        Automaton a2 = new Automaton();
        State s1 = new State();
        State s2 = new State();
        a2.initial = s1;
        s2.accept = true;
        if (min2 <= max2) {
            s1.transitions.add(new Transition(min2, max2, s2));
        }
        a2.deterministic = true;
        return a2;
    }

    public static Automaton makeCharSet(String set2) {
        if (set2.length() == 1) {
            return BasicAutomata.makeChar(set2.charAt(0));
        }
        Automaton a2 = new Automaton();
        State s1 = new State();
        State s2 = new State();
        a2.initial = s1;
        s2.accept = true;
        for (int i2 = 0; i2 < set2.length(); ++i2) {
            s1.transitions.add(new Transition(set2.charAt(i2), s2));
        }
        a2.deterministic = true;
        a2.reduce();
        return a2;
    }

    private static State anyOfRightLength(String x, int n) {
        State s2 = new State();
        if (x.length() == n) {
            s2.setAccept(true);
        } else {
            s2.addTransition(new Transition('0', '9', BasicAutomata.anyOfRightLength(x, n + 1)));
        }
        return s2;
    }

    private static State atLeast(String x, int n, Collection<State> initials, boolean zeros) {
        State s2 = new State();
        if (x.length() == n) {
            s2.setAccept(true);
        } else {
            if (zeros) {
                initials.add(s2);
            }
            char c2 = x.charAt(n);
            s2.addTransition(new Transition(c2, BasicAutomata.atLeast(x, n + 1, initials, zeros && c2 == '0')));
            if (c2 < '9') {
                s2.addTransition(new Transition((char)(c2 + '\u0001'), '9', BasicAutomata.anyOfRightLength(x, n + 1)));
            }
        }
        return s2;
    }

    private static State atMost(String x, int n) {
        State s2 = new State();
        if (x.length() == n) {
            s2.setAccept(true);
        } else {
            char c2 = x.charAt(n);
            s2.addTransition(new Transition(c2, BasicAutomata.atMost(x, (char)n + '\u0001')));
            if (c2 > '0') {
                s2.addTransition(new Transition('0', (char)(c2 - '\u0001'), BasicAutomata.anyOfRightLength(x, n + 1)));
            }
        }
        return s2;
    }

    private static State between(String x, String y, int n, Collection<State> initials, boolean zeros) {
        State s2 = new State();
        if (x.length() == n) {
            s2.setAccept(true);
        } else {
            char cy;
            char cx;
            if (zeros) {
                initials.add(s2);
            }
            if ((cx = x.charAt(n)) == (cy = y.charAt(n))) {
                s2.addTransition(new Transition(cx, BasicAutomata.between(x, y, n + 1, initials, zeros && cx == '0')));
            } else {
                s2.addTransition(new Transition(cx, BasicAutomata.atLeast(x, n + 1, initials, zeros && cx == '0')));
                s2.addTransition(new Transition(cy, BasicAutomata.atMost(y, n + 1)));
                if (cx + '\u0001' < cy) {
                    s2.addTransition(new Transition((char)(cx + '\u0001'), (char)(cy - '\u0001'), BasicAutomata.anyOfRightLength(x, n + 1)));
                }
            }
        }
        return s2;
    }

    public static Automaton makeInterval(int min2, int max2, int digits) throws IllegalArgumentException {
        Automaton a2 = new Automaton();
        String x = Integer.toString(min2);
        String y = Integer.toString(max2);
        if (min2 > max2 || digits > 0 && y.length() > digits) {
            throw new IllegalArgumentException();
        }
        int d2 = digits > 0 ? digits : y.length();
        StringBuilder bx = new StringBuilder();
        for (int i2 = x.length(); i2 < d2; ++i2) {
            bx.append('0');
        }
        bx.append(x);
        x = bx.toString();
        StringBuilder by = new StringBuilder();
        for (int i3 = y.length(); i3 < d2; ++i3) {
            by.append('0');
        }
        by.append(y);
        y = by.toString();
        ArrayList<State> initials = new ArrayList<State>();
        a2.initial = BasicAutomata.between(x, y, 0, initials, digits <= 0);
        if (digits <= 0) {
            ArrayList<StatePair> pairs2 = new ArrayList<StatePair>();
            for (State p : initials) {
                if (a2.initial == p) continue;
                pairs2.add(new StatePair(a2.initial, p));
            }
            a2.addEpsilons(pairs2);
            a2.initial.addTransition(new Transition('0', a2.initial));
            a2.deterministic = false;
        } else {
            a2.deterministic = true;
        }
        a2.checkMinimizeAlways();
        return a2;
    }

    public static Automaton makeString(String s2) {
        Automaton a2 = new Automaton();
        a2.singleton = s2;
        a2.deterministic = true;
        return a2;
    }

    public static Automaton makeStringUnion(CharSequence ... strings) {
        if (strings.length == 0) {
            return BasicAutomata.makeEmpty();
        }
        Arrays.sort(strings, StringUnionOperations.LEXICOGRAPHIC_ORDER);
        Automaton a2 = new Automaton();
        a2.setInitialState(StringUnionOperations.build(strings));
        a2.setDeterministic(true);
        a2.reduce();
        a2.recomputeHashCode();
        return a2;
    }

    public static Automaton makeMaxInteger(String n) {
        int i2;
        for (i2 = 0; i2 < n.length() && n.charAt(i2) == '0'; ++i2) {
        }
        StringBuilder b2 = new StringBuilder();
        b2.append("0*(0|");
        if (i2 < n.length()) {
            b2.append("[0-9]{1,").append(n.length() - i2 - 1).append("}|");
        }
        BasicAutomata.maxInteger(n.substring(i2), 0, b2);
        b2.append(")");
        return Automaton.minimize(new RegExp(b2.toString()).toAutomaton());
    }

    private static void maxInteger(String n, int i2, StringBuilder b2) {
        b2.append('(');
        if (i2 < n.length()) {
            char c2 = n.charAt(i2);
            if (c2 != '0') {
                b2.append("[0-").append((char)(c2 - '\u0001')).append("][0-9]{").append(n.length() - i2 - 1).append("}|");
            }
            b2.append(c2);
            BasicAutomata.maxInteger(n, i2 + 1, b2);
        }
        b2.append(')');
    }

    public static Automaton makeMinInteger(String n) {
        int i2 = 0;
        while (i2 + 1 < n.length() && n.charAt(i2) == '0') {
            ++i2;
        }
        StringBuilder b2 = new StringBuilder();
        b2.append("0*");
        BasicAutomata.minInteger(n.substring(i2), 0, b2);
        b2.append("[0-9]*");
        return Automaton.minimize(new RegExp(b2.toString()).toAutomaton());
    }

    private static void minInteger(String n, int i2, StringBuilder b2) {
        b2.append('(');
        if (i2 < n.length()) {
            char c2 = n.charAt(i2);
            if (c2 != '9') {
                b2.append("[").append((char)(c2 + '\u0001')).append("-9][0-9]{").append(n.length() - i2 - 1).append("}|");
            }
            b2.append(c2);
            BasicAutomata.minInteger(n, i2 + 1, b2);
        }
        b2.append(')');
    }

    public static Automaton makeTotalDigits(int i2) {
        return Automaton.minimize(new RegExp("[ \t\n\r]*[-+]?0*([0-9]{0," + i2 + "}|((([0-9]\\.*){0," + i2 + "})&@\\.@)0*)[ \t\n\r]*").toAutomaton());
    }

    public static Automaton makeFractionDigits(int i2) {
        return Automaton.minimize(new RegExp("[ \t\n\r]*[-+]?[0-9]+(\\.[0-9]{0," + i2 + "}0*)?[ \t\n\r]*").toAutomaton());
    }

    public static Automaton makeIntegerValue(String value2) {
        int i2;
        boolean minus2 = false;
        for (i2 = 0; i2 < value2.length(); ++i2) {
            char c2 = value2.charAt(i2);
            if (c2 == '-') {
                minus2 = true;
            }
            if (c2 >= '1' && c2 <= '9') break;
        }
        StringBuilder b2 = new StringBuilder();
        b2.append(value2.substring(i2));
        if (b2.length() == 0) {
            b2.append("0");
        }
        Automaton s2 = minus2 ? Automaton.makeChar('-') : Automaton.makeChar('+').optional();
        Automaton ws2 = Datatypes.getWhitespaceAutomaton();
        return Automaton.minimize(ws2.concatenate(s2.concatenate(Automaton.makeChar('0').repeat()).concatenate(Automaton.makeString(b2.toString()))).concatenate(ws2));
    }

    public static Automaton makeDecimalValue(String value2) {
        int i2;
        boolean minus2 = false;
        for (i2 = 0; i2 < value2.length(); ++i2) {
            char c2 = value2.charAt(i2);
            if (c2 == '-') {
                minus2 = true;
            }
            if (c2 >= '1' && c2 <= '9' || c2 == '.') break;
        }
        StringBuilder b1 = new StringBuilder();
        StringBuilder b2 = new StringBuilder();
        int p = value2.indexOf(46, i2);
        if (p == -1) {
            b1.append(value2.substring(i2));
        } else {
            char c3;
            b1.append(value2.substring(i2, p));
            for (i2 = value2.length() - 1; i2 > p && ((c3 = value2.charAt(i2)) < '1' || c3 > '9'); --i2) {
            }
            b2.append(value2.substring(p + 1, i2 + 1));
        }
        if (b1.length() == 0) {
            b1.append("0");
        }
        Automaton s2 = minus2 ? Automaton.makeChar('-') : Automaton.makeChar('+').optional();
        Automaton d2 = b2.length() == 0 ? Automaton.makeChar('.').concatenate(Automaton.makeChar('0').repeat(1)).optional() : Automaton.makeChar('.').concatenate(Automaton.makeString(b2.toString())).concatenate(Automaton.makeChar('0').repeat());
        Automaton ws2 = Datatypes.getWhitespaceAutomaton();
        return Automaton.minimize(ws2.concatenate(s2.concatenate(Automaton.makeChar('0').repeat()).concatenate(Automaton.makeString(b1.toString())).concatenate(d2)).concatenate(ws2));
    }

    public static Automaton makeStringMatcher(String s2) {
        Automaton a2 = new Automaton();
        State[] states = new State[s2.length() + 1];
        states[0] = a2.initial;
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            states[i2 + 1] = new State();
        }
        State f2 = states[s2.length()];
        f2.accept = true;
        f2.transitions.add(new Transition('\u0000', '\uffff', f2));
        for (int i3 = 0; i3 < s2.length(); ++i3) {
            HashSet<Character> done = new HashSet<Character>();
            char c2 = s2.charAt(i3);
            states[i3].transitions.add(new Transition(c2, states[i3 + 1]));
            done.add(Character.valueOf(c2));
            for (int j2 = i3; j2 >= 1; --j2) {
                char d2 = s2.charAt(j2 - 1);
                if (done.contains(Character.valueOf(d2)) || !s2.substring(0, j2 - 1).equals(s2.substring(i3 - j2 + 1, i3))) continue;
                states[i3].transitions.add(new Transition(d2, states[j2]));
                done.add(Character.valueOf(d2));
            }
            char[] da = new char[done.size()];
            int h2 = 0;
            Iterator iterator2 = done.iterator();
            while (iterator2.hasNext()) {
                char w = ((Character)iterator2.next()).charValue();
                da[h2++] = w;
            }
            Arrays.sort(da);
            int from2 = 0;
            int k2 = 0;
            while (from2 <= 65535) {
                while (k2 < da.length && da[k2] == from2) {
                    ++k2;
                    ++from2;
                }
                if (from2 > 65535) continue;
                int to = 65535;
                if (k2 < da.length) {
                    to = da[k2] - '\u0001';
                    ++k2;
                }
                states[i3].transitions.add(new Transition((char)from2, (char)to, states[0]));
                from2 = to + 2;
            }
        }
        a2.deterministic = true;
        return a2;
    }
}

