/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicAutomata;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.Transition;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class BasicOperations {
    private BasicOperations() {
    }

    public static Automaton concatenate(Automaton a1, Automaton a2) {
        boolean deterministic;
        if (a1.isSingleton() && a2.isSingleton()) {
            return BasicAutomata.makeString(a1.singleton + a2.singleton);
        }
        if (BasicOperations.isEmpty(a1) || BasicOperations.isEmpty(a2)) {
            return BasicAutomata.makeEmpty();
        }
        boolean bl = deterministic = a1.isSingleton() && a2.isDeterministic();
        if (a1 == a2) {
            a1 = a1.cloneExpanded();
            a2 = a2.cloneExpanded();
        } else {
            a1 = a1.cloneExpandedIfRequired();
            a2 = a2.cloneExpandedIfRequired();
        }
        for (State s2 : a1.getAcceptStates()) {
            s2.accept = false;
            s2.addEpsilon(a2.initial);
        }
        a1.deterministic = deterministic;
        a1.clearHashCode();
        a1.checkMinimizeAlways();
        return a1;
    }

    public static Automaton concatenate(List<Automaton> l) {
        if (l.isEmpty()) {
            return BasicAutomata.makeEmptyString();
        }
        boolean all_singleton = true;
        for (Automaton automaton : l) {
            if (automaton.isSingleton()) continue;
            all_singleton = false;
            break;
        }
        if (all_singleton) {
            StringBuilder b2 = new StringBuilder();
            for (Automaton a3 : l) {
                b2.append(a3.singleton);
            }
            return BasicAutomata.makeString(b2.toString());
        }
        for (Automaton automaton : l) {
            if (!automaton.isEmpty()) continue;
            return BasicAutomata.makeEmpty();
        }
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Automaton a4 : l) {
            ids.add(System.identityHashCode(a4));
        }
        boolean bl = ids.size() != l.size();
        Automaton b3 = l.get(0);
        b3 = bl ? b3.cloneExpanded() : b3.cloneExpandedIfRequired();
        Set<State> ac = b3.getAcceptStates();
        boolean first2 = true;
        for (Automaton a5 : l) {
            if (first2) {
                first2 = false;
                continue;
            }
            if (a5.isEmptyString()) continue;
            Automaton aa = a5;
            aa = bl ? aa.cloneExpanded() : aa.cloneExpandedIfRequired();
            Set<State> ns = aa.getAcceptStates();
            for (State s2 : ac) {
                s2.accept = false;
                s2.addEpsilon(aa.initial);
                if (!s2.accept) continue;
                ns.add(s2);
            }
            ac = ns;
        }
        b3.deterministic = false;
        b3.clearHashCode();
        b3.checkMinimizeAlways();
        return b3;
    }

    public static Automaton optional(Automaton a2) {
        a2 = a2.cloneExpandedIfRequired();
        State s2 = new State();
        s2.addEpsilon(a2.initial);
        s2.accept = true;
        a2.initial = s2;
        a2.deterministic = false;
        a2.clearHashCode();
        a2.checkMinimizeAlways();
        return a2;
    }

    public static Automaton repeat(Automaton a2) {
        a2 = a2.cloneExpanded();
        State s2 = new State();
        s2.accept = true;
        s2.addEpsilon(a2.initial);
        for (State p : a2.getAcceptStates()) {
            p.addEpsilon(s2);
        }
        a2.initial = s2;
        a2.deterministic = false;
        a2.clearHashCode();
        a2.checkMinimizeAlways();
        return a2;
    }

    public static Automaton repeat(Automaton a2, int min2) {
        if (min2 == 0) {
            return BasicOperations.repeat(a2);
        }
        ArrayList<Automaton> as = new ArrayList<Automaton>();
        while (min2-- > 0) {
            as.add(a2);
        }
        as.add(BasicOperations.repeat(a2));
        return BasicOperations.concatenate(as);
    }

    public static Automaton repeat(Automaton a2, int min2, int max2) {
        Automaton b2;
        if (min2 > max2) {
            return BasicAutomata.makeEmpty();
        }
        max2 -= min2;
        a2.expandSingleton();
        if (min2 == 0) {
            b2 = BasicAutomata.makeEmptyString();
        } else if (min2 == 1) {
            b2 = a2.clone();
        } else {
            ArrayList<Automaton> as = new ArrayList<Automaton>();
            while (min2-- > 0) {
                as.add(a2);
            }
            b2 = BasicOperations.concatenate(as);
        }
        if (max2 > 0) {
            Automaton d2 = a2.clone();
            while (--max2 > 0) {
                Automaton c2 = a2.clone();
                for (State p : c2.getAcceptStates()) {
                    p.addEpsilon(d2.initial);
                }
                d2 = c2;
            }
            for (State p : b2.getAcceptStates()) {
                p.addEpsilon(d2.initial);
            }
            b2.deterministic = false;
            b2.clearHashCode();
            b2.checkMinimizeAlways();
        }
        return b2;
    }

    public static Automaton complement(Automaton a2) {
        a2 = a2.cloneExpandedIfRequired();
        a2.determinize();
        a2.totalize();
        for (State p : a2.getStates()) {
            p.accept = !p.accept;
        }
        a2.removeDeadTransitions();
        return a2;
    }

    public static Automaton minus(Automaton a1, Automaton a2) {
        if (a1.isEmpty() || a1 == a2) {
            return BasicAutomata.makeEmpty();
        }
        if (a2.isEmpty()) {
            return a1.cloneIfRequired();
        }
        if (a1.isSingleton()) {
            if (a2.run(a1.singleton)) {
                return BasicAutomata.makeEmpty();
            }
            return a1.cloneIfRequired();
        }
        return BasicOperations.intersection(a1, a2.complement());
    }

    public static Automaton intersection(Automaton a1, Automaton a2) {
        if (a1.isSingleton()) {
            if (a2.run(a1.singleton)) {
                return a1.cloneIfRequired();
            }
            return BasicAutomata.makeEmpty();
        }
        if (a2.isSingleton()) {
            if (a1.run(a2.singleton)) {
                return a2.cloneIfRequired();
            }
            return BasicAutomata.makeEmpty();
        }
        if (a1 == a2) {
            return a1.cloneIfRequired();
        }
        Transition[][] transitions1 = Automaton.getSortedTransitions(a1.getStates());
        Transition[][] transitions2 = Automaton.getSortedTransitions(a2.getStates());
        Automaton c2 = new Automaton();
        LinkedList<StatePair> worklist = new LinkedList<StatePair>();
        HashMap<StatePair, StatePair> newstates = new HashMap<StatePair, StatePair>();
        StatePair p = new StatePair(c2.initial, a1.initial, a2.initial);
        worklist.add(p);
        newstates.put(p, p);
        while (worklist.size() > 0) {
            p = (StatePair)worklist.removeFirst();
            p.s.accept = p.s1.accept && p.s2.accept;
            Transition[] t1 = transitions1[p.s1.number];
            Transition[] t2 = transitions2[p.s2.number];
            int b2 = 0;
            for (int n1 = 0; n1 < t1.length; ++n1) {
                while (b2 < t2.length && t2[b2].max < t1[n1].min) {
                    ++b2;
                }
                for (int n2 = b2; n2 < t2.length && t1[n1].max >= t2[n2].min; ++n2) {
                    if (t2[n2].max < t1[n1].min) continue;
                    StatePair q = new StatePair(t1[n1].to, t2[n2].to);
                    StatePair r = (StatePair)newstates.get(q);
                    if (r == null) {
                        q.s = new State();
                        worklist.add(q);
                        newstates.put(q, q);
                        r = q;
                    }
                    char min2 = t1[n1].min > t2[n2].min ? t1[n1].min : t2[n2].min;
                    char max2 = t1[n1].max < t2[n2].max ? t1[n1].max : t2[n2].max;
                    p.s.transitions.add(new Transition(min2, max2, r.s));
                }
            }
        }
        c2.deterministic = a1.deterministic && a2.deterministic;
        c2.removeDeadTransitions();
        c2.checkMinimizeAlways();
        return c2;
    }

    public static boolean subsetOf(Automaton a1, Automaton a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1.isSingleton()) {
            if (a2.isSingleton()) {
                return a1.singleton.equals(a2.singleton);
            }
            return a2.run(a1.singleton);
        }
        a2.determinize();
        Transition[][] transitions1 = Automaton.getSortedTransitions(a1.getStates());
        Transition[][] transitions2 = Automaton.getSortedTransitions(a2.getStates());
        LinkedList<StatePair> worklist = new LinkedList<StatePair>();
        HashSet<StatePair> visited = new HashSet<StatePair>();
        StatePair p = new StatePair(a1.initial, a2.initial);
        worklist.add(p);
        visited.add(p);
        while (worklist.size() > 0) {
            p = (StatePair)worklist.removeFirst();
            if (p.s1.accept && !p.s2.accept) {
                return false;
            }
            Transition[] t1 = transitions1[p.s1.number];
            Transition[] t2 = transitions2[p.s2.number];
            int b2 = 0;
            for (int n1 = 0; n1 < t1.length; ++n1) {
                while (b2 < t2.length && t2[b2].max < t1[n1].min) {
                    ++b2;
                }
                char min1 = t1[n1].min;
                char max1 = t1[n1].max;
                for (int n2 = b2; n2 < t2.length && t1[n1].max >= t2[n2].min; ++n2) {
                    if (t2[n2].min > min1) {
                        return false;
                    }
                    if (t2[n2].max < '\uffff') {
                        min1 = t2[n2].max + '\u0001';
                    } else {
                        min1 = '\uffff';
                        max1 = '\u0000';
                    }
                    StatePair q = new StatePair(t1[n1].to, t2[n2].to);
                    if (visited.contains(q)) continue;
                    worklist.add(q);
                    visited.add(q);
                }
                if (min1 > max1) continue;
                return false;
            }
        }
        return true;
    }

    public static Automaton union(Automaton a1, Automaton a2) {
        if (a1.isSingleton() && a2.isSingleton() && a1.singleton.equals(a2.singleton) || a1 == a2) {
            return a1.cloneIfRequired();
        }
        a1 = a1.cloneExpandedIfRequired();
        a2 = a2.cloneExpandedIfRequired();
        State s2 = new State();
        s2.addEpsilon(a1.initial);
        s2.addEpsilon(a2.initial);
        a1.initial = s2;
        a1.deterministic = false;
        a1.clearHashCode();
        a1.checkMinimizeAlways();
        return a1;
    }

    public static Automaton union(Collection<Automaton> l) {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Automaton a2 : l) {
            ids.add(System.identityHashCode(a2));
        }
        boolean has_aliases = ids.size() != l.size();
        State s2 = new State();
        for (Automaton b2 : l) {
            if (b2.isEmpty()) continue;
            Automaton bb = b2;
            bb = has_aliases ? bb.cloneExpanded() : bb.cloneExpandedIfRequired();
            s2.addEpsilon(bb.initial);
        }
        Automaton a3 = new Automaton();
        a3.initial = s2;
        a3.deterministic = false;
        a3.clearHashCode();
        a3.checkMinimizeAlways();
        return a3;
    }

    public static void determinize(Automaton a2) {
        if (a2.deterministic || a2.isSingleton()) {
            return;
        }
        HashSet<State> initialset = new HashSet<State>();
        initialset.add(a2.initial);
        BasicOperations.determinize(a2, initialset);
    }

    static void determinize(Automaton a2, Set<State> initialset) {
        char[] points = a2.getStartPoints();
        LinkedList<Set<State>> worklist = new LinkedList<Set<State>>();
        HashMap<Set<State>, State> newstate = new HashMap<Set<State>, State>();
        worklist.add(initialset);
        a2.initial = new State();
        newstate.put(initialset, a2.initial);
        while (worklist.size() > 0) {
            Set s2 = (Set)worklist.removeFirst();
            State r = (State)newstate.get(s2);
            for (State q : s2) {
                if (!q.accept) continue;
                r.accept = true;
                break;
            }
            for (int n = 0; n < points.length; ++n) {
                HashSet<State> p = new HashSet<State>();
                for (State q : s2) {
                    for (Transition t2 : q.transitions) {
                        if (t2.min > points[n] || points[n] > t2.max) continue;
                        p.add(t2.to);
                    }
                }
                if (p.isEmpty()) continue;
                State q = (State)newstate.get(p);
                if (q == null) {
                    worklist.add(p);
                    q = new State();
                    newstate.put(p, q);
                }
                char min2 = points[n];
                char max2 = n + 1 < points.length ? (char)((char)(points[n + 1] - '\u0001')) : (char)'\uffff';
                r.transitions.add(new Transition(min2, max2, q));
            }
        }
        a2.deterministic = true;
        a2.removeDeadTransitions();
    }

    public static void addEpsilons(Automaton a2, Collection<StatePair> pairs2) {
        a2.expandSingleton();
        HashMap<State, HashSet<State>> forward = new HashMap<State, HashSet<State>>();
        HashMap<State, HashSet<State>> back = new HashMap<State, HashSet<State>>();
        for (StatePair p : pairs2) {
            HashSet<State> to = (HashSet<State>)forward.get(p.s1);
            if (to == null) {
                to = new HashSet<State>();
                forward.put(p.s1, to);
            }
            to.add(p.s2);
            HashSet<State> from2 = (HashSet<State>)back.get(p.s2);
            if (from2 == null) {
                from2 = new HashSet<State>();
                back.put(p.s2, from2);
            }
            from2.add(p.s1);
        }
        LinkedList<StatePair> worklist = new LinkedList<StatePair>(pairs2);
        HashSet<StatePair> workset = new HashSet<StatePair>(pairs2);
        while (!worklist.isEmpty()) {
            StatePair p = worklist.removeFirst();
            workset.remove(p);
            HashSet to = (HashSet)forward.get(p.s2);
            HashSet from3 = (HashSet)back.get(p.s1);
            if (to == null) continue;
            for (State s2 : to) {
                StatePair pp = new StatePair(p.s1, s2);
                if (pairs2.contains(pp)) continue;
                pairs2.add(pp);
                ((HashSet)forward.get(p.s1)).add(s2);
                ((HashSet)back.get(s2)).add(p.s1);
                worklist.add(pp);
                workset.add(pp);
                if (from3 == null) continue;
                for (State q : from3) {
                    StatePair qq = new StatePair(q, p.s1);
                    if (workset.contains(qq)) continue;
                    worklist.add(qq);
                    workset.add(qq);
                }
            }
        }
        for (StatePair p : pairs2) {
            p.s1.addEpsilon(p.s2);
        }
        a2.deterministic = false;
        a2.clearHashCode();
        a2.checkMinimizeAlways();
    }

    public static boolean isEmptyString(Automaton a2) {
        if (a2.isSingleton()) {
            return a2.singleton.length() == 0;
        }
        return a2.initial.accept && a2.initial.transitions.isEmpty();
    }

    public static boolean isEmpty(Automaton a2) {
        if (a2.isSingleton()) {
            return false;
        }
        return !a2.initial.accept && a2.initial.transitions.isEmpty();
    }

    public static boolean isTotal(Automaton a2) {
        if (a2.isSingleton()) {
            return false;
        }
        if (a2.initial.accept && a2.initial.transitions.size() == 1) {
            Transition t2 = a2.initial.transitions.iterator().next();
            return t2.to == a2.initial && t2.min == '\u0000' && t2.max == '\uffff';
        }
        return false;
    }

    public static String getShortestExample(Automaton a2, boolean accepted) {
        if (a2.isSingleton()) {
            if (accepted) {
                return a2.singleton;
            }
            if (a2.singleton.length() > 0) {
                return "";
            }
            return "\u0000";
        }
        return BasicOperations.getShortestExample(a2.getInitialState(), accepted);
    }

    static String getShortestExample(State s2, boolean accepted) {
        HashMap<State, String> path2 = new HashMap<State, String>();
        LinkedList<State> queue = new LinkedList<State>();
        path2.put(s2, "");
        queue.add(s2);
        String best = null;
        while (!queue.isEmpty()) {
            State q = (State)queue.removeFirst();
            String p = (String)path2.get(q);
            if (q.accept == accepted) {
                if (best != null && p.length() >= best.length() && (p.length() != best.length() || p.compareTo(best) >= 0)) continue;
                best = p;
                continue;
            }
            for (Transition t2 : q.getTransitions()) {
                String tp = (String)path2.get(t2.to);
                String np = p + t2.min;
                if (tp != null && (tp.length() != np.length() || np.compareTo(tp) >= 0)) continue;
                if (tp == null) {
                    queue.addLast(t2.to);
                }
                path2.put(t2.to, np);
            }
        }
        return best;
    }

    public static boolean run(Automaton a2, String s2) {
        if (a2.isSingleton()) {
            return s2.equals(a2.singleton);
        }
        if (a2.deterministic) {
            State p = a2.initial;
            for (int i2 = 0; i2 < s2.length(); ++i2) {
                State q = p.step(s2.charAt(i2));
                if (q == null) {
                    return false;
                }
                p = q;
            }
            return p.accept;
        }
        Set<State> states = a2.getStates();
        Automaton.setStateNumbers(states);
        LinkedList<State> pp = new LinkedList<State>();
        LinkedList<State> pp_other = new LinkedList<State>();
        BitSet bb = new BitSet(states.size());
        BitSet bb_other = new BitSet(states.size());
        pp.add(a2.initial);
        ArrayList<State> dest = new ArrayList<State>();
        boolean accept2 = a2.initial.accept;
        for (int i3 = 0; i3 < s2.length(); ++i3) {
            char c2 = s2.charAt(i3);
            accept2 = false;
            pp_other.clear();
            bb_other.clear();
            for (State p : pp) {
                dest.clear();
                p.step(c2, dest);
                for (State q : dest) {
                    if (q.accept) {
                        accept2 = true;
                    }
                    if (bb_other.get(q.number)) continue;
                    bb_other.set(q.number);
                    pp_other.add(q);
                }
            }
            LinkedList<State> tp = pp;
            pp = pp_other;
            pp_other = tp;
            BitSet tb = bb;
            bb = bb_other;
            bb_other = tb;
        }
        return accept2;
    }
}

