/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicOperations;
import dk.brics.automaton.SpecialOperations;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class MinimizationOperations {
    private MinimizationOperations() {
    }

    public static void minimize(Automaton a2) {
        if (!a2.isSingleton()) {
            switch (Automaton.minimization) {
                case 0: {
                    MinimizationOperations.minimizeHuffman(a2);
                    break;
                }
                case 1: {
                    MinimizationOperations.minimizeBrzozowski(a2);
                    break;
                }
                case 3: {
                    MinimizationOperations.minimizeValmari(a2);
                    break;
                }
                default: {
                    MinimizationOperations.minimizeHopcroft(a2);
                }
            }
        }
        a2.recomputeHashCode();
    }

    private static boolean statesAgree(Transition[][] transitions, boolean[][] mark, int n1, int n2) {
        Transition[] t1 = transitions[n1];
        Transition[] t2 = transitions[n2];
        int k1 = 0;
        int k2 = 0;
        while (k1 < t1.length && k2 < t2.length) {
            if (t1[k1].max < t2[k2].min) {
                ++k1;
                continue;
            }
            if (t2[k2].max < t1[k1].min) {
                ++k2;
                continue;
            }
            int m1 = t1[k1].to.number;
            int m22 = t2[k2].to.number;
            if (m1 > m22) {
                int t3 = m1;
                m1 = m22;
                m22 = t3;
            }
            if (mark[m1][m22]) {
                return false;
            }
            if (t1[k1].max < t2[k2].max) {
                ++k1;
                continue;
            }
            ++k2;
        }
        return true;
    }

    private static void addTriggers(Transition[][] transitions, ArrayList<ArrayList<HashSet<IntPair>>> triggers, int n1, int n2) {
        Transition[] t1 = transitions[n1];
        Transition[] t2 = transitions[n2];
        int k1 = 0;
        int k2 = 0;
        while (k1 < t1.length && k2 < t2.length) {
            if (t1[k1].max < t2[k2].min) {
                ++k1;
                continue;
            }
            if (t2[k2].max < t1[k1].min) {
                ++k2;
                continue;
            }
            if (t1[k1].to != t2[k2].to) {
                int m1 = t1[k1].to.number;
                int m22 = t2[k2].to.number;
                if (m1 > m22) {
                    int t3 = m1;
                    m1 = m22;
                    m22 = t3;
                }
                if (triggers.get(m1).get(m22) == null) {
                    triggers.get(m1).set(m22, new HashSet());
                }
                triggers.get(m1).get(m22).add(new IntPair(n1, n2));
            }
            if (t1[k1].max < t2[k2].max) {
                ++k1;
                continue;
            }
            ++k2;
        }
    }

    private static void markPair(boolean[][] mark, ArrayList<ArrayList<HashSet<IntPair>>> triggers, int n1, int n2) {
        mark[n1][n2] = true;
        if (triggers.get(n1).get(n2) != null) {
            for (IntPair p : triggers.get(n1).get(n2)) {
                int m1 = p.n1;
                int m22 = p.n2;
                if (m1 > m22) {
                    int t2 = m1;
                    m1 = m22;
                    m22 = t2;
                }
                if (mark[m1][m22]) continue;
                MinimizationOperations.markPair(mark, triggers, m1, m22);
            }
        }
    }

    private static <T> void initialize(ArrayList<T> list, int size2) {
        for (int i2 = 0; i2 < size2; ++i2) {
            list.add(null);
        }
    }

    public static void minimizeHuffman(Automaton a2) {
        int n;
        int n1;
        a2.determinize();
        a2.totalize();
        Set<State> ss = a2.getStates();
        Transition[][] transitions = new Transition[ss.size()][];
        State[] states = ss.toArray(new State[ss.size()]);
        boolean[][] mark = new boolean[states.length][states.length];
        ArrayList<ArrayList<HashSet<IntPair>>> triggers = new ArrayList<ArrayList<HashSet<IntPair>>>();
        for (n1 = 0; n1 < states.length; ++n1) {
            ArrayList v = new ArrayList();
            MinimizationOperations.initialize(v, states.length);
            triggers.add(v);
        }
        for (n1 = 0; n1 < states.length; ++n1) {
            states[n1].number = n1;
            transitions[n1] = states[n1].getSortedTransitionArray(false);
            for (int n2 = n1 + 1; n2 < states.length; ++n2) {
                if (states[n1].accept == states[n2].accept) continue;
                mark[n1][n2] = true;
            }
        }
        for (n1 = 0; n1 < states.length; ++n1) {
            for (int n2 = n1 + 1; n2 < states.length; ++n2) {
                if (mark[n1][n2]) continue;
                if (MinimizationOperations.statesAgree(transitions, mark, n1, n2)) {
                    MinimizationOperations.addTriggers(transitions, triggers, n1, n2);
                    continue;
                }
                MinimizationOperations.markPair(mark, triggers, n1, n2);
            }
        }
        int numclasses = 0;
        for (int n2 = 0; n2 < states.length; ++n2) {
            states[n2].number = -1;
        }
        for (int n12 = 0; n12 < states.length; ++n12) {
            if (states[n12].number != -1) continue;
            states[n12].number = numclasses;
            for (int n2 = n12 + 1; n2 < states.length; ++n2) {
                if (mark[n12][n2]) continue;
                states[n2].number = numclasses;
            }
            ++numclasses;
        }
        State[] newstates = new State[numclasses];
        for (n = 0; n < numclasses; ++n) {
            newstates[n] = new State();
        }
        for (n = 0; n < states.length; ++n) {
            newstates[states[n].number].number = n;
            if (states[n] != a2.initial) continue;
            a2.initial = newstates[states[n].number];
        }
        for (n = 0; n < numclasses; ++n) {
            State s2 = newstates[n];
            s2.accept = states[s2.number].accept;
            for (Transition t2 : states[s2.number].transitions) {
                s2.transitions.add(new Transition(t2.min, t2.max, newstates[t2.to.number]));
            }
        }
        a2.removeDeadTransitions();
    }

    public static void minimizeBrzozowski(Automaton a2) {
        if (a2.isSingleton()) {
            return;
        }
        BasicOperations.determinize(a2, SpecialOperations.reverse(a2));
        BasicOperations.determinize(a2, SpecialOperations.reverse(a2));
    }

    public static void minimizeHopcroft(Automaton a2) {
        int n;
        int q;
        a2.determinize();
        Set<Transition> tr = a2.initial.getTransitions();
        if (tr.size() == 1) {
            Transition t2 = tr.iterator().next();
            if (t2.to == a2.initial && t2.min == '\u0000' && t2.max == '\uffff') {
                return;
            }
        }
        a2.totalize();
        Set<State> ss = a2.getStates();
        State[] states = new State[ss.size()];
        int number = 0;
        Iterator<State> iterator2 = ss.iterator();
        while (iterator2.hasNext()) {
            State q2;
            states[number] = q2 = iterator2.next();
            q2.number = number++;
        }
        char[] sigma = a2.getStartPoints();
        ArrayList reverse2 = new ArrayList();
        for (int q3 = 0; q3 < states.length; ++q3) {
            ArrayList v = new ArrayList();
            MinimizationOperations.initialize(v, sigma.length);
            reverse2.add(v);
        }
        boolean[][] reverse_nonempty = new boolean[states.length][sigma.length];
        ArrayList partition = new ArrayList();
        MinimizationOperations.initialize(partition, states.length);
        int[] block2 = new int[states.length];
        StateList[][] active = new StateList[states.length][sigma.length];
        StateListNode[][] active2 = new StateListNode[states.length][sigma.length];
        LinkedList<IntPair> pending = new LinkedList<IntPair>();
        boolean[][] pending2 = new boolean[sigma.length][states.length];
        ArrayList<State> split2 = new ArrayList<State>();
        boolean[] split22 = new boolean[states.length];
        ArrayList<Integer> refine = new ArrayList<Integer>();
        boolean[] refine2 = new boolean[states.length];
        ArrayList splitblock = new ArrayList();
        MinimizationOperations.initialize(splitblock, states.length);
        for (q = 0; q < states.length; ++q) {
            splitblock.set(q, new ArrayList());
            partition.set(q, new LinkedList());
            for (int x = 0; x < sigma.length; ++x) {
                ((ArrayList)reverse2.get(q)).set(x, new LinkedList());
                active[q][x] = new StateList();
            }
        }
        for (q = 0; q < states.length; ++q) {
            State qq = states[q];
            int j2 = qq.accept ? 0 : 1;
            ((LinkedList)partition.get(j2)).add(qq);
            block2[qq.number] = j2;
            for (int x = 0; x < sigma.length; ++x) {
                char y = sigma[x];
                State p = qq.step(y);
                ((LinkedList)((ArrayList)reverse2.get(p.number)).get(x)).add(qq);
                reverse_nonempty[p.number][x] = true;
            }
        }
        for (int j3 = 0; j3 <= 1; ++j3) {
            for (int x = 0; x < sigma.length; ++x) {
                for (State qq : (LinkedList)partition.get(j3)) {
                    if (!reverse_nonempty[qq.number][x]) continue;
                    active2[qq.number][x] = active[j3][x].add(qq);
                }
            }
        }
        for (int x = 0; x < sigma.length; ++x) {
            int a0 = active[0][x].size;
            int a1 = active[1][x].size;
            int j4 = a0 <= a1 ? 0 : 1;
            pending.add(new IntPair(j4, x));
            pending2[x][j4] = true;
        }
        int k2 = 2;
        while (!pending.isEmpty()) {
            IntPair ip = (IntPair)pending.removeFirst();
            int p = ip.n1;
            int x = ip.n2;
            pending2[x][p] = false;
            StateListNode m4 = active[p][x].first;
            while (m4 != null) {
                for (State s2 : (LinkedList)((ArrayList)reverse2.get(m4.q.number)).get(x)) {
                    if (split22[s2.number]) continue;
                    split22[s2.number] = true;
                    split2.add(s2);
                    int j5 = block2[s2.number];
                    ((ArrayList)splitblock.get(j5)).add(s2);
                    if (refine2[j5]) continue;
                    refine2[j5] = true;
                    refine.add(j5);
                }
                m4 = m4.next;
            }
            Iterator iterator3 = refine.iterator();
            while (iterator3.hasNext()) {
                int j6 = (Integer)iterator3.next();
                if (((ArrayList)splitblock.get(j6)).size() < ((LinkedList)partition.get(j6)).size()) {
                    LinkedList b1 = (LinkedList)partition.get(j6);
                    LinkedList b2 = (LinkedList)partition.get(k2);
                    for (State s3 : (ArrayList)splitblock.get(j6)) {
                        b1.remove(s3);
                        b2.add(s3);
                        block2[s3.number] = k2;
                        for (int c2 = 0; c2 < sigma.length; ++c2) {
                            StateListNode sn = active2[s3.number][c2];
                            if (sn == null || sn.sl != active[j6][c2]) continue;
                            sn.remove();
                            active2[s3.number][c2] = active[k2][c2].add(s3);
                        }
                    }
                    for (int c3 = 0; c3 < sigma.length; ++c3) {
                        int aj = active[j6][c3].size;
                        int ak = active[k2][c3].size;
                        if (!pending2[c3][j6] && 0 < aj && aj <= ak) {
                            pending2[c3][j6] = true;
                            pending.add(new IntPair(j6, c3));
                            continue;
                        }
                        pending2[c3][k2] = true;
                        pending.add(new IntPair(k2, c3));
                    }
                    ++k2;
                }
                for (State s4 : (ArrayList)splitblock.get(j6)) {
                    split22[s4.number] = false;
                }
                refine2[j6] = false;
                ((ArrayList)splitblock.get(j6)).clear();
            }
            split2.clear();
            refine.clear();
        }
        State[] newstates = new State[k2];
        for (n = 0; n < newstates.length; ++n) {
            State s5;
            newstates[n] = s5 = new State();
            for (State q4 : (LinkedList)partition.get(n)) {
                if (q4 == a2.initial) {
                    a2.initial = s5;
                }
                s5.accept = q4.accept;
                s5.number = q4.number;
                q4.number = n;
            }
        }
        for (n = 0; n < newstates.length; ++n) {
            State s6 = newstates[n];
            s6.accept = states[s6.number].accept;
            for (Transition t3 : states[s6.number].transitions) {
                s6.transitions.add(new Transition(t3.min, t3.max, newstates[t3.to.number]));
            }
        }
        a2.removeDeadTransitions();
    }

    public static void minimizeValmari(Automaton automaton) {
        automaton.determinize();
        Set<State> states = automaton.getStates();
        MinimizationOperations.splitTransitions(states);
        int stateCount = states.size();
        int transitionCount = automaton.getNumberOfTransitions();
        Set<State> acceptStates = automaton.getAcceptStates();
        Partition blocks = new Partition(stateCount);
        Partition cords = new Partition(transitionCount);
        IntPair[] labels = new IntPair[transitionCount];
        int[] tails = new int[transitionCount];
        int[] heads = new int[transitionCount];
        Automaton.setStateNumbers(states);
        int number = 0;
        for (State s2 : automaton.getStates()) {
            for (Transition t2 : s2.getTransitions()) {
                tails[number] = s2.number;
                labels[number] = new IntPair(t2.min, t2.max);
                heads[number] = t2.getDest().number;
                ++number;
            }
        }
        for (State s2 : acceptStates) {
            blocks.mark(s2.number);
        }
        blocks.split();
        if (transitionCount > 0) {
            Arrays.sort(cords.elements, new LabelComparator(labels));
            cords.markedElementCount[0] = 0;
            cords.setCount = 0;
            IntPair a2 = labels[cords.elements[0]];
            int i2 = 0;
            while (i2 < transitionCount) {
                int t3 = cords.elements[i2];
                if (labels[t3].n1 != a2.n1 || labels[t3].n2 != a2.n2) {
                    a2 = labels[t3];
                    cords.past[cords.setCount++] = i2;
                    cords.first[cords.setCount] = i2;
                    cords.markedElementCount[cords.setCount] = 0;
                }
                cords.setNo[t3] = cords.setCount;
                cords.locations[t3] = i2++;
            }
            cords.past[cords.setCount++] = transitionCount;
        }
        int[] A2 = new int[transitionCount];
        int[] F = new int[stateCount + 1];
        MinimizationOperations.makeAdjacent(A2, F, heads, stateCount, transitionCount);
        for (int c2 = 0; c2 < cords.setCount; ++c2) {
            for (int i3 = cords.first[c2]; i3 < cords.past[c2]; ++i3) {
                blocks.mark(tails[cords.elements[i3]]);
            }
            blocks.split();
            for (int b2 = 1; b2 < blocks.setCount; ++b2) {
                for (int i4 = blocks.first[b2]; i4 < blocks.past[b2]; ++i4) {
                    for (int j2 = F[blocks.elements[i4]]; j2 < F[blocks.elements[i4] + 1]; ++j2) {
                        cords.mark(A2[j2]);
                    }
                }
                cords.split();
            }
        }
        State[] newStates = new State[blocks.setCount];
        for (int bl = 0; bl < blocks.setCount; ++bl) {
            newStates[bl] = new State();
            if (blocks.first[bl] >= acceptStates.size()) continue;
            newStates[bl].accept = true;
        }
        for (int t4 = 0; t4 < transitionCount; ++t4) {
            if (blocks.locations[tails[t4]] != blocks.first[blocks.setNo[tails[t4]]]) continue;
            State tail = newStates[blocks.setNo[tails[t4]]];
            State head2 = newStates[blocks.setNo[heads[t4]]];
            tail.addTransition(new Transition((char)labels[t4].n1, (char)labels[t4].n2, head2));
        }
        automaton.setInitialState(newStates[blocks.setNo[automaton.getInitialState().number]]);
        automaton.reduce();
    }

    private static void makeAdjacent(int[] A2, int[] F, int[] K2, int nn, int mm4) {
        int t2;
        int q;
        for (q = 0; q <= nn; ++q) {
            F[q] = 0;
        }
        for (t2 = 0; t2 < mm4; ++t2) {
            int n = K2[t2];
            F[n] = F[n] + 1;
        }
        for (q = 0; q < nn; ++q) {
            int n = q + 1;
            F[n] = F[n] + F[q];
        }
        t2 = mm4;
        while (t2-- > 0) {
            int n = K2[t2];
            int n2 = F[n] - 1;
            F[n] = n2;
            A2[n2] = t2;
        }
    }

    private static void splitTransitions(Set<State> states) {
        TreeSet<Character> pointSet = new TreeSet<Character>();
        for (State s2 : states) {
            for (Transition t2 : s2.getTransitions()) {
                pointSet.add(Character.valueOf(t2.min));
                pointSet.add(Character.valueOf(t2.max));
            }
        }
        for (State s2 : states) {
            Set<Transition> transitions = s2.getTransitions();
            s2.resetTransitions();
            for (Transition t3 : transitions) {
                if (t3.min == t3.max) {
                    s2.addTransition(t3);
                    continue;
                }
                NavigableSet<Character> headSet = pointSet.headSet(Character.valueOf(t3.max), true);
                NavigableSet<Character> tailSet = pointSet.tailSet(Character.valueOf(t3.min), false);
                TreeSet<Character> intersection = new TreeSet<Character>((SortedSet<Character>)headSet);
                intersection.retainAll(tailSet);
                char start2 = t3.min;
                for (Character c2 : intersection) {
                    s2.addTransition(new Transition(start2, t3.to));
                    s2.addTransition(new Transition(c2.charValue(), t3.to));
                    if (c2.charValue() - start2 > 1) {
                        s2.addTransition(new Transition((char)(start2 + '\u0001'), (char)(c2.charValue() - '\u0001'), t3.to));
                    }
                    start2 = c2.charValue();
                }
            }
        }
    }

    static class IntPair {
        int n1;
        int n2;

        IntPair(int n1, int n2) {
            this.n1 = n1;
            this.n2 = n2;
        }
    }

    static class StateList {
        int size;
        StateListNode first;
        StateListNode last;

        StateList() {
        }

        StateListNode add(State q) {
            return new StateListNode(q, this);
        }
    }

    static class StateListNode {
        State q;
        StateListNode next;
        StateListNode prev;
        StateList sl;

        StateListNode(State q, StateList sl) {
            this.q = q;
            this.sl = sl;
            if (sl.size++ == 0) {
                sl.first = sl.last = this;
            } else {
                sl.last.next = this;
                this.prev = sl.last;
                sl.last = this;
            }
        }

        void remove() {
            --this.sl.size;
            if (this.sl.first == this) {
                this.sl.first = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.sl.last == this) {
                this.sl.last = this.prev;
            } else {
                this.next.prev = this.prev;
            }
        }
    }

    static class Partition {
        int[] markedElementCount;
        int[] touchedSets;
        int touchedSetCount;
        int setCount;
        Integer[] elements;
        int[] locations;
        int[] setNo;
        int[] first;
        int[] past;

        Partition(int size2) {
            this.setCount = size2 == 0 ? 0 : 1;
            this.elements = new Integer[size2];
            this.locations = new int[size2];
            this.setNo = new int[size2];
            this.first = new int[size2];
            this.past = new int[size2];
            this.markedElementCount = new int[size2];
            this.touchedSets = new int[size2];
            for (int i2 = 0; i2 < size2; ++i2) {
                this.locations[i2] = i2;
                this.elements[i2] = this.locations[i2];
                this.setNo[i2] = 0;
            }
            if (this.setCount != 0) {
                this.first[0] = 0;
                this.past[0] = size2;
            }
        }

        void mark(int e2) {
            int s2 = this.setNo[e2];
            int i2 = this.locations[e2];
            int j2 = this.first[s2] + this.markedElementCount[s2];
            this.elements[i2] = this.elements[j2];
            this.locations[this.elements[i2].intValue()] = i2;
            this.elements[j2] = e2;
            this.locations[e2] = j2;
            int n = s2;
            int n2 = this.markedElementCount[n];
            this.markedElementCount[n] = n2 + 1;
            if (n2 == 0) {
                this.touchedSets[this.touchedSetCount++] = s2;
            }
        }

        void split() {
            while (this.touchedSetCount > 0) {
                int s2;
                int j2;
                if ((j2 = this.first[s2 = this.touchedSets[--this.touchedSetCount]] + this.markedElementCount[s2]) == this.past[s2]) {
                    this.markedElementCount[s2] = 0;
                    continue;
                }
                if (this.markedElementCount[s2] <= this.past[s2] - j2) {
                    this.first[this.setCount] = this.first[s2];
                    this.past[this.setCount] = this.first[s2] = j2;
                } else {
                    this.past[this.setCount] = this.past[s2];
                    this.first[this.setCount] = this.past[s2] = j2;
                }
                for (int i2 = this.first[this.setCount]; i2 < this.past[this.setCount]; ++i2) {
                    this.setNo[this.elements[i2].intValue()] = this.setCount;
                }
                this.markedElementCount[this.setCount++] = 0;
                this.markedElementCount[s2] = 0;
            }
        }
    }

    static class LabelComparator
    implements Comparator<Integer> {
        private IntPair[] labels;

        LabelComparator(IntPair[] labels) {
            this.labels = labels;
        }

        @Override
        public int compare(Integer i2, Integer j2) {
            IntPair p1 = this.labels[i2];
            IntPair p2 = this.labels[j2];
            if (p1.n1 < p2.n1) {
                return -1;
            }
            if (p1.n1 > p2.n1) {
                return 1;
            }
            if (p1.n2 < p2.n2) {
                return -1;
            }
            if (p1.n2 > p2.n2) {
                return 1;
            }
            return 0;
        }
    }
}

