/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.AutomatonProvider;
import dk.brics.automaton.BasicAutomata;
import dk.brics.automaton.BasicOperations;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RegExp {
    public static final int INTERSECTION = 1;
    public static final int COMPLEMENT = 2;
    public static final int EMPTY = 4;
    public static final int ANYSTRING = 8;
    public static final int AUTOMATON = 16;
    public static final int INTERVAL = 32;
    public static final int ALL = 65535;
    public static final int NONE = 0;
    private static boolean allow_mutation = false;
    Kind kind;
    RegExp exp1;
    RegExp exp2;
    String s;
    char c;
    int min;
    int max;
    int digits;
    char from;
    char to;
    String b;
    int flags;
    int pos;

    RegExp() {
    }

    public RegExp(String s2) throws IllegalArgumentException {
        this(s2, 65535);
    }

    public RegExp(String s2, int syntax_flags) throws IllegalArgumentException {
        RegExp e2;
        this.b = s2;
        this.flags = syntax_flags;
        if (s2.length() == 0) {
            e2 = RegExp.makeString("");
        } else {
            e2 = this.parseUnionExp();
            if (this.pos < this.b.length()) {
                throw new IllegalArgumentException("end-of-string expected at position " + this.pos);
            }
        }
        this.kind = e2.kind;
        this.exp1 = e2.exp1;
        this.exp2 = e2.exp2;
        this.s = e2.s;
        this.c = e2.c;
        this.min = e2.min;
        this.max = e2.max;
        this.digits = e2.digits;
        this.from = e2.from;
        this.to = e2.to;
        this.b = null;
    }

    public Automaton toAutomaton() {
        return this.toAutomatonAllowMutate(null, null, true);
    }

    public Automaton toAutomaton(boolean minimize) {
        return this.toAutomatonAllowMutate(null, null, minimize);
    }

    public Automaton toAutomaton(AutomatonProvider automaton_provider) throws IllegalArgumentException {
        return this.toAutomatonAllowMutate(null, automaton_provider, true);
    }

    public Automaton toAutomaton(AutomatonProvider automaton_provider, boolean minimize) throws IllegalArgumentException {
        return this.toAutomatonAllowMutate(null, automaton_provider, minimize);
    }

    public Automaton toAutomaton(Map<String, Automaton> automata) throws IllegalArgumentException {
        return this.toAutomatonAllowMutate(automata, null, true);
    }

    public Automaton toAutomaton(Map<String, Automaton> automata, boolean minimize) throws IllegalArgumentException {
        return this.toAutomatonAllowMutate(automata, null, minimize);
    }

    public boolean setAllowMutate(boolean flag) {
        boolean b2 = allow_mutation;
        allow_mutation = flag;
        return b2;
    }

    private Automaton toAutomatonAllowMutate(Map<String, Automaton> automata, AutomatonProvider automaton_provider, boolean minimize) throws IllegalArgumentException {
        boolean b2 = false;
        if (allow_mutation) {
            b2 = Automaton.setAllowMutate(true);
        }
        Automaton a2 = this.toAutomaton(automata, automaton_provider, minimize);
        if (allow_mutation) {
            Automaton.setAllowMutate(b2);
        }
        return a2;
    }

    private Automaton toAutomaton(Map<String, Automaton> automata, AutomatonProvider automaton_provider, boolean minimize) throws IllegalArgumentException {
        Automaton a2 = null;
        switch (this.kind) {
            case REGEXP_UNION: {
                ArrayList<Automaton> list = new ArrayList<Automaton>();
                this.findLeaves(this.exp1, Kind.REGEXP_UNION, list, automata, automaton_provider, minimize);
                this.findLeaves(this.exp2, Kind.REGEXP_UNION, list, automata, automaton_provider, minimize);
                a2 = BasicOperations.union(list);
                if (!minimize) break;
                a2.minimize();
                break;
            }
            case REGEXP_CONCATENATION: {
                ArrayList<Automaton> list = new ArrayList<Automaton>();
                this.findLeaves(this.exp1, Kind.REGEXP_CONCATENATION, list, automata, automaton_provider, minimize);
                this.findLeaves(this.exp2, Kind.REGEXP_CONCATENATION, list, automata, automaton_provider, minimize);
                a2 = BasicOperations.concatenate(list);
                if (!minimize) break;
                a2.minimize();
                break;
            }
            case REGEXP_INTERSECTION: {
                a2 = this.exp1.toAutomaton(automata, automaton_provider, minimize).intersection(this.exp2.toAutomaton(automata, automaton_provider, minimize));
                if (!minimize) break;
                a2.minimize();
                break;
            }
            case REGEXP_OPTIONAL: {
                a2 = this.exp1.toAutomaton(automata, automaton_provider, minimize).optional();
                if (!minimize) break;
                a2.minimize();
                break;
            }
            case REGEXP_REPEAT: {
                a2 = this.exp1.toAutomaton(automata, automaton_provider, minimize).repeat();
                if (!minimize) break;
                a2.minimize();
                break;
            }
            case REGEXP_REPEAT_MIN: {
                a2 = this.exp1.toAutomaton(automata, automaton_provider, minimize).repeat(this.min);
                if (!minimize) break;
                a2.minimize();
                break;
            }
            case REGEXP_REPEAT_MINMAX: {
                a2 = this.exp1.toAutomaton(automata, automaton_provider, minimize).repeat(this.min, this.max);
                if (!minimize) break;
                a2.minimize();
                break;
            }
            case REGEXP_COMPLEMENT: {
                a2 = this.exp1.toAutomaton(automata, automaton_provider, minimize).complement();
                if (!minimize) break;
                a2.minimize();
                break;
            }
            case REGEXP_CHAR: {
                a2 = BasicAutomata.makeChar(this.c);
                break;
            }
            case REGEXP_CHAR_RANGE: {
                a2 = BasicAutomata.makeCharRange(this.from, this.to);
                break;
            }
            case REGEXP_ANYCHAR: {
                a2 = BasicAutomata.makeAnyChar();
                break;
            }
            case REGEXP_EMPTY: {
                a2 = BasicAutomata.makeEmpty();
                break;
            }
            case REGEXP_STRING: {
                a2 = BasicAutomata.makeString(this.s);
                break;
            }
            case REGEXP_ANYSTRING: {
                a2 = BasicAutomata.makeAnyString();
                break;
            }
            case REGEXP_AUTOMATON: {
                Automaton aa = null;
                if (automata != null) {
                    aa = automata.get(this.s);
                }
                if (aa == null && automaton_provider != null) {
                    try {
                        aa = automaton_provider.getAutomaton(this.s);
                    }
                    catch (IOException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                }
                if (aa == null) {
                    throw new IllegalArgumentException("'" + this.s + "' not found");
                }
                a2 = aa.clone();
                break;
            }
            case REGEXP_INTERVAL: {
                a2 = BasicAutomata.makeInterval(this.min, this.max, this.digits);
            }
        }
        return a2;
    }

    private void findLeaves(RegExp exp2, Kind kind, List<Automaton> list, Map<String, Automaton> automata, AutomatonProvider automaton_provider, boolean minimize) {
        if (exp2.kind == kind) {
            this.findLeaves(exp2.exp1, kind, list, automata, automaton_provider, minimize);
            this.findLeaves(exp2.exp2, kind, list, automata, automaton_provider, minimize);
        } else {
            list.add(exp2.toAutomaton(automata, automaton_provider, minimize));
        }
    }

    public String toString() {
        return this.toStringBuilder(new StringBuilder()).toString();
    }

    StringBuilder toStringBuilder(StringBuilder b2) {
        switch (this.kind) {
            case REGEXP_UNION: {
                b2.append("(");
                this.exp1.toStringBuilder(b2);
                b2.append("|");
                this.exp2.toStringBuilder(b2);
                b2.append(")");
                break;
            }
            case REGEXP_CONCATENATION: {
                this.exp1.toStringBuilder(b2);
                this.exp2.toStringBuilder(b2);
                break;
            }
            case REGEXP_INTERSECTION: {
                b2.append("(");
                this.exp1.toStringBuilder(b2);
                b2.append("&");
                this.exp2.toStringBuilder(b2);
                b2.append(")");
                break;
            }
            case REGEXP_OPTIONAL: {
                b2.append("(");
                this.exp1.toStringBuilder(b2);
                b2.append(")?");
                break;
            }
            case REGEXP_REPEAT: {
                b2.append("(");
                this.exp1.toStringBuilder(b2);
                b2.append(")*");
                break;
            }
            case REGEXP_REPEAT_MIN: {
                b2.append("(");
                this.exp1.toStringBuilder(b2);
                b2.append("){").append(this.min).append(",}");
                break;
            }
            case REGEXP_REPEAT_MINMAX: {
                b2.append("(");
                this.exp1.toStringBuilder(b2);
                b2.append("){").append(this.min).append(",").append(this.max).append("}");
                break;
            }
            case REGEXP_COMPLEMENT: {
                b2.append("~(");
                this.exp1.toStringBuilder(b2);
                b2.append(")");
                break;
            }
            case REGEXP_CHAR: {
                this.appendChar(this.c, b2);
                break;
            }
            case REGEXP_CHAR_RANGE: {
                b2.append("[\\").append(this.from).append("-\\").append(this.to).append("]");
                break;
            }
            case REGEXP_ANYCHAR: {
                b2.append(".");
                break;
            }
            case REGEXP_EMPTY: {
                b2.append("#");
                break;
            }
            case REGEXP_STRING: {
                if (this.s.indexOf(34) == -1) {
                    b2.append("\"").append(this.s).append("\"");
                    break;
                }
                for (int i2 = 0; i2 < this.s.length(); ++i2) {
                    this.appendChar(this.s.charAt(i2), b2);
                }
                break;
            }
            case REGEXP_ANYSTRING: {
                b2.append("@");
                break;
            }
            case REGEXP_AUTOMATON: {
                b2.append("<").append(this.s).append(">");
                break;
            }
            case REGEXP_INTERVAL: {
                int i3;
                String s1 = Integer.toString(this.min);
                String s2 = Integer.toString(this.max);
                b2.append("<");
                if (this.digits > 0) {
                    for (i3 = s1.length(); i3 < this.digits; ++i3) {
                        b2.append('0');
                    }
                }
                b2.append(s1).append("-");
                if (this.digits > 0) {
                    for (i3 = s2.length(); i3 < this.digits; ++i3) {
                        b2.append('0');
                    }
                }
                b2.append(s2).append(">");
            }
        }
        return b2;
    }

    private void appendChar(char c2, StringBuilder b2) {
        if ("|&?*+{},![]^-.#@\"()<>\\".indexOf(c2) != -1) {
            b2.append("\\");
        }
        b2.append(c2);
    }

    public Set<String> getIdentifiers() {
        HashSet<String> set2 = new HashSet<String>();
        this.getIdentifiers(set2);
        return set2;
    }

    void getIdentifiers(Set<String> set2) {
        switch (this.kind) {
            case REGEXP_UNION: 
            case REGEXP_CONCATENATION: 
            case REGEXP_INTERSECTION: {
                this.exp1.getIdentifiers(set2);
                this.exp2.getIdentifiers(set2);
                break;
            }
            case REGEXP_OPTIONAL: 
            case REGEXP_REPEAT: 
            case REGEXP_REPEAT_MIN: 
            case REGEXP_REPEAT_MINMAX: 
            case REGEXP_COMPLEMENT: {
                this.exp1.getIdentifiers(set2);
                break;
            }
            case REGEXP_AUTOMATON: {
                set2.add(this.s);
                break;
            }
        }
    }

    static RegExp makeUnion(RegExp exp1, RegExp exp2) {
        RegExp r = new RegExp();
        r.kind = Kind.REGEXP_UNION;
        r.exp1 = exp1;
        r.exp2 = exp2;
        return r;
    }

    static RegExp makeConcatenation(RegExp exp1, RegExp exp2) {
        if (!(exp1.kind != Kind.REGEXP_CHAR && exp1.kind != Kind.REGEXP_STRING || exp2.kind != Kind.REGEXP_CHAR && exp2.kind != Kind.REGEXP_STRING)) {
            return RegExp.makeString(exp1, exp2);
        }
        RegExp r = new RegExp();
        r.kind = Kind.REGEXP_CONCATENATION;
        if (!(exp1.kind != Kind.REGEXP_CONCATENATION || exp1.exp2.kind != Kind.REGEXP_CHAR && exp1.exp2.kind != Kind.REGEXP_STRING || exp2.kind != Kind.REGEXP_CHAR && exp2.kind != Kind.REGEXP_STRING)) {
            r.exp1 = exp1.exp1;
            r.exp2 = RegExp.makeString(exp1.exp2, exp2);
        } else if (!(exp1.kind != Kind.REGEXP_CHAR && exp1.kind != Kind.REGEXP_STRING || exp2.kind != Kind.REGEXP_CONCATENATION || exp2.exp1.kind != Kind.REGEXP_CHAR && exp2.exp1.kind != Kind.REGEXP_STRING)) {
            r.exp1 = RegExp.makeString(exp1, exp2.exp1);
            r.exp2 = exp2.exp2;
        } else {
            r.exp1 = exp1;
            r.exp2 = exp2;
        }
        return r;
    }

    private static RegExp makeString(RegExp exp1, RegExp exp2) {
        StringBuilder b2 = new StringBuilder();
        if (exp1.kind == Kind.REGEXP_STRING) {
            b2.append(exp1.s);
        } else {
            b2.append(exp1.c);
        }
        if (exp2.kind == Kind.REGEXP_STRING) {
            b2.append(exp2.s);
        } else {
            b2.append(exp2.c);
        }
        return RegExp.makeString(b2.toString());
    }

    static RegExp makeIntersection(RegExp exp1, RegExp exp2) {
        RegExp r = new RegExp();
        r.kind = Kind.REGEXP_INTERSECTION;
        r.exp1 = exp1;
        r.exp2 = exp2;
        return r;
    }

    static RegExp makeOptional(RegExp exp2) {
        RegExp r = new RegExp();
        r.kind = Kind.REGEXP_OPTIONAL;
        r.exp1 = exp2;
        return r;
    }

    static RegExp makeRepeat(RegExp exp2) {
        RegExp r = new RegExp();
        r.kind = Kind.REGEXP_REPEAT;
        r.exp1 = exp2;
        return r;
    }

    static RegExp makeRepeat(RegExp exp2, int min2) {
        RegExp r = new RegExp();
        r.kind = Kind.REGEXP_REPEAT_MIN;
        r.exp1 = exp2;
        r.min = min2;
        return r;
    }

    static RegExp makeRepeat(RegExp exp2, int min2, int max2) {
        RegExp r = new RegExp();
        r.kind = Kind.REGEXP_REPEAT_MINMAX;
        r.exp1 = exp2;
        r.min = min2;
        r.max = max2;
        return r;
    }

    static RegExp makeComplement(RegExp exp2) {
        RegExp r = new RegExp();
        r.kind = Kind.REGEXP_COMPLEMENT;
        r.exp1 = exp2;
        return r;
    }

    static RegExp makeChar(char c2) {
        RegExp r = new RegExp();
        r.kind = Kind.REGEXP_CHAR;
        r.c = c2;
        return r;
    }

    static RegExp makeCharRange(char from2, char to) {
        RegExp r = new RegExp();
        r.kind = Kind.REGEXP_CHAR_RANGE;
        r.from = from2;
        r.to = to;
        return r;
    }

    static RegExp makeAnyChar() {
        RegExp r = new RegExp();
        r.kind = Kind.REGEXP_ANYCHAR;
        return r;
    }

    static RegExp makeEmpty() {
        RegExp r = new RegExp();
        r.kind = Kind.REGEXP_EMPTY;
        return r;
    }

    static RegExp makeString(String s2) {
        RegExp r = new RegExp();
        r.kind = Kind.REGEXP_STRING;
        r.s = s2;
        return r;
    }

    static RegExp makeAnyString() {
        RegExp r = new RegExp();
        r.kind = Kind.REGEXP_ANYSTRING;
        return r;
    }

    static RegExp makeAutomaton(String s2) {
        RegExp r = new RegExp();
        r.kind = Kind.REGEXP_AUTOMATON;
        r.s = s2;
        return r;
    }

    static RegExp makeInterval(int min2, int max2, int digits) {
        RegExp r = new RegExp();
        r.kind = Kind.REGEXP_INTERVAL;
        r.min = min2;
        r.max = max2;
        r.digits = digits;
        return r;
    }

    private boolean peek(String s2) {
        return this.more() && s2.indexOf(this.b.charAt(this.pos)) != -1;
    }

    private boolean match(char c2) {
        if (this.pos >= this.b.length()) {
            return false;
        }
        if (this.b.charAt(this.pos) == c2) {
            ++this.pos;
            return true;
        }
        return false;
    }

    private boolean more() {
        return this.pos < this.b.length();
    }

    private char next() throws IllegalArgumentException {
        if (!this.more()) {
            throw new IllegalArgumentException("unexpected end-of-string");
        }
        return this.b.charAt(this.pos++);
    }

    private boolean check(int flag) {
        return (this.flags & flag) != 0;
    }

    final RegExp parseUnionExp() throws IllegalArgumentException {
        RegExp e2 = this.parseInterExp();
        if (this.match('|')) {
            e2 = RegExp.makeUnion(e2, this.parseUnionExp());
        }
        return e2;
    }

    final RegExp parseInterExp() throws IllegalArgumentException {
        RegExp e2 = this.parseConcatExp();
        if (this.check(1) && this.match('&')) {
            e2 = RegExp.makeIntersection(e2, this.parseInterExp());
        }
        return e2;
    }

    final RegExp parseConcatExp() throws IllegalArgumentException {
        RegExp e2 = this.parseRepeatExp();
        if (!(!this.more() || this.peek(")|") || this.check(1) && this.peek("&"))) {
            e2 = RegExp.makeConcatenation(e2, this.parseConcatExp());
        }
        return e2;
    }

    final RegExp parseRepeatExp() throws IllegalArgumentException {
        RegExp e2 = this.parseComplExp();
        while (this.peek("?*+{")) {
            if (this.match('?')) {
                e2 = RegExp.makeOptional(e2);
                continue;
            }
            if (this.match('*')) {
                e2 = RegExp.makeRepeat(e2);
                continue;
            }
            if (this.match('+')) {
                e2 = RegExp.makeRepeat(e2, 1);
                continue;
            }
            if (!this.match('{')) continue;
            int start2 = this.pos;
            while (this.peek("0123456789")) {
                this.next();
            }
            if (start2 == this.pos) {
                throw new IllegalArgumentException("integer expected at position " + this.pos);
            }
            int n = Integer.parseInt(this.b.substring(start2, this.pos));
            int m4 = -1;
            if (this.match(',')) {
                start2 = this.pos;
                while (this.peek("0123456789")) {
                    this.next();
                }
                if (start2 != this.pos) {
                    m4 = Integer.parseInt(this.b.substring(start2, this.pos));
                }
            } else {
                m4 = n;
            }
            if (!this.match('}')) {
                throw new IllegalArgumentException("expected '}' at position " + this.pos);
            }
            if (m4 == -1) {
                e2 = RegExp.makeRepeat(e2, n);
                continue;
            }
            e2 = RegExp.makeRepeat(e2, n, m4);
        }
        return e2;
    }

    final RegExp parseComplExp() throws IllegalArgumentException {
        if (this.check(2) && this.match('~')) {
            return RegExp.makeComplement(this.parseComplExp());
        }
        return this.parseCharClassExp();
    }

    final RegExp parseCharClassExp() throws IllegalArgumentException {
        if (this.match('[')) {
            boolean negate = false;
            if (this.match('^')) {
                negate = true;
            }
            RegExp e2 = this.parseCharClasses();
            if (negate) {
                e2 = RegExp.makeIntersection(RegExp.makeAnyChar(), RegExp.makeComplement(e2));
            }
            if (!this.match(']')) {
                throw new IllegalArgumentException("expected ']' at position " + this.pos);
            }
            return e2;
        }
        return this.parseSimpleExp();
    }

    final RegExp parseCharClasses() throws IllegalArgumentException {
        RegExp e2 = this.parseCharClass();
        while (this.more() && !this.peek("]")) {
            e2 = RegExp.makeUnion(e2, this.parseCharClass());
        }
        return e2;
    }

    final RegExp parseCharClass() throws IllegalArgumentException {
        char c2 = this.parseCharExp();
        if (this.match('-')) {
            if (this.peek("]")) {
                return RegExp.makeUnion(RegExp.makeChar(c2), RegExp.makeChar('-'));
            }
            return RegExp.makeCharRange(c2, this.parseCharExp());
        }
        return RegExp.makeChar(c2);
    }

    final RegExp parseSimpleExp() throws IllegalArgumentException {
        if (this.match('.')) {
            return RegExp.makeAnyChar();
        }
        if (this.check(4) && this.match('#')) {
            return RegExp.makeEmpty();
        }
        if (this.check(8) && this.match('@')) {
            return RegExp.makeAnyString();
        }
        if (this.match('\"')) {
            int start2 = this.pos;
            while (this.more() && !this.peek("\"")) {
                this.next();
            }
            if (!this.match('\"')) {
                throw new IllegalArgumentException("expected '\"' at position " + this.pos);
            }
            return RegExp.makeString(this.b.substring(start2, this.pos - 1));
        }
        if (this.match('(')) {
            if (this.match(')')) {
                return RegExp.makeString("");
            }
            RegExp e2 = this.parseUnionExp();
            if (!this.match(')')) {
                throw new IllegalArgumentException("expected ')' at position " + this.pos);
            }
            return e2;
        }
        if ((this.check(16) || this.check(32)) && this.match('<')) {
            int start3 = this.pos;
            while (this.more() && !this.peek(">")) {
                this.next();
            }
            if (!this.match('>')) {
                throw new IllegalArgumentException("expected '>' at position " + this.pos);
            }
            String s2 = this.b.substring(start3, this.pos - 1);
            int i2 = s2.indexOf(45);
            if (i2 == -1) {
                if (!this.check(16)) {
                    throw new IllegalArgumentException("interval syntax error at position " + (this.pos - 1));
                }
                return RegExp.makeAutomaton(s2);
            }
            if (!this.check(32)) {
                throw new IllegalArgumentException("illegal identifier at position " + (this.pos - 1));
            }
            try {
                if (i2 == 0 || i2 == s2.length() - 1 || i2 != s2.lastIndexOf(45)) {
                    throw new NumberFormatException();
                }
                String smin = s2.substring(0, i2);
                String smax = s2.substring(i2 + 1, s2.length());
                int imin = Integer.parseInt(smin);
                int imax = Integer.parseInt(smax);
                int digits = smin.length() == smax.length() ? smin.length() : 0;
                if (imin > imax) {
                    int t2 = imin;
                    imin = imax;
                    imax = t2;
                }
                return RegExp.makeInterval(imin, imax, digits);
            }
            catch (NumberFormatException e3) {
                throw new IllegalArgumentException("interval syntax error at position " + (this.pos - 1));
            }
        }
        return RegExp.makeChar(this.parseCharExp());
    }

    final char parseCharExp() throws IllegalArgumentException {
        this.match('\\');
        return this.next();
    }

    static enum Kind {
        REGEXP_UNION,
        REGEXP_CONCATENATION,
        REGEXP_INTERSECTION,
        REGEXP_OPTIONAL,
        REGEXP_REPEAT,
        REGEXP_REPEAT_MIN,
        REGEXP_REPEAT_MINMAX,
        REGEXP_COMPLEMENT,
        REGEXP_CHAR,
        REGEXP_CHAR_RANGE,
        REGEXP_ANYCHAR,
        REGEXP_EMPTY,
        REGEXP_STRING,
        REGEXP_ANYSTRING,
        REGEXP_AUTOMATON,
        REGEXP_INTERVAL;

    }
}

