/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.AutomatonMatcher;
import dk.brics.automaton.SpecialOperations;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Set;

public class RunAutomaton
implements Serializable {
    static final long serialVersionUID = 20001L;
    int size;
    boolean[] accept;
    int initial;
    int[] transitions;
    char[] points;
    int[] classmap;

    void setAlphabet() {
        this.classmap = new int[65536];
        int i2 = 0;
        for (char j2 = '\u0000'; j2 <= '\uffff'; ++j2) {
            if (i2 + 1 >= this.points.length || j2 == this.points[i2 + 1]) {
                // empty if block
            }
            this.classmap[j2] = ++i2;
        }
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder();
        b2.append("initial state: ").append(this.initial).append("\n");
        for (int i2 = 0; i2 < this.size; ++i2) {
            b2.append("state ").append(i2);
            if (this.accept[i2]) {
                b2.append(" [accept]:\n");
            } else {
                b2.append(" [reject]:\n");
            }
            for (int j2 = 0; j2 < this.points.length; ++j2) {
                int k2 = this.transitions[i2 * this.points.length + j2];
                if (k2 == -1) continue;
                char min2 = this.points[j2];
                char max2 = j2 + 1 < this.points.length ? (char)((char)(this.points[j2 + 1] - '\u0001')) : (char)'\uffff';
                b2.append(" ");
                Transition.appendCharString(min2, b2);
                if (min2 != max2) {
                    b2.append("-");
                    Transition.appendCharString(max2, b2);
                }
                b2.append(" -> ").append(k2).append("\n");
            }
        }
        return b2.toString();
    }

    public int getSize() {
        return this.size;
    }

    public boolean isAccept(int state) {
        return this.accept[state];
    }

    public int getInitialState() {
        return this.initial;
    }

    public char[] getCharIntervals() {
        return (char[])this.points.clone();
    }

    int getCharClass(char c2) {
        return SpecialOperations.findIndex(c2, this.points);
    }

    private RunAutomaton() {
    }

    public RunAutomaton(Automaton a2) {
        this(a2, true);
    }

    public static RunAutomaton load(URL url2) throws IOException, ClassCastException, ClassNotFoundException {
        return RunAutomaton.load(url2.openStream());
    }

    public static RunAutomaton load(InputStream stream) throws IOException, ClassCastException, ClassNotFoundException {
        ObjectInputStream s2 = new ObjectInputStream(stream);
        return (RunAutomaton)s2.readObject();
    }

    public void store(OutputStream stream) throws IOException {
        ObjectOutputStream s2 = new ObjectOutputStream(stream);
        s2.writeObject(this);
        s2.flush();
    }

    public RunAutomaton(Automaton a2, boolean tableize) {
        a2.determinize();
        this.points = a2.getStartPoints();
        Set<State> states = a2.getStates();
        Automaton.setStateNumbers(states);
        this.initial = a2.initial.number;
        this.size = states.size();
        this.accept = new boolean[this.size];
        this.transitions = new int[this.size * this.points.length];
        for (int n = 0; n < this.size * this.points.length; ++n) {
            this.transitions[n] = -1;
        }
        for (State s2 : states) {
            int n = s2.number;
            this.accept[n] = s2.accept;
            for (int c2 = 0; c2 < this.points.length; ++c2) {
                State q = s2.step(this.points[c2]);
                if (q == null) continue;
                this.transitions[n * this.points.length + c2] = q.number;
            }
        }
        if (tableize) {
            this.setAlphabet();
        }
    }

    public int step(int state, char c2) {
        if (this.classmap == null) {
            return this.transitions[state * this.points.length + this.getCharClass(c2)];
        }
        return this.transitions[state * this.points.length + this.classmap[c2 - '\u0000']];
    }

    public boolean run(String s2) {
        int p = this.initial;
        int l = s2.length();
        for (int i2 = 0; i2 < l; ++i2) {
            if ((p = this.step(p, s2.charAt(i2))) != -1) continue;
            return false;
        }
        return this.accept[p];
    }

    public int run(String s2, int offset) {
        int p = this.initial;
        int l = s2.length();
        int max2 = -1;
        int r = 0;
        while (offset <= l) {
            if (this.accept[p]) {
                max2 = r;
            }
            if (offset == l || (p = this.step(p, s2.charAt(offset))) == -1) break;
            ++offset;
            ++r;
        }
        return max2;
    }

    public AutomatonMatcher newMatcher(CharSequence s2) {
        return new AutomatonMatcher(s2, this);
    }

    public AutomatonMatcher newMatcher(CharSequence s2, int startOffset, int endOffset) {
        return new AutomatonMatcher(s2.subSequence(startOffset, endOffset), this);
    }
}

