/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicOperations;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.Transition;
import dk.brics.automaton.TransitionComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public final class ShuffleOperations {
    private ShuffleOperations() {
    }

    public static Automaton shuffle(Automaton a1, Automaton a2) {
        State s2;
        a1.determinize();
        a2.determinize();
        Transition[][] transitions1 = Automaton.getSortedTransitions(a1.getStates());
        Transition[][] transitions2 = Automaton.getSortedTransitions(a2.getStates());
        Automaton c2 = new Automaton();
        LinkedList<StatePair> worklist = new LinkedList<StatePair>();
        HashMap<StatePair, StatePair> newstates = new HashMap<StatePair, StatePair>();
        c2.initial = s2 = new State();
        StatePair p = new StatePair(s2, a1.initial, a2.initial);
        worklist.add(p);
        newstates.put(p, p);
        while (worklist.size() > 0) {
            p = (StatePair)worklist.removeFirst();
            p.s.accept = p.s1.accept && p.s2.accept;
            Transition[] t1 = transitions1[p.s1.number];
            for (int n1 = 0; n1 < t1.length; ++n1) {
                StatePair q = new StatePair(t1[n1].to, p.s2);
                StatePair r = (StatePair)newstates.get(q);
                if (r == null) {
                    q.s = new State();
                    worklist.add(q);
                    newstates.put(q, q);
                    r = q;
                }
                p.s.transitions.add(new Transition(t1[n1].min, t1[n1].max, r.s));
            }
            Transition[] t2 = transitions2[p.s2.number];
            for (int n2 = 0; n2 < t2.length; ++n2) {
                StatePair q = new StatePair(p.s1, t2[n2].to);
                StatePair r = (StatePair)newstates.get(q);
                if (r == null) {
                    q.s = new State();
                    worklist.add(q);
                    newstates.put(q, q);
                    r = q;
                }
                p.s.transitions.add(new Transition(t2[n2].min, t2[n2].max, r.s));
            }
        }
        c2.deterministic = false;
        c2.removeDeadTransitions();
        c2.checkMinimizeAlways();
        return c2;
    }

    public static String shuffleSubsetOf(Collection<Automaton> ca, Automaton a2, Character suspend_shuffle, Character resume_shuffle) {
        if (ca.size() == 0) {
            return null;
        }
        if (ca.size() == 1) {
            Automaton a1 = ca.iterator().next();
            if (a1.isSingleton()) {
                if (a2.run(a1.singleton)) {
                    return null;
                }
                return a1.singleton;
            }
            if (a1 == a2) {
                return null;
            }
        }
        a2.determinize();
        Transition[][][] ca_transitions = new Transition[ca.size()][][];
        int i2 = 0;
        for (Automaton a1 : ca) {
            ca_transitions[i2++] = Automaton.getSortedTransitions(a1.getStates());
        }
        Transition[][] a_transitions = Automaton.getSortedTransitions(a2.getStates());
        TransitionComparator tc = new TransitionComparator(false);
        ShuffleConfiguration init = new ShuffleConfiguration(ca, a2);
        LinkedList<ShuffleConfiguration> pending = new LinkedList<ShuffleConfiguration>();
        HashSet<ShuffleConfiguration> visited = new HashSet<ShuffleConfiguration>();
        pending.add(init);
        visited.add(init);
        block1: while (!pending.isEmpty()) {
            ShuffleConfiguration c2 = (ShuffleConfiguration)pending.removeFirst();
            boolean good = true;
            for (int i1 = 0; i1 < ca.size(); ++i1) {
                if (c2.ca_states[i1].accept) continue;
                good = false;
                break;
            }
            if (c2.a_state.accept) {
                good = false;
            }
            if (good) {
                StringBuilder sb = new StringBuilder();
                while (c2.prev != null) {
                    sb.append(c2.min);
                    c2 = c2.prev;
                }
                StringBuilder sb2 = new StringBuilder();
                for (int j2 = sb.length() - 1; j2 >= 0; --j2) {
                    sb2.append(sb.charAt(j2));
                }
                return sb2.toString();
            }
            Transition[] ta2 = a_transitions[c2.a_state.number];
            for (int i1 = 0; i1 < ca.size(); ++i1) {
                if (c2.shuffle_suspended) {
                    i1 = c2.suspended1;
                }
                block6: for (Transition t1 : ca_transitions[i1][c2.ca_states[i1].number]) {
                    char min2;
                    ArrayList<Transition> lt = new ArrayList<Transition>();
                    int j3 = Arrays.binarySearch(ta2, t1, tc);
                    if (j3 < 0) {
                        j3 = -j3 - 1;
                    }
                    if (j3 > 0 && ta2[j3 - 1].max >= t1.min) {
                        --j3;
                    }
                    while (j3 < ta2.length) {
                        Transition t2 = ta2[j3++];
                        min2 = t1.min;
                        char max2 = t1.max;
                        if (t2.min > min2) {
                            min2 = t2.min;
                        }
                        if (t2.max < max2) {
                            max2 = t2.max;
                        }
                        if (min2 > max2) break;
                        ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, min2, max2);
                        lt.add(new Transition(min2, max2, null));
                    }
                    Transition[] at = lt.toArray(new Transition[lt.size()]);
                    Arrays.sort(at, tc);
                    min2 = t1.min;
                    for (int k2 = 0; k2 < at.length && at[k2].min <= min2; ++k2) {
                        if (at[k2].max >= t1.max) continue block6;
                        min2 = (char)(at[k2].max + '\u0001');
                    }
                    ShuffleConfiguration nc = new ShuffleConfiguration(c2, i1, t1.to, min2);
                    StringBuilder sb = new StringBuilder();
                    ShuffleConfiguration b2 = nc;
                    while (b2.prev != null) {
                        sb.append(b2.min);
                        b2 = b2.prev;
                    }
                    StringBuilder sb2 = new StringBuilder();
                    for (int m4 = sb.length() - 1; m4 >= 0; --m4) {
                        sb2.append(sb.charAt(m4));
                    }
                    if (c2.shuffle_suspended) {
                        sb2.append(BasicOperations.getShortestExample(nc.ca_states[c2.suspended1], true));
                    }
                    for (i1 = 0; i1 < ca.size(); ++i1) {
                        if (c2.shuffle_suspended && i1 == c2.suspended1) continue;
                        sb2.append(BasicOperations.getShortestExample(nc.ca_states[i1], true));
                    }
                    return sb2.toString();
                }
                if (c2.shuffle_suspended) continue block1;
            }
        }
        return null;
    }

    private static void add(Character suspend_shuffle, Character resume_shuffle, LinkedList<ShuffleConfiguration> pending, Set<ShuffleConfiguration> visited, ShuffleConfiguration c2, int i1, Transition t1, Transition t2, char min2, char max2) {
        int HIGH_SURROGATE_BEGIN = 55296;
        int HIGH_SURROGATE_END = 56319;
        if (suspend_shuffle != null && min2 <= suspend_shuffle.charValue() && suspend_shuffle.charValue() <= max2 && min2 != max2) {
            if (min2 < suspend_shuffle.charValue()) {
                ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, min2, (char)(suspend_shuffle.charValue() - '\u0001'));
            }
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, suspend_shuffle.charValue(), suspend_shuffle.charValue());
            if (suspend_shuffle.charValue() < max2) {
                ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, (char)(suspend_shuffle.charValue() + '\u0001'), max2);
            }
        } else if (resume_shuffle != null && min2 <= resume_shuffle.charValue() && resume_shuffle.charValue() <= max2 && min2 != max2) {
            if (min2 < resume_shuffle.charValue()) {
                ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, min2, (char)(resume_shuffle.charValue() - '\u0001'));
            }
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, resume_shuffle.charValue(), resume_shuffle.charValue());
            if (resume_shuffle.charValue() < max2) {
                ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, (char)(resume_shuffle.charValue() + '\u0001'), max2);
            }
        } else if (min2 < '\ud800' && max2 >= '\ud800') {
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, min2, '\ud7ff');
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, '\ud800', max2);
        } else if (min2 <= '\udbff' && max2 > '\udbff') {
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, min2, '\udbff');
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, '\udc00', max2);
        } else {
            ShuffleConfiguration nc = new ShuffleConfiguration(c2, i1, t1.to, t2.to, min2);
            if (suspend_shuffle != null && min2 == suspend_shuffle.charValue()) {
                nc.shuffle_suspended = true;
                nc.suspended1 = i1;
            } else if (resume_shuffle != null && min2 == resume_shuffle.charValue()) {
                nc.shuffle_suspended = false;
            }
            if (min2 >= '\ud800' && min2 <= '\ud800') {
                nc.shuffle_suspended = true;
                nc.suspended1 = i1;
                nc.surrogate = true;
            }
            if (!visited.contains(nc)) {
                pending.add(nc);
                visited.add(nc);
            }
        }
    }

    static class ShuffleConfiguration {
        ShuffleConfiguration prev;
        State[] ca_states;
        State a_state;
        char min;
        int hash;
        boolean shuffle_suspended;
        boolean surrogate;
        int suspended1;

        private ShuffleConfiguration() {
        }

        ShuffleConfiguration(Collection<Automaton> ca, Automaton a2) {
            this.ca_states = new State[ca.size()];
            int i2 = 0;
            for (Automaton a1 : ca) {
                this.ca_states[i2++] = a1.getInitialState();
            }
            this.a_state = a2.getInitialState();
            this.computeHash();
        }

        ShuffleConfiguration(ShuffleConfiguration c2, int i1, State s1, char min2) {
            this.prev = c2;
            this.ca_states = (State[])c2.ca_states.clone();
            this.a_state = c2.a_state;
            this.ca_states[i1] = s1;
            this.min = min2;
            this.computeHash();
        }

        ShuffleConfiguration(ShuffleConfiguration c2, int i1, State s1, State s2, char min2) {
            this.prev = c2;
            this.ca_states = (State[])c2.ca_states.clone();
            this.a_state = c2.a_state;
            this.ca_states[i1] = s1;
            this.a_state = s2;
            this.min = min2;
            if (!this.surrogate) {
                this.shuffle_suspended = c2.shuffle_suspended;
                this.suspended1 = c2.suspended1;
            }
            this.computeHash();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ShuffleConfiguration) {
                ShuffleConfiguration c2 = (ShuffleConfiguration)obj;
                return this.shuffle_suspended == c2.shuffle_suspended && this.surrogate == c2.surrogate && this.suspended1 == c2.suspended1 && Arrays.equals(this.ca_states, c2.ca_states) && this.a_state == c2.a_state;
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }

        private void computeHash() {
            this.hash = 0;
            for (int i2 = 0; i2 < this.ca_states.length; ++i2) {
                this.hash ^= this.ca_states[i2].hashCode();
            }
            this.hash ^= this.a_state.hashCode() * 100;
            if (this.shuffle_suspended || this.surrogate) {
                this.hash += this.suspended1;
            }
        }
    }
}

