/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicAutomata;
import dk.brics.automaton.Datatypes;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.Transition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class SpecialOperations {
    private SpecialOperations() {
    }

    public static Set<State> reverse(Automaton a2) {
        HashMap m4 = new HashMap();
        Set<State> states = a2.getStates();
        Set<State> accept2 = a2.getAcceptStates();
        for (State r : states) {
            m4.put(r, new HashSet());
            r.accept = false;
        }
        for (State r : states) {
            for (Transition t2 : r.getTransitions()) {
                ((HashSet)m4.get(t2.to)).add(new Transition(t2.min, t2.max, r));
            }
        }
        for (State r : states) {
            r.transitions = (Set)m4.get(r);
        }
        a2.initial.accept = true;
        a2.initial = new State();
        for (State r : accept2) {
            a2.initial.addEpsilon(r);
        }
        a2.deterministic = false;
        return accept2;
    }

    public static Automaton overlap(Automaton a1, Automaton a2) {
        Automaton b1 = a1.cloneExpanded();
        b1.determinize();
        SpecialOperations.acceptToAccept(b1);
        Automaton b2 = a2.cloneExpanded();
        SpecialOperations.reverse(b2);
        b2.determinize();
        SpecialOperations.acceptToAccept(b2);
        SpecialOperations.reverse(b2);
        b2.determinize();
        return b1.intersection(b2).minus(BasicAutomata.makeEmptyString());
    }

    private static void acceptToAccept(Automaton a2) {
        State s2 = new State();
        for (State r : a2.getAcceptStates()) {
            s2.addEpsilon(r);
        }
        a2.initial = s2;
        a2.deterministic = false;
    }

    public static Automaton singleChars(Automaton a2) {
        State s2;
        Automaton b2 = new Automaton();
        b2.initial = s2 = new State();
        State q = new State();
        q.accept = true;
        if (a2.isSingleton()) {
            for (int i2 = 0; i2 < a2.singleton.length(); ++i2) {
                s2.transitions.add(new Transition(a2.singleton.charAt(i2), q));
            }
        } else {
            for (State p : a2.getStates()) {
                for (Transition t2 : p.transitions) {
                    s2.transitions.add(new Transition(t2.min, t2.max, q));
                }
            }
        }
        b2.deterministic = true;
        b2.removeDeadTransitions();
        return b2;
    }

    public static Automaton trim(Automaton a2, String set2, char c2) {
        a2 = a2.cloneExpandedIfRequired();
        State f2 = new State();
        SpecialOperations.addSetTransitions(f2, set2, f2);
        f2.accept = true;
        for (State s2 : a2.getStates()) {
            State r = s2.step(c2);
            if (r != null) {
                State q = new State();
                SpecialOperations.addSetTransitions(q, set2, q);
                SpecialOperations.addSetTransitions(s2, set2, q);
                q.addEpsilon(r);
            }
            if (!s2.accept) continue;
            s2.addEpsilon(f2);
        }
        State p = new State();
        SpecialOperations.addSetTransitions(p, set2, p);
        p.addEpsilon(a2.initial);
        a2.initial = p;
        a2.deterministic = false;
        a2.removeDeadTransitions();
        a2.checkMinimizeAlways();
        return a2;
    }

    private static void addSetTransitions(State s2, String set2, State p) {
        for (int n = 0; n < set2.length(); ++n) {
            s2.transitions.add(new Transition(set2.charAt(n), p));
        }
    }

    public static Automaton compress(Automaton a2, String set2, char c2) {
        a2 = a2.cloneExpandedIfRequired();
        for (State s2 : a2.getStates()) {
            State r = s2.step(c2);
            if (r == null) continue;
            State q = new State();
            SpecialOperations.addSetTransitions(q, set2, q);
            SpecialOperations.addSetTransitions(s2, set2, q);
            q.addEpsilon(r);
        }
        a2.deterministic = false;
        a2.removeDeadTransitions();
        a2.checkMinimizeAlways();
        return a2;
    }

    public static Automaton subst(Automaton a2, Map<Character, Set<Character>> map2) {
        if (map2.isEmpty()) {
            return a2.cloneIfRequired();
        }
        TreeSet<Character> ckeys = new TreeSet<Character>(map2.keySet());
        char[] keys2 = new char[ckeys.size()];
        int j2 = 0;
        for (Character c2 : ckeys) {
            keys2[j2++] = c2.charValue();
        }
        a2 = a2.cloneExpandedIfRequired();
        for (State s2 : a2.getStates()) {
            Set<Transition> st = s2.transitions;
            s2.resetTransitions();
            block2: for (Transition t2 : st) {
                int index = SpecialOperations.findIndex(t2.min, keys2);
                while (t2.min <= t2.max) {
                    if (keys2[index] > t2.min) {
                        char m4 = (char)(keys2[index] - '\u0001');
                        if (t2.max < m4) {
                            m4 = t2.max;
                        }
                        s2.transitions.add(new Transition(t2.min, m4, t2.to));
                        if (m4 + '\u0001' > 65535) continue block2;
                        t2.min = (char)(m4 + '\u0001');
                        continue;
                    }
                    if (keys2[index] < t2.min) {
                        char m5 = index + 1 < keys2.length ? (char)(keys2[++index] - '\u0001') : (char)'\uffff';
                        if (t2.max < m5) {
                            m5 = t2.max;
                        }
                        s2.transitions.add(new Transition(t2.min, m5, t2.to));
                        if (m5 + '\u0001' > 65535) continue block2;
                        t2.min = (char)(m5 + '\u0001');
                        continue;
                    }
                    for (Character c3 : map2.get(Character.valueOf(t2.min))) {
                        s2.transitions.add(new Transition(c3.charValue(), t2.to));
                    }
                    if (t2.min + '\u0001' > 65535) continue block2;
                    t2.min = (char)(t2.min + '\u0001');
                    if (index + 1 >= keys2.length || keys2[index + 1] != t2.min) continue;
                    ++index;
                }
            }
        }
        a2.deterministic = false;
        a2.removeDeadTransitions();
        a2.checkMinimizeAlways();
        return a2;
    }

    static int findIndex(char c2, char[] points) {
        int a2 = 0;
        int b2 = points.length;
        while (b2 - a2 > 1) {
            int d2 = a2 + b2 >>> 1;
            if (points[d2] > c2) {
                b2 = d2;
                continue;
            }
            if (points[d2] < c2) {
                a2 = d2;
                continue;
            }
            return d2;
        }
        return a2;
    }

    public static Automaton subst(Automaton a2, char c2, String s2) {
        a2 = a2.cloneExpandedIfRequired();
        HashSet<StatePair> epsilons = new HashSet<StatePair>();
        for (State p : a2.getStates()) {
            Set<Transition> st = p.transitions;
            p.resetTransitions();
            for (Transition t2 : st) {
                if (t2.max < c2 || t2.min > c2) {
                    p.transitions.add(t2);
                    continue;
                }
                if (t2.min < c2) {
                    p.transitions.add(new Transition(t2.min, (char)(c2 - '\u0001'), t2.to));
                }
                if (t2.max > c2) {
                    p.transitions.add(new Transition((char)(c2 + '\u0001'), t2.max, t2.to));
                }
                if (s2.length() == 0) {
                    epsilons.add(new StatePair(p, t2.to));
                    continue;
                }
                State q = p;
                for (int i2 = 0; i2 < s2.length(); ++i2) {
                    State r = i2 + 1 == s2.length() ? t2.to : new State();
                    q.transitions.add(new Transition(s2.charAt(i2), r));
                    q = r;
                }
            }
        }
        a2.addEpsilons(epsilons);
        a2.deterministic = false;
        a2.removeDeadTransitions();
        a2.checkMinimizeAlways();
        return a2;
    }

    public static Automaton homomorph(Automaton a2, char[] source2, char[] dest) {
        a2 = a2.cloneExpandedIfRequired();
        for (State s2 : a2.getStates()) {
            Set<Transition> st = s2.transitions;
            s2.resetTransitions();
            for (Transition t2 : st) {
                int length;
                for (int min2 = t2.min; min2 <= t2.max; min2 += length) {
                    int n = SpecialOperations.findIndex((char)min2, source2);
                    char nmin = (char)(dest[n] + min2 - source2[n]);
                    int end2 = n + 1 == source2.length ? 65535 : source2[n + 1] - '\u0001';
                    length = end2 < t2.max ? end2 + 1 - min2 : t2.max + '\u0001' - min2;
                    s2.transitions.add(new Transition(nmin, (char)(nmin + length - 1), t2.to));
                }
            }
        }
        a2.deterministic = false;
        a2.removeDeadTransitions();
        a2.checkMinimizeAlways();
        return a2;
    }

    public static Automaton projectChars(Automaton a2, Set<Character> chars) {
        int i2;
        Character[] c2 = chars.toArray(new Character[chars.size()]);
        char[] cc = new char[c2.length];
        boolean normalchars = false;
        for (i2 = 0; i2 < c2.length; ++i2) {
            if (c2[i2] == null) {
                normalchars = true;
                continue;
            }
            cc[i2] = c2[i2].charValue();
        }
        Arrays.sort(cc);
        if (a2.isSingleton()) {
            for (i2 = 0; i2 < a2.singleton.length(); ++i2) {
                char sc = a2.singleton.charAt(i2);
                if (normalchars && (sc <= '\udfff' || sc >= '\uf900') || Arrays.binarySearch(cc, sc) >= 0) continue;
                return BasicAutomata.makeEmpty();
            }
            return a2.cloneIfRequired();
        }
        HashSet<StatePair> epsilons = new HashSet<StatePair>();
        a2 = a2.cloneExpandedIfRequired();
        for (State s2 : a2.getStates()) {
            HashSet<Transition> new_transitions = new HashSet<Transition>();
            for (Transition t2 : s2.transitions) {
                boolean addepsilon = false;
                if (t2.min < '\uf900' && t2.max > '\udfff') {
                    int w2;
                    int w1 = Arrays.binarySearch(cc, t2.min > '\ue000' ? (char)t2.min : (char)'\ue000');
                    if (w1 < 0) {
                        w1 = -w1 - 1;
                        addepsilon = true;
                    }
                    if ((w2 = Arrays.binarySearch(cc, t2.max < '\uf8ff' ? (char)t2.max : (char)'\uf8ff')) < 0) {
                        w2 = -w2 - 2;
                        addepsilon = true;
                    }
                    for (int w = w1; w <= w2; ++w) {
                        new_transitions.add(new Transition(cc[w], t2.to));
                        if (w <= w1 || cc[w - 1] + '\u0001' == cc[w]) continue;
                        addepsilon = true;
                    }
                }
                if (normalchars) {
                    if (t2.min <= '\udfff') {
                        new_transitions.add(new Transition(t2.min, t2.max < '\udfff' ? (char)t2.max : (char)'\udfff', t2.to));
                    }
                    if (t2.max >= '\uf900') {
                        new_transitions.add(new Transition(t2.min > '\uf900' ? (char)t2.min : (char)'\uf900', t2.max, t2.to));
                    }
                } else if (t2.min <= '\udfff' || t2.max >= '\uf900') {
                    addepsilon = true;
                }
                if (!addepsilon) continue;
                epsilons.add(new StatePair(s2, t2.to));
            }
            s2.transitions = new_transitions;
        }
        a2.reduce();
        a2.addEpsilons(epsilons);
        a2.removeDeadTransitions();
        a2.checkMinimizeAlways();
        return a2;
    }

    public static boolean isFinite(Automaton a2) {
        if (a2.isSingleton()) {
            return true;
        }
        return SpecialOperations.isFinite(a2.initial, new HashSet<State>(), new HashSet<State>());
    }

    private static boolean isFinite(State s2, HashSet<State> path2, HashSet<State> visited) {
        path2.add(s2);
        for (Transition t2 : s2.transitions) {
            if (!path2.contains(t2.to) && (visited.contains(t2.to) || SpecialOperations.isFinite(t2.to, path2, visited))) continue;
            return false;
        }
        path2.remove(s2);
        visited.add(s2);
        return true;
    }

    public static Set<String> getStrings(Automaton a2, int length) {
        HashSet<String> strings = new HashSet<String>();
        if (a2.isSingleton() && a2.singleton.length() == length) {
            strings.add(a2.singleton);
        } else if (length >= 0) {
            SpecialOperations.getStrings(a2.initial, strings, new StringBuilder(), length);
        }
        return strings;
    }

    private static void getStrings(State s2, Set<String> strings, StringBuilder path2, int length) {
        if (length == 0) {
            if (s2.accept) {
                strings.add(path2.toString());
            }
        } else {
            for (Transition t2 : s2.transitions) {
                for (int n = t2.min; n <= t2.max; ++n) {
                    path2.append((char)n);
                    SpecialOperations.getStrings(t2.to, strings, path2, length - 1);
                    path2.deleteCharAt(path2.length() - 1);
                }
            }
        }
    }

    public static Set<String> getFiniteStrings(Automaton a2) {
        HashSet<String> strings = new HashSet<String>();
        if (a2.isSingleton()) {
            strings.add(a2.singleton);
        } else if (!SpecialOperations.getFiniteStrings(a2.initial, new HashSet<State>(), strings, new StringBuilder(), -1)) {
            return null;
        }
        return strings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<String> getFiniteStrings(Automaton a2, int limit) {
        HashSet<String> strings = new HashSet<String>();
        if (a2.isSingleton()) {
            if (limit <= 0) return null;
            strings.add(a2.singleton);
            return strings;
        } else {
            if (SpecialOperations.getFiniteStrings(a2.initial, new HashSet<State>(), strings, new StringBuilder(), limit)) return strings;
            return null;
        }
    }

    private static boolean getFiniteStrings(State s2, HashSet<State> pathstates, HashSet<String> strings, StringBuilder path2, int limit) {
        pathstates.add(s2);
        for (Transition t2 : s2.transitions) {
            if (pathstates.contains(t2.to)) {
                return false;
            }
            for (int n = t2.min; n <= t2.max; ++n) {
                path2.append((char)n);
                if (t2.to.accept) {
                    strings.add(path2.toString());
                    if (limit >= 0 && strings.size() > limit) {
                        return false;
                    }
                }
                if (!SpecialOperations.getFiniteStrings(t2.to, pathstates, strings, path2, limit)) {
                    return false;
                }
                path2.deleteCharAt(path2.length() - 1);
            }
        }
        pathstates.remove(s2);
        return true;
    }

    public static String getCommonPrefix(Automaton a2) {
        boolean done;
        if (a2.isSingleton()) {
            return a2.singleton;
        }
        StringBuilder b2 = new StringBuilder();
        HashSet<State> visited = new HashSet<State>();
        State s2 = a2.initial;
        do {
            done = true;
            visited.add(s2);
            if (s2.accept || s2.transitions.size() != 1) continue;
            Transition t2 = s2.transitions.iterator().next();
            if (t2.min != t2.max || visited.contains(t2.to)) continue;
            b2.append(t2.min);
            s2 = t2.to;
            done = false;
        } while (!done);
        return b2.toString();
    }

    public static void prefixClose(Automaton a2) {
        for (State s2 : a2.getStates()) {
            s2.setAccept(true);
        }
        a2.clearHashCode();
        a2.checkMinimizeAlways();
    }

    public static Automaton hexCases(Automaton a2) {
        HashMap<Character, Set<Character>> map2 = new HashMap<Character, Set<Character>>();
        char c1 = 'a';
        char c2 = 'A';
        while (c1 <= 'f') {
            HashSet<Character> ws2 = new HashSet<Character>();
            ws2.add(Character.valueOf(c1));
            ws2.add(Character.valueOf(c2));
            map2.put(Character.valueOf(c1), ws2);
            map2.put(Character.valueOf(c2), ws2);
            c1 = (char)(c1 + '\u0001');
            c2 = (char)(c2 + '\u0001');
        }
        Automaton ws3 = Datatypes.getWhitespaceAutomaton();
        return ws3.concatenate(a2.subst(map2)).concatenate(ws3);
    }

    public static Automaton replaceWhitespace(Automaton a2) {
        HashMap<Character, Set<Character>> map2 = new HashMap<Character, Set<Character>>();
        HashSet<Character> ws2 = new HashSet<Character>();
        ws2.add(Character.valueOf(' '));
        ws2.add(Character.valueOf('\t'));
        ws2.add(Character.valueOf('\n'));
        ws2.add(Character.valueOf('\r'));
        map2.put(Character.valueOf(' '), ws2);
        return a2.subst(map2);
    }
}

