/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.State;
import java.io.Serializable;

public class Transition
implements Serializable,
Cloneable {
    static final long serialVersionUID = 40001L;
    char min;
    char max;
    State to;

    public Transition(char c2, State to) {
        this.min = this.max = c2;
        this.to = to;
    }

    public Transition(char min2, char max2, State to) {
        if (max2 < min2) {
            char t2 = max2;
            max2 = min2;
            min2 = t2;
        }
        this.min = min2;
        this.max = max2;
        this.to = to;
    }

    public char getMin() {
        return this.min;
    }

    public char getMax() {
        return this.max;
    }

    public State getDest() {
        return this.to;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Transition) {
            Transition t2 = (Transition)obj;
            return t2.min == this.min && t2.max == this.max && t2.to == this.to;
        }
        return false;
    }

    public int hashCode() {
        return this.min * 2 + this.max * 3;
    }

    public Transition clone() {
        try {
            return (Transition)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(e2);
        }
    }

    static void appendCharString(char c2, StringBuilder b2) {
        if (c2 >= '!' && c2 <= '~' && c2 != '\\' && c2 != '\"') {
            b2.append(c2);
        } else {
            b2.append("\\u");
            String s2 = Integer.toHexString(c2);
            if (c2 < '\u0010') {
                b2.append("000").append(s2);
            } else if (c2 < '\u0100') {
                b2.append("00").append(s2);
            } else if (c2 < '\u1000') {
                b2.append("0").append(s2);
            } else {
                b2.append(s2);
            }
        }
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder();
        Transition.appendCharString(this.min, b2);
        if (this.min != this.max) {
            b2.append("-");
            Transition.appendCharString(this.max, b2);
        }
        b2.append(" -> ").append(this.to.number);
        return b2.toString();
    }

    void appendDot(StringBuilder b2) {
        b2.append(" -> ").append(this.to.number).append(" [label=\"");
        Transition.appendCharString(this.min, b2);
        if (this.min != this.max) {
            b2.append("-");
            Transition.appendCharString(this.max, b2);
        }
        b2.append("\"]\n");
    }
}

