/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.AstNode;
import io.cucumber.gherkin.GherkinLineSpan;
import io.cucumber.gherkin.Locations;
import io.cucumber.gherkin.Parser;
import io.cucumber.gherkin.ParserException;
import io.cucumber.gherkin.Token;
import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Comment;
import io.cucumber.messages.types.DataTable;
import io.cucumber.messages.types.DocString;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.RuleChild;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.Tag;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;

class GherkinDocumentBuilder
implements Parser.Builder<GherkinDocument> {
    private final List<Comment> comments = new ArrayList<Comment>();
    private final IdGenerator idGenerator;
    private String uri;
    private Deque<AstNode> stack;

    GherkinDocumentBuilder(IdGenerator idGenerator, String uri2) {
        this.idGenerator = idGenerator;
        this.reset(uri2);
    }

    @Override
    public void reset(String uri2) {
        this.uri = uri2;
        this.stack = new ArrayDeque<AstNode>();
        this.stack.push(new AstNode(Parser.RuleType.None));
    }

    private AstNode currentNode() {
        return this.stack.peek();
    }

    @Override
    public void build(Token token2) {
        if (token2.matchedType == Parser.TokenType.Comment) {
            Comment comment = new Comment(token2.location, token2.matchedText);
            this.comments.add(comment);
        } else {
            this.currentNode().add(token2.matchedType.ruleType, token2);
        }
    }

    @Override
    public void startRule(Parser.RuleType ruleType) {
        this.stack.push(new AstNode(ruleType));
    }

    @Override
    public void endRule(Parser.RuleType ruleType) {
        AstNode node = this.stack.pop();
        Object transformedNode = this.getTransformedNode(node);
        this.currentNode().add(node.ruleType, transformedNode);
    }

    private Object getTransformedNode(AstNode node) {
        switch (node.ruleType) {
            case Step: {
                Token stepLine = node.getToken(Parser.TokenType.StepLine);
                return new Step(stepLine.location, stepLine.matchedKeyword, stepLine.keywordType, stepLine.matchedText, node.getSingle(Parser.RuleType.DocString, null), node.getSingle(Parser.RuleType.DataTable, null), this.idGenerator.newId());
            }
            case DocString: {
                Token separatorToken = node.getTokens(Parser.TokenType.DocStringSeparator).get(0);
                String mediaType = separatorToken.matchedText.isEmpty() ? null : separatorToken.matchedText;
                List<Token> lineTokens = node.getTokens(Parser.TokenType.Other);
                String content2 = GherkinDocumentBuilder.joinMatchedText(lineTokens);
                return new DocString(separatorToken.location, mediaType, content2, separatorToken.matchedKeyword);
            }
            case DataTable: {
                List<TableRow> rows2 = this.getTableRows(node);
                return new DataTable(rows2.get(0).getLocation(), rows2);
            }
            case Background: {
                Token backgroundLine = node.getToken(Parser.TokenType.BackgroundLine);
                return new Background(backgroundLine.location, backgroundLine.matchedKeyword, backgroundLine.matchedText, this.getDescription(node), this.getSteps(node), this.idGenerator.newId());
            }
            case ScenarioDefinition: {
                AstNode scenarioNode = node.getSingle(Parser.RuleType.Scenario, null);
                Token scenarioLine = scenarioNode.getToken(Parser.TokenType.ScenarioLine);
                return new Scenario(scenarioLine.location, this.getTags(node), scenarioLine.matchedKeyword, scenarioLine.matchedText, this.getDescription(scenarioNode), this.getSteps(scenarioNode), scenarioNode.getItems(Parser.RuleType.ExamplesDefinition), this.idGenerator.newId());
            }
            case ExamplesDefinition: {
                AstNode examplesNode = node.getSingle(Parser.RuleType.Examples, null);
                Token examplesLine = examplesNode.getToken(Parser.TokenType.ExamplesLine);
                List rows3 = examplesNode.getSingle(Parser.RuleType.ExamplesTable, null);
                TableRow tableHeader = rows3 != null && !rows3.isEmpty() ? (TableRow)rows3.get(0) : null;
                List<TableRow> tableBody = rows3 != null && !rows3.isEmpty() ? rows3.subList(1, rows3.size()) : Collections.emptyList();
                return new Examples(examplesLine.location, this.getTags(node), examplesLine.matchedKeyword, examplesLine.matchedText, this.getDescription(examplesNode), tableHeader, tableBody, this.idGenerator.newId());
            }
            case ExamplesTable: {
                return this.getTableRows(node);
            }
            case Description: {
                int end2;
                List<Token> lineTokens = node.getTokens(Parser.TokenType.Other);
                for (end2 = lineTokens.size(); end2 > 0 && lineTokens.get((int)(end2 - 1)).line.isEmpty(); --end2) {
                }
                lineTokens = lineTokens.subList(0, end2);
                return GherkinDocumentBuilder.joinMatchedText(lineTokens);
            }
            case Feature: {
                AstNode header = node.getSingle(Parser.RuleType.FeatureHeader, new AstNode(Parser.RuleType.FeatureHeader));
                if (header == null) {
                    return null;
                }
                List<Tag> tags = this.getTags(header);
                Token featureLine = header.getToken(Parser.TokenType.FeatureLine);
                if (featureLine == null) {
                    return null;
                }
                ArrayList<FeatureChild> children2 = new ArrayList<FeatureChild>();
                Background background = node.getSingle(Parser.RuleType.Background, null);
                if (background != null) {
                    children2.add(new FeatureChild(null, background, null));
                }
                for (Scenario scenario : node.getItems(Parser.RuleType.ScenarioDefinition)) {
                    children2.add(new FeatureChild(null, null, scenario));
                }
                for (Rule rule : node.getItems(Parser.RuleType.Rule)) {
                    children2.add(new FeatureChild(rule, null, null));
                }
                String description = this.getDescription(header);
                if (featureLine.matchedGherkinDialect == null) {
                    return null;
                }
                String language = featureLine.matchedGherkinDialect.getLanguage();
                return new Feature(featureLine.location, tags, language, featureLine.matchedKeyword, featureLine.matchedText, description, children2);
            }
            case Rule: {
                AstNode header = node.getSingle(Parser.RuleType.RuleHeader, new AstNode(Parser.RuleType.RuleHeader));
                if (header == null) {
                    return null;
                }
                Token ruleLine = header.getToken(Parser.TokenType.RuleLine);
                if (ruleLine == null) {
                    return null;
                }
                ArrayList<RuleChild> children3 = new ArrayList<RuleChild>();
                List<Tag> tags = this.getTags(header);
                Background background = node.getSingle(Parser.RuleType.Background, null);
                if (background != null) {
                    children3.add(new RuleChild(background, null));
                }
                List scenarios = node.getItems(Parser.RuleType.ScenarioDefinition);
                for (Scenario scenario : scenarios) {
                    children3.add(new RuleChild(null, scenario));
                }
                return new Rule(ruleLine.location, tags, ruleLine.matchedKeyword, ruleLine.matchedText, this.getDescription(header), children3, this.idGenerator.newId());
            }
            case GherkinDocument: {
                Feature feature = node.getSingle(Parser.RuleType.Feature, null);
                return new GherkinDocument(this.uri, feature, this.comments);
            }
        }
        return node;
    }

    private static String joinMatchedText(List<Token> lineTokens) {
        StringBuilder content2 = new StringBuilder(100 * lineTokens.size());
        for (Token lineToken : lineTokens) {
            content2.append(lineToken.matchedText).append("\n");
        }
        int contentLength = content2.length();
        if (contentLength > 0) {
            content2.setLength(contentLength - 1);
        }
        return content2.toString();
    }

    private List<TableRow> getTableRows(AstNode node) {
        List<Token> tokens = node.getTokens(Parser.TokenType.TableRow);
        ArrayList<TableRow> rows2 = new ArrayList<TableRow>(tokens.size());
        for (Token token2 : tokens) {
            rows2.add(new TableRow(token2.location, this.getCells(token2), this.idGenerator.newId()));
        }
        this.ensureCellCount(rows2);
        return rows2;
    }

    private void ensureCellCount(List<TableRow> rows2) {
        if (rows2.isEmpty()) {
            return;
        }
        int cellCount = rows2.get(0).getCells().size();
        for (TableRow row : rows2) {
            if (row.getCells().size() == cellCount) continue;
            throw new ParserException.AstBuilderException("inconsistent cell count within the table", row.getLocation());
        }
    }

    private List<TableCell> getCells(Token token2) {
        ArrayList<TableCell> cells = new ArrayList<TableCell>(token2.matchedItems.size());
        for (GherkinLineSpan cellItem : token2.matchedItems) {
            TableCell tableCell = new TableCell(Locations.atColumn(token2.location, cellItem.column), cellItem.text);
            cells.add(tableCell);
        }
        return cells;
    }

    private List<Step> getSteps(AstNode node) {
        return node.getItems(Parser.RuleType.Step);
    }

    private String getDescription(AstNode node) {
        return node.getSingle(Parser.RuleType.Description, "");
    }

    private List<Tag> getTags(AstNode node) {
        AstNode tagsNode = node.getSingle(Parser.RuleType.Tags, new AstNode(Parser.RuleType.None));
        if (tagsNode == null) {
            return Collections.emptyList();
        }
        List<Token> tokens = tagsNode.getTokens(Parser.TokenType.TagLine);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (Token token2 : tokens) {
            for (GherkinLineSpan tagItem : token2.matchedItems) {
                tags.add(new Tag(Locations.atColumn(token2.location, tagItem.column), tagItem.text, this.idGenerator.newId()));
            }
        }
        return tags;
    }

    @Override
    public GherkinDocument getResult() {
        return this.currentNode().getSingle(Parser.RuleType.GherkinDocument, null);
    }
}

