/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.GherkinLineSpan;
import io.cucumber.gherkin.Locations;
import io.cucumber.gherkin.ParserException;
import io.cucumber.gherkin.StringUtils;
import io.cucumber.messages.types.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;

class GherkinLine {
    private final String rawText;
    private final Location location;
    private final boolean empty;
    private final String text;
    private final int indent;

    GherkinLine(String rawText, Location location) {
        this.rawText = Objects.requireNonNull(rawText);
        this.location = Objects.requireNonNull(location);
        Map.Entry<String, Integer> trimmedIndent = StringUtils.trimAndIndent(rawText);
        this.text = trimmedIndent.getKey();
        this.indent = trimmedIndent.getValue();
        this.empty = this.text.isEmpty();
    }

    int getIndent() {
        return this.indent;
    }

    String getText() {
        return this.text;
    }

    String getRawText() {
        return this.rawText;
    }

    String getRawTextSubstring(int beginIndex) {
        return this.rawText.substring(beginIndex);
    }

    boolean isEmpty() {
        return this.empty;
    }

    boolean startsWith(String prefix2) {
        return this.text.startsWith(prefix2);
    }

    String substringTrimmed(int beginIndex) {
        return this.text.substring(beginIndex).trim();
    }

    List<GherkinLineSpan> parseTags() {
        if (this.empty) {
            return Collections.emptyList();
        }
        String uncommentedLine = StringUtils.removeComments(this.text);
        int indexInUncommentedLine = 0;
        String[] elements = uncommentedLine.split("@");
        if (elements.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<GherkinLineSpan> tags = new ArrayList<GherkinLineSpan>(elements.length);
        for (String element : elements) {
            String token2 = StringUtils.rtrim(element);
            if (token2.isEmpty()) continue;
            int symbolLength = uncommentedLine.codePointCount(0, indexInUncommentedLine);
            int column = this.indent + symbolLength + 1;
            if (StringUtils.containsWhiteSpace(token2)) {
                throw new ParserException("A tag may not contain whitespace", Locations.atColumn(this.location, column));
            }
            tags.add(new GherkinLineSpan(column, "@" + token2));
            indexInUncommentedLine += element.length() + 1;
        }
        return tags;
    }

    List<GherkinLineSpan> parseTableCells() {
        ArrayList<GherkinLineSpan> lineSpans = new ArrayList<GherkinLineSpan>();
        StringBuilder cellBuilder = new StringBuilder();
        boolean beforeFirst = true;
        int col = 0;
        int cellStart = 0;
        boolean escape = false;
        PrimitiveIterator.OfInt iterator2 = this.text.codePoints().iterator();
        while (iterator2.hasNext()) {
            int c2 = iterator2.next();
            if (escape) {
                switch (c2) {
                    case 110: {
                        cellBuilder.append('\n');
                        break;
                    }
                    case 92: {
                        cellBuilder.append('\\');
                        break;
                    }
                    case 124: {
                        cellBuilder.append('|');
                        break;
                    }
                    default: {
                        cellBuilder.append("\\");
                        cellBuilder.appendCodePoint(c2);
                    }
                }
                escape = false;
            } else if (c2 == 92) {
                escape = true;
            } else if (c2 == 124) {
                if (beforeFirst) {
                    beforeFirst = false;
                } else {
                    Map.Entry<String, Integer> trimmedCellIndent = StringUtils.trimAndIndentKeepNewLines(cellBuilder.toString());
                    int column = this.indent + cellStart + trimmedCellIndent.getValue() + 1;
                    lineSpans.add(new GherkinLineSpan(column, trimmedCellIndent.getKey()));
                }
                cellBuilder = new StringBuilder();
                cellStart = col + 1;
            } else {
                cellBuilder.appendCodePoint(c2);
            }
            ++col;
        }
        return lineSpans;
    }

    boolean startsWithTitleKeyword(String keyword) {
        int keywordLength = keyword.length();
        return this.text.length() > keywordLength && this.text.startsWith(keyword) && this.text.startsWith(":", keywordLength);
    }
}

