/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.EncodingParser;
import io.cucumber.gherkin.GherkinDocumentBuilder;
import io.cucumber.gherkin.InputStreams;
import io.cucumber.gherkin.Parser;
import io.cucumber.gherkin.ParserException;
import io.cucumber.gherkin.PickleCompiler;
import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.ParseError;
import io.cucumber.messages.types.Source;
import io.cucumber.messages.types.SourceMediaType;
import io.cucumber.messages.types.SourceReference;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class GherkinParser {
    static final int FEATURE_FILE_AVERAGE_LINE_LENGTH = 100;
    static final int FEATURE_FILE_AVERAGE_LINE_COUNT = 2048;
    static final int FEATURE_FILE_AVERAGE_SIZE = 204800;
    private final boolean includeSource;
    private final boolean includeGherkinDocument;
    private final boolean includePickles;
    private final IdGenerator idGenerator;
    private final PickleCompiler pickleCompiler;

    private GherkinParser(boolean includeSource, boolean includeGherkinDocument, boolean includePickles, IdGenerator idGenerator) {
        this.includeSource = includeSource;
        this.includeGherkinDocument = includeGherkinDocument;
        this.includePickles = includePickles;
        this.idGenerator = Objects.requireNonNull(idGenerator);
        this.pickleCompiler = new PickleCompiler(idGenerator);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Stream<Envelope> parse(Path source2) throws IOException {
        Objects.requireNonNull(source2);
        return this.parse(source2.toUri().toString(), Files.readAllBytes(source2));
    }

    public Stream<Envelope> parse(String uri2, InputStream source2) throws IOException {
        Objects.requireNonNull(uri2);
        Objects.requireNonNull(source2);
        return this.parse(uri2, InputStreams.readAllBytes(source2));
    }

    public Stream<Envelope> parse(String uri2, byte[] source2) {
        Objects.requireNonNull(uri2);
        Objects.requireNonNull(source2);
        String withEncodingFromSource = EncodingParser.readWithEncodingFromSource(source2);
        return this.parse(Envelope.of(new Source(uri2, withEncodingFromSource, SourceMediaType.TEXT_X_CUCUMBER_GHERKIN_PLAIN)));
    }

    public Stream<Envelope> parse(Envelope envelope) {
        Objects.requireNonNull(envelope);
        ArrayList<Envelope> messages = new ArrayList<Envelope>();
        if (this.includeSource) {
            messages.add(envelope);
        }
        envelope.getSource().map(this::parse).ifPresent(envelopes -> messages.addAll((Collection<Envelope>)envelopes));
        return messages.stream();
    }

    private List<Envelope> parse(Source source2) {
        return this.parse(source2.getUri(), source2.getData());
    }

    private List<Envelope> parse(String uri2, String data2) {
        ArrayList<Envelope> messages = new ArrayList<Envelope>();
        GherkinDocumentBuilder documentBuilder = new GherkinDocumentBuilder(this.idGenerator, uri2);
        Parser<GherkinDocument> parser = new Parser<GherkinDocument>(documentBuilder);
        try {
            GherkinDocument gherkinDocument = parser.parse(data2, uri2);
            if (this.includeGherkinDocument) {
                messages.add(Envelope.of(gherkinDocument));
            }
            if (this.includePickles) {
                this.pickleCompiler.compile(gherkinDocument, uri2).stream().map(Envelope::of).collect(Collectors.toCollection(() -> messages));
            }
        }
        catch (ParserException.CompositeParserException composite) {
            composite.errors.stream().map(error2 -> this.createParseError((ParserException)error2, uri2)).collect(Collectors.toCollection(() -> messages));
        }
        catch (ParserException error3) {
            messages.add(this.createParseError(error3, uri2));
        }
        return messages;
    }

    private Envelope createParseError(ParserException e2, String uri2) {
        return Envelope.of(new ParseError(new SourceReference(uri2, null, null, e2.location), e2.getMessage()));
    }

    public static final class Builder {
        private boolean includeSource = true;
        private boolean includeGherkinDocument = true;
        private boolean includePickles = true;
        private IdGenerator idGenerator = () -> UUID.randomUUID().toString();

        private Builder() {
        }

        public Builder includeSource(boolean includeSource) {
            this.includeSource = includeSource;
            return this;
        }

        public Builder includeGherkinDocument(boolean includeGherkinDocument) {
            this.includeGherkinDocument = includeGherkinDocument;
            return this;
        }

        public Builder includePickles(boolean includePickles) {
            this.includePickles = includePickles;
            return this;
        }

        public Builder idGenerator(IdGenerator idGenerator) {
            this.idGenerator = Objects.requireNonNull(idGenerator);
            return this;
        }

        public GherkinParser build() {
            return new GherkinParser(this.includeSource, this.includeGherkinDocument, this.includePickles, this.idGenerator);
        }
    }
}

