/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.GherkinDialect;
import io.cucumber.gherkin.GherkinDialectProvider;
import io.cucumber.gherkin.GherkinLineSpan;
import io.cucumber.gherkin.Locations;
import io.cucumber.gherkin.Parser;
import io.cucumber.gherkin.ParserException;
import io.cucumber.gherkin.Token;
import io.cucumber.messages.types.StepKeywordType;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GherkinTokenMatcher
implements Parser.TokenMatcher {
    private static final Pattern LANGUAGE_PATTERN = Pattern.compile("^#\\s*language\\s*:\\s*([a-zA-Z\\-_]+)\\s*$");
    private final GherkinDialectProvider dialectProvider;
    private GherkinDialect currentDialect;
    private String activeDocStringSeparator = null;
    private int indentToRemove = 0;

    GherkinTokenMatcher(GherkinDialectProvider dialectProvider) {
        this.dialectProvider = dialectProvider;
        this.reset();
    }

    GherkinTokenMatcher() {
        this(new GherkinDialectProvider());
    }

    GherkinTokenMatcher(String defaultDialectName) {
        this(new GherkinDialectProvider(defaultDialectName));
    }

    @Override
    public void reset() {
        this.activeDocStringSeparator = null;
        this.indentToRemove = 0;
        this.currentDialect = this.dialectProvider.getDefaultDialect();
    }

    private GherkinDialect getCurrentDialect() {
        return this.currentDialect;
    }

    private void setTokenMatched(Token token2, Parser.TokenType matchedType, String text, String keyword, Integer indent, StepKeywordType keywordType, List<GherkinLineSpan> items2) {
        token2.matchedType = matchedType;
        token2.matchedKeyword = keyword;
        token2.keywordType = keywordType;
        token2.matchedText = text;
        token2.matchedItems = items2;
        token2.matchedGherkinDialect = this.getCurrentDialect();
        token2.matchedIndent = indent != null ? indent : (token2.isEOF() ? 0 : token2.line.getIndent());
        token2.location = Locations.atColumn(token2.location, token2.matchedIndent + 1);
    }

    @Override
    public boolean match_EOF(Token token2) {
        if (token2.isEOF()) {
            this.setTokenMatched(token2, Parser.TokenType.EOF, null, null, null, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_Other(Token token2) {
        String text = this.removeDocStringIndent(token2);
        this.setTokenMatched(token2, Parser.TokenType.Other, this.unescapeDocString(text), null, 0, null, null);
        return true;
    }

    @Override
    public boolean match_Empty(Token token2) {
        if (token2.line.isEmpty()) {
            this.setTokenMatched(token2, Parser.TokenType.Empty, null, null, null, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_Comment(Token token2) {
        if (token2.line.startsWith("#")) {
            String text = token2.line.getRawText();
            this.setTokenMatched(token2, Parser.TokenType.Comment, text, null, 0, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_Language(Token token2) {
        Matcher matcher = LANGUAGE_PATTERN.matcher(token2.line.getText());
        if (matcher.matches()) {
            String language = matcher.group(1);
            this.setTokenMatched(token2, Parser.TokenType.Language, language, null, null, null, null);
            this.currentDialect = this.dialectProvider.getDialect(language).orElseThrow(() -> new ParserException.NoSuchLanguageException(language, token2.location));
            return true;
        }
        return false;
    }

    @Override
    public boolean match_TagLine(Token token2) {
        if (token2.line.startsWith("@")) {
            this.setTokenMatched(token2, Parser.TokenType.TagLine, null, null, null, null, token2.line.parseTags());
            return true;
        }
        return false;
    }

    @Override
    public boolean match_FeatureLine(Token token2) {
        return this.matchTitleLine(token2, Parser.TokenType.FeatureLine, this.currentDialect.getFeatureKeywords());
    }

    @Override
    public boolean match_RuleLine(Token token2) {
        return this.matchTitleLine(token2, Parser.TokenType.RuleLine, this.currentDialect.getRuleKeywords());
    }

    @Override
    public boolean match_BackgroundLine(Token token2) {
        return this.matchTitleLine(token2, Parser.TokenType.BackgroundLine, this.currentDialect.getBackgroundKeywords());
    }

    @Override
    public boolean match_ScenarioLine(Token token2) {
        return this.matchTitleLine(token2, Parser.TokenType.ScenarioLine, this.currentDialect.getScenarioKeywords()) || this.matchTitleLine(token2, Parser.TokenType.ScenarioLine, this.currentDialect.getScenarioOutlineKeywords());
    }

    @Override
    public boolean match_ExamplesLine(Token token2) {
        return this.matchTitleLine(token2, Parser.TokenType.ExamplesLine, this.currentDialect.getExamplesKeywords());
    }

    private boolean matchTitleLine(Token token2, Parser.TokenType tokenType, List<String> keywords) {
        for (String keyword : keywords) {
            if (!token2.line.startsWithTitleKeyword(keyword)) continue;
            String title = token2.line.substringTrimmed(keyword.length() + ":".length());
            this.setTokenMatched(token2, tokenType, title, keyword, null, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_DocStringSeparator(Token token2) {
        return this.activeDocStringSeparator == null ? this.match_DocStringSeparator(token2, "\"\"\"", true) || this.match_DocStringSeparator(token2, "```", true) : this.match_DocStringSeparator(token2, this.activeDocStringSeparator, false);
    }

    private boolean match_DocStringSeparator(Token token2, String separator, boolean isOpen) {
        if (token2.line.startsWith(separator)) {
            String mediaType = null;
            if (isOpen) {
                mediaType = token2.line.substringTrimmed(separator.length());
                this.activeDocStringSeparator = separator;
                this.indentToRemove = token2.line.getIndent();
            } else {
                this.activeDocStringSeparator = null;
                this.indentToRemove = 0;
            }
            this.setTokenMatched(token2, Parser.TokenType.DocStringSeparator, mediaType, separator, null, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_StepLine(Token token2) {
        List<String> keywords = this.currentDialect.getStepKeywords();
        for (String keyword : keywords) {
            if (!token2.line.startsWith(keyword)) continue;
            String stepText = token2.line.substringTrimmed(keyword.length());
            StepKeywordType keywordType = this.getKeywordType(keyword);
            this.setTokenMatched(token2, Parser.TokenType.StepLine, stepText, keyword, null, keywordType, null);
            return true;
        }
        return false;
    }

    private StepKeywordType getKeywordType(String stepKeyword) {
        Set<StepKeywordType> keywordTypes = this.currentDialect.getStepKeywordTypesSet(stepKeyword);
        if (keywordTypes.size() == 1) {
            return keywordTypes.iterator().next();
        }
        return StepKeywordType.UNKNOWN;
    }

    @Override
    public boolean match_TableRow(Token token2) {
        if (token2.line.startsWith("|")) {
            this.setTokenMatched(token2, Parser.TokenType.TableRow, null, null, null, null, token2.line.parseTableCells());
            return true;
        }
        return false;
    }

    private String removeDocStringIndent(Token token2) {
        if (this.activeDocStringSeparator == null) {
            return token2.line.getRawText();
        }
        if (this.indentToRemove > token2.line.getIndent()) {
            return token2.line.getText();
        }
        return token2.line.getRawTextSubstring(this.indentToRemove);
    }

    private String unescapeDocString(String text) {
        if ("\"\"\"".equals(this.activeDocStringSeparator)) {
            return text.replace("\\\"\\\"\\\"", "\"\"\"");
        }
        if ("```".equals(this.activeDocStringSeparator)) {
            return text.replace("\\`\\`\\`", "```");
        }
        return text;
    }
}

