/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.GherkinTokenMatcher;
import io.cucumber.gherkin.ParserException;
import io.cucumber.gherkin.Token;
import io.cucumber.gherkin.TokenScanner;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.Supplier;

class Parser<T> {
    private final Builder<T> builder;

    Parser(Builder<T> builder) {
        this.builder = builder;
    }

    T parse(String source2, String uri2) {
        return this.parse(new TokenScanner(source2), uri2);
    }

    T parse(TokenScanner tokenScanner, String uri2) {
        return this.parse(tokenScanner, (TokenMatcher)new GherkinTokenMatcher(), uri2);
    }

    T parse(String source2, TokenMatcher tokenMatcher, String uri2) {
        return this.parse(new TokenScanner(source2), tokenMatcher, uri2);
    }

    T parse(TokenScanner tokenScanner, TokenMatcher tokenMatcher, String uri2) {
        Token token2;
        this.builder.reset(uri2);
        tokenMatcher.reset();
        ParserContext context = new ParserContext(tokenScanner, tokenMatcher, new LinkedList<Token>(), new ArrayList<ParserException>());
        this.startRule(context, RuleType.GherkinDocument);
        int state = 0;
        do {
            token2 = this.readToken(context);
            state = this.matchToken(state, token2, context);
        } while (!token2.isEOF());
        this.endRule(context, RuleType.GherkinDocument);
        if (!context.errors.isEmpty()) {
            throw new ParserException.CompositeParserException(context.errors);
        }
        return this.builder.getResult();
    }

    private void addError(ParserContext context, ParserException error2) {
        String newErrorMessage = error2.getMessage();
        for (ParserException e2 : context.errors) {
            if (!e2.getMessage().equals(newErrorMessage)) continue;
            return;
        }
        context.errors.add(error2);
        if (context.errors.size() > 10) {
            throw new ParserException.CompositeParserException(context.errors);
        }
    }

    private void handleAstError(ParserContext context, Supplier<Void> action) {
        this.handleExternalError(context, null, action);
    }

    private <V> V handleExternalError(ParserContext context, V defaultValue, Supplier<V> action) {
        try {
            return action.get();
        }
        catch (ParserException.CompositeParserException compositeParserException) {
            for (ParserException error2 : compositeParserException.errors) {
                this.addError(context, error2);
            }
        }
        catch (ParserException error3) {
            this.addError(context, error3);
        }
        return defaultValue;
    }

    private void build(ParserContext context, Token token2) {
        this.handleAstError(context, () -> {
            this.builder.build(token2);
            return null;
        });
    }

    private void startRule(ParserContext context, RuleType ruleType) {
        this.handleAstError(context, () -> {
            this.builder.startRule(ruleType);
            return null;
        });
    }

    private void endRule(ParserContext context, RuleType ruleType) {
        this.handleAstError(context, () -> {
            this.builder.endRule(ruleType);
            return null;
        });
    }

    private Token readToken(ParserContext context) {
        return context.tokenQueue.isEmpty() ? context.tokenScanner.read() : context.tokenQueue.remove();
    }

    private boolean match_EOF(ParserContext context, Token token2) {
        return this.handleExternalError(context, false, () -> context.tokenMatcher.match_EOF(token2));
    }

    private boolean match_Empty(ParserContext context, Token token2) {
        if (token2.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, false, () -> context.tokenMatcher.match_Empty(token2));
    }

    private boolean match_Comment(ParserContext context, Token token2) {
        if (token2.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, false, () -> context.tokenMatcher.match_Comment(token2));
    }

    private boolean match_TagLine(ParserContext context, Token token2) {
        if (token2.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, false, () -> context.tokenMatcher.match_TagLine(token2));
    }

    private boolean match_FeatureLine(ParserContext context, Token token2) {
        if (token2.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, false, () -> context.tokenMatcher.match_FeatureLine(token2));
    }

    private boolean match_RuleLine(ParserContext context, Token token2) {
        if (token2.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, false, () -> context.tokenMatcher.match_RuleLine(token2));
    }

    private boolean match_BackgroundLine(ParserContext context, Token token2) {
        if (token2.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, false, () -> context.tokenMatcher.match_BackgroundLine(token2));
    }

    private boolean match_ScenarioLine(ParserContext context, Token token2) {
        if (token2.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, false, () -> context.tokenMatcher.match_ScenarioLine(token2));
    }

    private boolean match_ExamplesLine(ParserContext context, Token token2) {
        if (token2.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, false, () -> context.tokenMatcher.match_ExamplesLine(token2));
    }

    private boolean match_StepLine(ParserContext context, Token token2) {
        if (token2.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, false, () -> context.tokenMatcher.match_StepLine(token2));
    }

    private boolean match_DocStringSeparator(ParserContext context, Token token2) {
        if (token2.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, false, () -> context.tokenMatcher.match_DocStringSeparator(token2));
    }

    private boolean match_TableRow(ParserContext context, Token token2) {
        if (token2.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, false, () -> context.tokenMatcher.match_TableRow(token2));
    }

    private boolean match_Language(ParserContext context, Token token2) {
        if (token2.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, false, () -> context.tokenMatcher.match_Language(token2));
    }

    private boolean match_Other(ParserContext context, Token token2) {
        if (token2.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, false, () -> context.tokenMatcher.match_Other(token2));
    }

    private int matchToken(int state, Token token2, ParserContext context) {
        int newState;
        switch (state) {
            case 0: {
                newState = this.matchTokenAt_0(token2, context);
                break;
            }
            case 1: {
                newState = this.matchTokenAt_1(token2, context);
                break;
            }
            case 2: {
                newState = this.matchTokenAt_2(token2, context);
                break;
            }
            case 3: {
                newState = this.matchTokenAt_3(token2, context);
                break;
            }
            case 4: {
                newState = this.matchTokenAt_4(token2, context);
                break;
            }
            case 5: {
                newState = this.matchTokenAt_5(token2, context);
                break;
            }
            case 6: {
                newState = this.matchTokenAt_6(token2, context);
                break;
            }
            case 7: {
                newState = this.matchTokenAt_7(token2, context);
                break;
            }
            case 8: {
                newState = this.matchTokenAt_8(token2, context);
                break;
            }
            case 9: {
                newState = this.matchTokenAt_9(token2, context);
                break;
            }
            case 10: {
                newState = this.matchTokenAt_10(token2, context);
                break;
            }
            case 11: {
                newState = this.matchTokenAt_11(token2, context);
                break;
            }
            case 12: {
                newState = this.matchTokenAt_12(token2, context);
                break;
            }
            case 13: {
                newState = this.matchTokenAt_13(token2, context);
                break;
            }
            case 14: {
                newState = this.matchTokenAt_14(token2, context);
                break;
            }
            case 15: {
                newState = this.matchTokenAt_15(token2, context);
                break;
            }
            case 16: {
                newState = this.matchTokenAt_16(token2, context);
                break;
            }
            case 17: {
                newState = this.matchTokenAt_17(token2, context);
                break;
            }
            case 18: {
                newState = this.matchTokenAt_18(token2, context);
                break;
            }
            case 19: {
                newState = this.matchTokenAt_19(token2, context);
                break;
            }
            case 20: {
                newState = this.matchTokenAt_20(token2, context);
                break;
            }
            case 21: {
                newState = this.matchTokenAt_21(token2, context);
                break;
            }
            case 22: {
                newState = this.matchTokenAt_22(token2, context);
                break;
            }
            case 23: {
                newState = this.matchTokenAt_23(token2, context);
                break;
            }
            case 24: {
                newState = this.matchTokenAt_24(token2, context);
                break;
            }
            case 25: {
                newState = this.matchTokenAt_25(token2, context);
                break;
            }
            case 26: {
                newState = this.matchTokenAt_26(token2, context);
                break;
            }
            case 27: {
                newState = this.matchTokenAt_27(token2, context);
                break;
            }
            case 28: {
                newState = this.matchTokenAt_28(token2, context);
                break;
            }
            case 29: {
                newState = this.matchTokenAt_29(token2, context);
                break;
            }
            case 30: {
                newState = this.matchTokenAt_30(token2, context);
                break;
            }
            case 31: {
                newState = this.matchTokenAt_31(token2, context);
                break;
            }
            case 32: {
                newState = this.matchTokenAt_32(token2, context);
                break;
            }
            case 33: {
                newState = this.matchTokenAt_33(token2, context);
                break;
            }
            case 35: {
                newState = this.matchTokenAt_35(token2, context);
                break;
            }
            case 36: {
                newState = this.matchTokenAt_36(token2, context);
                break;
            }
            case 37: {
                newState = this.matchTokenAt_37(token2, context);
                break;
            }
            case 38: {
                newState = this.matchTokenAt_38(token2, context);
                break;
            }
            case 39: {
                newState = this.matchTokenAt_39(token2, context);
                break;
            }
            case 40: {
                newState = this.matchTokenAt_40(token2, context);
                break;
            }
            case 41: {
                newState = this.matchTokenAt_41(token2, context);
                break;
            }
            case 42: {
                newState = this.matchTokenAt_42(token2, context);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + state);
            }
        }
        return newState;
    }

    private int matchTokenAt_0(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.build(context, token2);
            return 34;
        }
        if (this.match_Language(context, token2)) {
            this.startRule(context, RuleType.Feature);
            this.startRule(context, RuleType.FeatureHeader);
            this.build(context, token2);
            return 1;
        }
        if (this.match_TagLine(context, token2)) {
            this.startRule(context, RuleType.Feature);
            this.startRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 2;
        }
        if (this.match_FeatureLine(context, token2)) {
            this.startRule(context, RuleType.Feature);
            this.startRule(context, RuleType.FeatureHeader);
            this.build(context, token2);
            return 3;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 0;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 0;
        }
        String stateComment = "State: 0 - Start";
        List<String> expectedTokens = Arrays.asList("#EOF", "#Language", "#TagLine", "#FeatureLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 0 - Start") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 0 - Start");
        this.addError(context, error2);
        return 0;
    }

    private int matchTokenAt_1(Token token2, ParserContext context) {
        if (this.match_TagLine(context, token2)) {
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 2;
        }
        if (this.match_FeatureLine(context, token2)) {
            this.build(context, token2);
            return 3;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 1;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 1;
        }
        String stateComment = "State: 1 - GherkinDocument:0>Feature:0>FeatureHeader:0>#Language:0";
        List<String> expectedTokens = Arrays.asList("#TagLine", "#FeatureLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 1 - GherkinDocument:0>Feature:0>FeatureHeader:0>#Language:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 1 - GherkinDocument:0>Feature:0>FeatureHeader:0>#Language:0");
        this.addError(context, error2);
        return 1;
    }

    private int matchTokenAt_2(Token token2, ParserContext context) {
        if (this.match_TagLine(context, token2)) {
            this.build(context, token2);
            return 2;
        }
        if (this.match_FeatureLine(context, token2)) {
            this.endRule(context, RuleType.Tags);
            this.build(context, token2);
            return 3;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 2;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 2;
        }
        String stateComment = "State: 2 - GherkinDocument:0>Feature:0>FeatureHeader:1>Tags:0>#TagLine:0";
        List<String> expectedTokens = Arrays.asList("#TagLine", "#FeatureLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 2 - GherkinDocument:0>Feature:0>FeatureHeader:1>Tags:0>#TagLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 2 - GherkinDocument:0>Feature:0>FeatureHeader:1>Tags:0>#TagLine:0");
        this.addError(context, error2);
        return 2;
    }

    private int matchTokenAt_3(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 3;
        }
        if (this.match_Comment(context, token2)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token2);
            return 4;
        }
        if (this.match_BackgroundLine(context, token2)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.Background);
            this.build(context, token2);
            return 5;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 9;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 10;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Other(context, token2)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token2);
            return 4;
        }
        String stateComment = "State: 3 - GherkinDocument:0>Feature:0>FeatureHeader:2>#FeatureLine:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 3 - GherkinDocument:0>Feature:0>FeatureHeader:2>#FeatureLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 3 - GherkinDocument:0>Feature:0>FeatureHeader:2>#FeatureLine:0");
        this.addError(context, error2);
        return 3;
    }

    private int matchTokenAt_4(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.FeatureHeader);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 4;
        }
        if (this.match_BackgroundLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.Background);
            this.build(context, token2);
            return 5;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 9;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 10;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Other(context, token2)) {
            this.build(context, token2);
            return 4;
        }
        String stateComment = "State: 4 - GherkinDocument:0>Feature:0>FeatureHeader:3>DescriptionHelper:1>Description:0>__alt1:0>#Other:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 4 - GherkinDocument:0>Feature:0>FeatureHeader:3>DescriptionHelper:1>Description:0>__alt1:0>#Other:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 4 - GherkinDocument:0>Feature:0>FeatureHeader:3>DescriptionHelper:1>Description:0>__alt1:0>#Other:0");
        this.addError(context, error2);
        return 4;
    }

    private int matchTokenAt_5(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 5;
        }
        if (this.match_Comment(context, token2)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token2);
            return 6;
        }
        if (this.match_StepLine(context, token2)) {
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 7;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 9;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 10;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Other(context, token2)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token2);
            return 6;
        }
        String stateComment = "State: 5 - GherkinDocument:0>Feature:1>Background:0>#BackgroundLine:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 5 - GherkinDocument:0>Feature:1>Background:0>#BackgroundLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 5 - GherkinDocument:0>Feature:1>Background:0>#BackgroundLine:0");
        this.addError(context, error2);
        return 5;
    }

    private int matchTokenAt_6(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 6;
        }
        if (this.match_StepLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 7;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 9;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 10;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Other(context, token2)) {
            this.build(context, token2);
            return 6;
        }
        String stateComment = "State: 6 - GherkinDocument:0>Feature:1>Background:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 6 - GherkinDocument:0>Feature:1>Background:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 6 - GherkinDocument:0>Feature:1>Background:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0");
        this.addError(context, error2);
        return 6;
    }

    private int matchTokenAt_7(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_TableRow(context, token2)) {
            this.startRule(context, RuleType.DataTable);
            this.build(context, token2);
            return 8;
        }
        if (this.match_DocStringSeparator(context, token2)) {
            this.startRule(context, RuleType.DocString);
            this.build(context, token2);
            return 41;
        }
        if (this.match_StepLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 7;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 9;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 10;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 7;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 7;
        }
        String stateComment = "State: 7 - GherkinDocument:0>Feature:1>Background:2>Step:0>#StepLine:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#DocStringSeparator", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 7 - GherkinDocument:0>Feature:1>Background:2>Step:0>#StepLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 7 - GherkinDocument:0>Feature:1>Background:2>Step:0>#StepLine:0");
        this.addError(context, error2);
        return 7;
    }

    private int matchTokenAt_8(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_TableRow(context, token2)) {
            this.build(context, token2);
            return 8;
        }
        if (this.match_StepLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 7;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 9;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 10;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 8;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 8;
        }
        String stateComment = "State: 8 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 8 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 8 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0");
        this.addError(context, error2);
        return 8;
    }

    private int matchTokenAt_9(Token token2, ParserContext context) {
        if (this.match_TagLine(context, token2)) {
            this.build(context, token2);
            return 9;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Tags);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 10;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 9;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 9;
        }
        String stateComment = "State: 9 - GherkinDocument:0>Feature:2>ScenarioDefinition:0>Tags:0>#TagLine:0";
        List<String> expectedTokens = Arrays.asList("#TagLine", "#ScenarioLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 9 - GherkinDocument:0>Feature:2>ScenarioDefinition:0>Tags:0>#TagLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 9 - GherkinDocument:0>Feature:2>ScenarioDefinition:0>Tags:0>#TagLine:0");
        this.addError(context, error2);
        return 9;
    }

    private int matchTokenAt_10(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 10;
        }
        if (this.match_Comment(context, token2)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token2);
            return 11;
        }
        if (this.match_StepLine(context, token2)) {
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 12;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_1(context, token2)) {
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 14;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 9;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 15;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 10;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Other(context, token2)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token2);
            return 11;
        }
        String stateComment = "State: 10 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 10 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 10 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0");
        this.addError(context, error2);
        return 10;
    }

    private int matchTokenAt_11(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 11;
        }
        if (this.match_StepLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 12;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_1(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 14;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 9;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 15;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 10;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Other(context, token2)) {
            this.build(context, token2);
            return 11;
        }
        String stateComment = "State: 11 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 11 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 11 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0");
        this.addError(context, error2);
        return 11;
    }

    private int matchTokenAt_12(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_TableRow(context, token2)) {
            this.startRule(context, RuleType.DataTable);
            this.build(context, token2);
            return 13;
        }
        if (this.match_DocStringSeparator(context, token2)) {
            this.startRule(context, RuleType.DocString);
            this.build(context, token2);
            return 39;
        }
        if (this.match_StepLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 12;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_1(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 14;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 9;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 15;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 10;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 12;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 12;
        }
        String stateComment = "State: 12 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#DocStringSeparator", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 12 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 12 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0");
        this.addError(context, error2);
        return 12;
    }

    private int matchTokenAt_13(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_TableRow(context, token2)) {
            this.build(context, token2);
            return 13;
        }
        if (this.match_StepLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 12;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_1(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 14;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 9;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 15;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 10;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 13;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 13;
        }
        String stateComment = "State: 13 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 13 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 13 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0");
        this.addError(context, error2);
        return 13;
    }

    private int matchTokenAt_14(Token token2, ParserContext context) {
        if (this.match_TagLine(context, token2)) {
            this.build(context, token2);
            return 14;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.endRule(context, RuleType.Tags);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 15;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 14;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 14;
        }
        String stateComment = "State: 14 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0";
        List<String> expectedTokens = Arrays.asList("#TagLine", "#ExamplesLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 14 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 14 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0");
        this.addError(context, error2);
        return 14;
    }

    private int matchTokenAt_15(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 15;
        }
        if (this.match_Comment(context, token2)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token2);
            return 16;
        }
        if (this.match_TableRow(context, token2)) {
            this.startRule(context, RuleType.ExamplesTable);
            this.build(context, token2);
            return 17;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_1(context, token2)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 14;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 9;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 15;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 10;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Other(context, token2)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token2);
            return 16;
        }
        String stateComment = "State: 15 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 15 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 15 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0");
        this.addError(context, error2);
        return 15;
    }

    private int matchTokenAt_16(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 16;
        }
        if (this.match_TableRow(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.ExamplesTable);
            this.build(context, token2);
            return 17;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_1(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 14;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 9;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 15;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 10;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Other(context, token2)) {
            this.build(context, token2);
            return 16;
        }
        String stateComment = "State: 16 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 16 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 16 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0");
        this.addError(context, error2);
        return 16;
    }

    private int matchTokenAt_17(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_TableRow(context, token2)) {
            this.build(context, token2);
            return 17;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_1(context, token2)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 14;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 9;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 15;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 10;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 17;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 17;
        }
        String stateComment = "State: 17 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 17 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 17 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0");
        this.addError(context, error2);
        return 17;
    }

    private int matchTokenAt_18(Token token2, ParserContext context) {
        if (this.match_TagLine(context, token2)) {
            this.build(context, token2);
            return 18;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Tags);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 18;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 18;
        }
        String stateComment = "State: 18 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:0>Tags:0>#TagLine:0";
        List<String> expectedTokens = Arrays.asList("#TagLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 18 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:0>Tags:0>#TagLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 18 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:0>Tags:0>#TagLine:0");
        this.addError(context, error2);
        return 18;
    }

    private int matchTokenAt_19(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.RuleHeader);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 19;
        }
        if (this.match_Comment(context, token2)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token2);
            return 20;
        }
        if (this.match_BackgroundLine(context, token2)) {
            this.endRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Background);
            this.build(context, token2);
            return 21;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 25;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.RuleHeader);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 26;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.RuleHeader);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Other(context, token2)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token2);
            return 20;
        }
        String stateComment = "State: 19 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:1>#RuleLine:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 19 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:1>#RuleLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 19 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:1>#RuleLine:0");
        this.addError(context, error2);
        return 19;
    }

    private int matchTokenAt_20(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.RuleHeader);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 20;
        }
        if (this.match_BackgroundLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Background);
            this.build(context, token2);
            return 21;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 25;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.RuleHeader);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 26;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.RuleHeader);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Other(context, token2)) {
            this.build(context, token2);
            return 20;
        }
        String stateComment = "State: 20 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:2>DescriptionHelper:1>Description:0>__alt1:0>#Other:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 20 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:2>DescriptionHelper:1>Description:0>__alt1:0>#Other:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 20 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:2>DescriptionHelper:1>Description:0>__alt1:0>#Other:0");
        this.addError(context, error2);
        return 20;
    }

    private int matchTokenAt_21(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 21;
        }
        if (this.match_Comment(context, token2)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token2);
            return 22;
        }
        if (this.match_StepLine(context, token2)) {
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 23;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 25;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 26;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Other(context, token2)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token2);
            return 22;
        }
        String stateComment = "State: 21 - GherkinDocument:0>Feature:3>Rule:1>Background:0>#BackgroundLine:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 21 - GherkinDocument:0>Feature:3>Rule:1>Background:0>#BackgroundLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 21 - GherkinDocument:0>Feature:3>Rule:1>Background:0>#BackgroundLine:0");
        this.addError(context, error2);
        return 21;
    }

    private int matchTokenAt_22(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 22;
        }
        if (this.match_StepLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 23;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 25;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 26;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Other(context, token2)) {
            this.build(context, token2);
            return 22;
        }
        String stateComment = "State: 22 - GherkinDocument:0>Feature:3>Rule:1>Background:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 22 - GherkinDocument:0>Feature:3>Rule:1>Background:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 22 - GherkinDocument:0>Feature:3>Rule:1>Background:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0");
        this.addError(context, error2);
        return 22;
    }

    private int matchTokenAt_23(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_TableRow(context, token2)) {
            this.startRule(context, RuleType.DataTable);
            this.build(context, token2);
            return 24;
        }
        if (this.match_DocStringSeparator(context, token2)) {
            this.startRule(context, RuleType.DocString);
            this.build(context, token2);
            return 37;
        }
        if (this.match_StepLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 23;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 25;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 26;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 23;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 23;
        }
        String stateComment = "State: 23 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:0>#StepLine:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#DocStringSeparator", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 23 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:0>#StepLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 23 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:0>#StepLine:0");
        this.addError(context, error2);
        return 23;
    }

    private int matchTokenAt_24(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_TableRow(context, token2)) {
            this.build(context, token2);
            return 24;
        }
        if (this.match_StepLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 23;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 25;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 26;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 24;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 24;
        }
        String stateComment = "State: 24 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 24 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 24 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0");
        this.addError(context, error2);
        return 24;
    }

    private int matchTokenAt_25(Token token2, ParserContext context) {
        if (this.match_TagLine(context, token2)) {
            this.build(context, token2);
            return 25;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Tags);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 26;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 25;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 25;
        }
        String stateComment = "State: 25 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:0>Tags:0>#TagLine:0";
        List<String> expectedTokens = Arrays.asList("#TagLine", "#ScenarioLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 25 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:0>Tags:0>#TagLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 25 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:0>Tags:0>#TagLine:0");
        this.addError(context, error2);
        return 25;
    }

    private int matchTokenAt_26(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 26;
        }
        if (this.match_Comment(context, token2)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token2);
            return 27;
        }
        if (this.match_StepLine(context, token2)) {
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 28;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_1(context, token2)) {
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 30;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 25;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 31;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 26;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Other(context, token2)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token2);
            return 27;
        }
        String stateComment = "State: 26 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 26 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 26 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0");
        this.addError(context, error2);
        return 26;
    }

    private int matchTokenAt_27(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 27;
        }
        if (this.match_StepLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 28;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_1(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 30;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 25;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 31;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 26;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Other(context, token2)) {
            this.build(context, token2);
            return 27;
        }
        String stateComment = "State: 27 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 27 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 27 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0");
        this.addError(context, error2);
        return 27;
    }

    private int matchTokenAt_28(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_TableRow(context, token2)) {
            this.startRule(context, RuleType.DataTable);
            this.build(context, token2);
            return 29;
        }
        if (this.match_DocStringSeparator(context, token2)) {
            this.startRule(context, RuleType.DocString);
            this.build(context, token2);
            return 35;
        }
        if (this.match_StepLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 28;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_1(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 30;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 25;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 31;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 26;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 28;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 28;
        }
        String stateComment = "State: 28 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#DocStringSeparator", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 28 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 28 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0");
        this.addError(context, error2);
        return 28;
    }

    private int matchTokenAt_29(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_TableRow(context, token2)) {
            this.build(context, token2);
            return 29;
        }
        if (this.match_StepLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 28;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_1(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 30;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 25;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 31;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 26;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 29;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 29;
        }
        String stateComment = "State: 29 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 29 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 29 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0");
        this.addError(context, error2);
        return 29;
    }

    private int matchTokenAt_30(Token token2, ParserContext context) {
        if (this.match_TagLine(context, token2)) {
            this.build(context, token2);
            return 30;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.endRule(context, RuleType.Tags);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 31;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 30;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 30;
        }
        String stateComment = "State: 30 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0";
        List<String> expectedTokens = Arrays.asList("#TagLine", "#ExamplesLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 30 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 30 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0");
        this.addError(context, error2);
        return 30;
    }

    private int matchTokenAt_31(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 31;
        }
        if (this.match_Comment(context, token2)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token2);
            return 32;
        }
        if (this.match_TableRow(context, token2)) {
            this.startRule(context, RuleType.ExamplesTable);
            this.build(context, token2);
            return 33;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_1(context, token2)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 30;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 25;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 31;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 26;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Other(context, token2)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token2);
            return 32;
        }
        String stateComment = "State: 31 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 31 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 31 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0");
        this.addError(context, error2);
        return 31;
    }

    private int matchTokenAt_32(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 32;
        }
        if (this.match_TableRow(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.ExamplesTable);
            this.build(context, token2);
            return 33;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_1(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 30;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 25;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 31;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 26;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Other(context, token2)) {
            this.build(context, token2);
            return 32;
        }
        String stateComment = "State: 32 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 32 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 32 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0");
        this.addError(context, error2);
        return 32;
    }

    private int matchTokenAt_33(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_TableRow(context, token2)) {
            this.build(context, token2);
            return 33;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_1(context, token2)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 30;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 25;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 31;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 26;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 33;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 33;
        }
        String stateComment = "State: 33 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 33 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 33 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0");
        this.addError(context, error2);
        return 33;
    }

    private int matchTokenAt_35(Token token2, ParserContext context) {
        if (this.match_DocStringSeparator(context, token2)) {
            this.build(context, token2);
            return 36;
        }
        if (this.match_Other(context, token2)) {
            this.build(context, token2);
            return 35;
        }
        String stateComment = "State: 35 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0";
        List<String> expectedTokens = Arrays.asList("#DocStringSeparator", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 35 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 35 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0");
        this.addError(context, error2);
        return 35;
    }

    private int matchTokenAt_36(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_StepLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 28;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_1(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 30;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 25;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 31;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 26;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 36;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 36;
        }
        String stateComment = "State: 36 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 36 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 36 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0");
        this.addError(context, error2);
        return 36;
    }

    private int matchTokenAt_37(Token token2, ParserContext context) {
        if (this.match_DocStringSeparator(context, token2)) {
            this.build(context, token2);
            return 38;
        }
        if (this.match_Other(context, token2)) {
            this.build(context, token2);
            return 37;
        }
        String stateComment = "State: 37 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0";
        List<String> expectedTokens = Arrays.asList("#DocStringSeparator", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 37 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 37 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0");
        this.addError(context, error2);
        return 37;
    }

    private int matchTokenAt_38(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_StepLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 23;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 25;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 26;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 38;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 38;
        }
        String stateComment = "State: 38 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 38 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 38 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0");
        this.addError(context, error2);
        return 38;
    }

    private int matchTokenAt_39(Token token2, ParserContext context) {
        if (this.match_DocStringSeparator(context, token2)) {
            this.build(context, token2);
            return 40;
        }
        if (this.match_Other(context, token2)) {
            this.build(context, token2);
            return 39;
        }
        String stateComment = "State: 39 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0";
        List<String> expectedTokens = Arrays.asList("#DocStringSeparator", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 39 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 39 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0");
        this.addError(context, error2);
        return 39;
    }

    private int matchTokenAt_40(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_StepLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 12;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_1(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 14;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 9;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ExamplesLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token2);
            return 15;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 10;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 40;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 40;
        }
        String stateComment = "State: 40 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 40 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 40 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0");
        this.addError(context, error2);
        return 40;
    }

    private int matchTokenAt_41(Token token2, ParserContext context) {
        if (this.match_DocStringSeparator(context, token2)) {
            this.build(context, token2);
            return 42;
        }
        if (this.match_Other(context, token2)) {
            this.build(context, token2);
            return 41;
        }
        String stateComment = "State: 41 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0";
        List<String> expectedTokens = Arrays.asList("#DocStringSeparator", "#Other");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 41 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 41 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0");
        this.addError(context, error2);
        return 41;
    }

    private int matchTokenAt_42(Token token2, ParserContext context) {
        if (this.match_EOF(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Feature);
            this.build(context, token2);
            return 34;
        }
        if (this.match_StepLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token2);
            return 7;
        }
        if (this.match_TagLine(context, token2) && this.lookahead_0(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 9;
        }
        if (this.match_TagLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token2);
            return 18;
        }
        if (this.match_ScenarioLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token2);
            return 10;
        }
        if (this.match_RuleLine(context, token2)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token2);
            return 19;
        }
        if (this.match_Comment(context, token2)) {
            this.build(context, token2);
            return 42;
        }
        if (this.match_Empty(context, token2)) {
            this.build(context, token2);
            return 42;
        }
        String stateComment = "State: 42 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0";
        List<String> expectedTokens = Arrays.asList("#EOF", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error2 = token2.isEOF() ? new ParserException.UnexpectedEOFException(token2, expectedTokens, "State: 42 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token2, expectedTokens, "State: 42 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0");
        this.addError(context, error2);
        return 42;
    }

    private boolean lookahead_0(ParserContext context, Token currentToken) {
        Token token2;
        ArrayDeque<Token> queue = new ArrayDeque<Token>();
        boolean match2 = false;
        do {
            token2 = this.readToken(context);
            queue.add(token2);
            if (!this.match_ScenarioLine(context, token2)) continue;
            match2 = true;
            break;
        } while (this.match_Empty(context, token2) || this.match_Comment(context, token2) || this.match_TagLine(context, token2));
        context.tokenQueue.addAll(queue);
        return match2;
    }

    private boolean lookahead_1(ParserContext context, Token currentToken) {
        Token token2;
        ArrayDeque<Token> queue = new ArrayDeque<Token>();
        boolean match2 = false;
        do {
            token2 = this.readToken(context);
            queue.add(token2);
            if (!this.match_ExamplesLine(context, token2)) continue;
            match2 = true;
            break;
        } while (this.match_Empty(context, token2) || this.match_Comment(context, token2) || this.match_TagLine(context, token2));
        context.tokenQueue.addAll(queue);
        return match2;
    }

    static interface TokenMatcher {
        public boolean match_EOF(Token var1);

        public boolean match_Empty(Token var1);

        public boolean match_Comment(Token var1);

        public boolean match_TagLine(Token var1);

        public boolean match_FeatureLine(Token var1);

        public boolean match_RuleLine(Token var1);

        public boolean match_BackgroundLine(Token var1);

        public boolean match_ScenarioLine(Token var1);

        public boolean match_ExamplesLine(Token var1);

        public boolean match_StepLine(Token var1);

        public boolean match_DocStringSeparator(Token var1);

        public boolean match_TableRow(Token var1);

        public boolean match_Language(Token var1);

        public boolean match_Other(Token var1);

        public void reset();
    }

    static interface Builder<T> {
        public void build(Token var1);

        public void startRule(RuleType var1);

        public void endRule(RuleType var1);

        public T getResult();

        public void reset(String var1);
    }

    static class ParserContext {
        final TokenScanner tokenScanner;
        final TokenMatcher tokenMatcher;
        final Queue<Token> tokenQueue;
        final List<ParserException> errors;

        ParserContext(TokenScanner tokenScanner, TokenMatcher tokenMatcher, Queue<Token> tokenQueue, List<ParserException> errors2) {
            this.tokenScanner = tokenScanner;
            this.tokenMatcher = tokenMatcher;
            this.tokenQueue = tokenQueue;
            this.errors = errors2;
        }
    }

    static enum RuleType {
        None,
        _EOF,
        _Empty,
        _Comment,
        _TagLine,
        _FeatureLine,
        _RuleLine,
        _BackgroundLine,
        _ScenarioLine,
        _ExamplesLine,
        _StepLine,
        _DocStringSeparator,
        _TableRow,
        _Language,
        _Other,
        GherkinDocument,
        Feature,
        FeatureHeader,
        Rule,
        RuleHeader,
        Background,
        ScenarioDefinition,
        Scenario,
        ExamplesDefinition,
        Examples,
        ExamplesTable,
        Step,
        StepArg,
        DataTable,
        DocString,
        Tags,
        DescriptionHelper,
        Description;

    }

    static enum TokenType {
        None(RuleType.None),
        EOF(RuleType._EOF),
        Empty(RuleType._Empty),
        Comment(RuleType._Comment),
        TagLine(RuleType._TagLine),
        FeatureLine(RuleType._FeatureLine),
        RuleLine(RuleType._RuleLine),
        BackgroundLine(RuleType._BackgroundLine),
        ScenarioLine(RuleType._ScenarioLine),
        ExamplesLine(RuleType._ExamplesLine),
        StepLine(RuleType._StepLine),
        DocStringSeparator(RuleType._DocStringSeparator),
        TableRow(RuleType._TableRow),
        Language(RuleType._Language),
        Other(RuleType._Other);

        final RuleType ruleType;

        private TokenType(RuleType ruleType) {
            this.ruleType = ruleType;
        }
    }
}

