/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.types.DataTable;
import io.cucumber.messages.types.DocString;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleDocString;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.PickleStepArgument;
import io.cucumber.messages.types.PickleStepType;
import io.cucumber.messages.types.PickleTable;
import io.cucumber.messages.types.PickleTableCell;
import io.cucumber.messages.types.PickleTableRow;
import io.cucumber.messages.types.PickleTag;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.RuleChild;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.StepKeywordType;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

class PickleCompiler {
    private final IdGenerator idGenerator;
    private static final Map<StepKeywordType, PickleStepType> pickleStepTypeFromKeywordType = new EnumMap<StepKeywordType, PickleStepType>(StepKeywordType.class);

    PickleCompiler(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    List<Pickle> compile(GherkinDocument gherkinDocument, String uri2) {
        ArrayList<Pickle> pickles = new ArrayList<Pickle>();
        if (!gherkinDocument.getFeature().isPresent()) {
            return pickles;
        }
        Feature feature = gherkinDocument.getFeature().get();
        String language = feature.getLanguage();
        this.compileFeature(pickles, feature, language, uri2);
        return pickles;
    }

    private void compileFeature(List<Pickle> pickles, Feature feature, String language, String uri2) {
        List<Tag> tags = feature.getTags();
        ArrayList<Step> featureBackgroundSteps = new ArrayList<Step>();
        for (FeatureChild featureChild : feature.getChildren()) {
            if (featureChild.getBackground().isPresent()) {
                featureBackgroundSteps.addAll(featureChild.getBackground().get().getSteps());
                continue;
            }
            if (featureChild.getRule().isPresent()) {
                this.compileRule(pickles, featureChild.getRule().get(), tags, featureBackgroundSteps, language, uri2);
                continue;
            }
            if (!featureChild.getScenario().isPresent()) continue;
            Scenario scenario = featureChild.getScenario().get();
            if (scenario.getExamples().isEmpty()) {
                this.compileScenario(pickles, scenario, tags, featureBackgroundSteps, language, uri2);
                continue;
            }
            this.compileScenarioOutline(pickles, scenario, tags, featureBackgroundSteps, language, uri2);
        }
    }

    private void compileRule(List<Pickle> pickles, Rule rule, List<Tag> parentTags, List<Step> featureBackgroundSteps, String language, String uri2) {
        ArrayList<Step> ruleBackgroundSteps = new ArrayList<Step>(featureBackgroundSteps);
        ArrayList<Tag> ruleTags = new ArrayList<Tag>();
        ruleTags.addAll(parentTags);
        ruleTags.addAll(rule.getTags());
        for (RuleChild ruleChild : rule.getChildren()) {
            if (ruleChild.getBackground().isPresent()) {
                ruleBackgroundSteps.addAll(ruleChild.getBackground().get().getSteps());
                continue;
            }
            if (!ruleChild.getScenario().isPresent()) continue;
            Scenario scenario = ruleChild.getScenario().get();
            if (scenario.getExamples().isEmpty()) {
                this.compileScenario(pickles, scenario, ruleTags, ruleBackgroundSteps, language, uri2);
                continue;
            }
            this.compileScenarioOutline(pickles, scenario, ruleTags, ruleBackgroundSteps, language, uri2);
        }
    }

    private void compileScenario(List<Pickle> pickles, Scenario scenario, List<Tag> parentTags, List<Step> backgroundSteps, String language, String uri2) {
        ArrayList<PickleStep> steps = new ArrayList<PickleStep>();
        if (!scenario.getSteps().isEmpty()) {
            ArrayList<Step> allSteps = new ArrayList<Step>();
            allSteps.addAll(backgroundSteps);
            allSteps.addAll(scenario.getSteps());
            StepKeywordType lastKeywordType = StepKeywordType.UNKNOWN;
            for (Step step : allSteps) {
                StepKeywordType stepKeywordType = step.getKeywordType().get();
                if (stepKeywordType != StepKeywordType.CONJUNCTION) {
                    lastKeywordType = stepKeywordType;
                }
                steps.add(this.pickleStep(step, lastKeywordType));
            }
        }
        ArrayList<Tag> scenarioTags = new ArrayList<Tag>();
        scenarioTags.addAll(parentTags);
        scenarioTags.addAll(scenario.getTags());
        List<String> sourceIds = Collections.singletonList(scenario.getId());
        Pickle pickle = new Pickle(this.idGenerator.newId(), uri2, scenario.getName(), language, steps, this.pickleTags(scenarioTags), sourceIds);
        pickles.add(pickle);
    }

    private void compileScenarioOutline(List<Pickle> pickles, Scenario scenario, List<Tag> featureTags, List<Step> backgroundSteps, String language, String uri2) {
        for (Examples examples : scenario.getExamples()) {
            if (!examples.getTableHeader().isPresent()) continue;
            List<TableCell> variableCells = examples.getTableHeader().get().getCells();
            for (TableRow valuesRow : examples.getTableBody()) {
                List<TableCell> valueCells = valuesRow.getCells();
                ArrayList<PickleStep> steps = new ArrayList<PickleStep>();
                StepKeywordType lastKeywordType = StepKeywordType.UNKNOWN;
                if (!scenario.getSteps().isEmpty()) {
                    for (Step step : backgroundSteps) {
                        StepKeywordType stepKeywordType = step.getKeywordType().get();
                        if (stepKeywordType != StepKeywordType.CONJUNCTION) {
                            lastKeywordType = stepKeywordType;
                        }
                        steps.add(this.pickleStep(step, lastKeywordType));
                    }
                }
                ArrayList<Tag> tags = new ArrayList<Tag>();
                tags.addAll(featureTags);
                tags.addAll(scenario.getTags());
                tags.addAll(examples.getTags());
                for (Step scenarioOutlineStep : scenario.getSteps()) {
                    StepKeywordType stepKeywordType = scenarioOutlineStep.getKeywordType().get();
                    if (stepKeywordType != StepKeywordType.CONJUNCTION) {
                        lastKeywordType = stepKeywordType;
                    }
                    PickleStep pickleStep = this.pickleStep(scenarioOutlineStep, variableCells, valuesRow, lastKeywordType);
                    steps.add(pickleStep);
                }
                List<String> list = Arrays.asList(scenario.getId(), valuesRow.getId());
                Pickle pickle = new Pickle(this.idGenerator.newId(), uri2, this.interpolate(scenario.getName(), variableCells, valueCells), language, steps, this.pickleTags(tags), list);
                pickles.add(pickle);
            }
        }
    }

    private PickleTable pickleDataTable(DataTable dataTable, List<TableCell> variableCells, List<TableCell> valueCells) {
        List<TableRow> rows2 = dataTable.getRows();
        ArrayList<PickleTableRow> newRows = new ArrayList<PickleTableRow>(rows2.size());
        for (TableRow row : rows2) {
            List<TableCell> cells = row.getCells();
            ArrayList<PickleTableCell> newCells = new ArrayList<PickleTableCell>(cells.size());
            for (TableCell cell : cells) {
                newCells.add(new PickleTableCell(this.interpolate(cell.getValue(), variableCells, valueCells)));
            }
            newRows.add(new PickleTableRow(newCells));
        }
        return new PickleTable(newRows);
    }

    private PickleDocString pickleDocString(DocString docString, List<TableCell> variableCells, List<TableCell> valueCells) {
        return new PickleDocString(docString.getMediaType().isPresent() ? this.interpolate(docString.getMediaType().get(), variableCells, valueCells) : null, this.interpolate(docString.getContent(), variableCells, valueCells));
    }

    private PickleStep pickleStep(Step step, List<TableCell> variableCells, TableRow valuesRow, StepKeywordType keywordType) {
        List<TableCell> valueCells = valuesRow == null ? Collections.emptyList() : valuesRow.getCells();
        String stepText = this.interpolate(step.getText(), variableCells, valueCells);
        PickleStepArgument argument = null;
        if (step.getDataTable().isPresent()) {
            argument = new PickleStepArgument(null, this.pickleDataTable(step.getDataTable().get(), variableCells, valueCells));
        }
        if (step.getDocString().isPresent()) {
            argument = new PickleStepArgument(this.pickleDocString(step.getDocString().get(), variableCells, valueCells), null);
        }
        List<String> astNodeIds = valuesRow != null ? Arrays.asList(step.getId(), valuesRow.getId()) : Collections.singletonList(step.getId());
        return new PickleStep(argument, astNodeIds, this.idGenerator.newId(), pickleStepTypeFromKeywordType.get((Object)keywordType), stepText);
    }

    private PickleStep pickleStep(Step step, StepKeywordType keywordType) {
        return this.pickleStep(step, Collections.emptyList(), null, keywordType);
    }

    private String interpolate(String name, List<TableCell> variableCells, List<TableCell> valueCells) {
        int col = 0;
        for (TableCell variableCell : variableCells) {
            TableCell valueCell = valueCells.get(col++);
            String header = variableCell.getValue();
            String value2 = valueCell.getValue();
            name = name.replace("<" + header + ">", value2);
        }
        return name;
    }

    private List<PickleTag> pickleTags(List<Tag> tags) {
        if (tags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PickleTag> result2 = new ArrayList<PickleTag>();
        for (Tag tag : tags) {
            result2.add(this.pickleTag(tag));
        }
        return result2;
    }

    private PickleTag pickleTag(Tag tag) {
        return new PickleTag(tag.getName(), tag.getId());
    }

    static {
        pickleStepTypeFromKeywordType.put(StepKeywordType.UNKNOWN, PickleStepType.UNKNOWN);
        pickleStepTypeFromKeywordType.put(StepKeywordType.CONTEXT, PickleStepType.CONTEXT);
        pickleStepTypeFromKeywordType.put(StepKeywordType.ACTION, PickleStepType.ACTION);
        pickleStepTypeFromKeywordType.put(StepKeywordType.OUTCOME, PickleStepType.OUTCOME);
    }
}

