/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import java.util.AbstractMap;
import java.util.Map;

class StringUtils {
    private static final char[] WHITESPACE_CHARS = new char[]{' ', '\t', '\n', '\u000b', '\f', '\r'};
    private static final char[] WHITESPACE_CHARS_EXTENDED = new char[]{' ', '\t', '\n', '\u000b', '\f', '\r', '\u0085', '\u00a0'};
    private static final char[] WHITESPACE_CHARS_EXTENDED_KEEP_NEW_LINES = new char[]{' ', '\t', '\u000b', '\f', '\r', '\u0085', '\u00a0'};

    StringUtils() {
    }

    static String rtrim(String s2) {
        int end2;
        if (s2.isEmpty()) {
            return s2;
        }
        int length = s2.length();
        for (end2 = length - 1; end2 >= 0 && StringUtils.contains(WHITESPACE_CHARS_EXTENDED, s2.charAt(end2)); --end2) {
        }
        return s2.substring(0, end2 + 1);
    }

    static Map.Entry<String, Integer> trimAndIndentKeepNewLines(String input) {
        return StringUtils.trimAndIndent(input, WHITESPACE_CHARS_EXTENDED_KEEP_NEW_LINES);
    }

    static Map.Entry<String, Integer> trimAndIndent(String input) {
        return StringUtils.trimAndIndent(input, WHITESPACE_CHARS_EXTENDED);
    }

    private static Map.Entry<String, Integer> trimAndIndent(String input, char[] whitespaceChars) {
        if (input.isEmpty()) {
            return new AbstractMap.SimpleEntry<String, Integer>("", 0);
        }
        int start2 = StringUtils.findFirstIndexNotIn(input, input.length(), whitespaceChars);
        int end2 = StringUtils.findLastIndexNotIn(input, start2, whitespaceChars);
        String trimmed = input.substring(start2, end2);
        int indent = input.codePointCount(0, start2);
        return new AbstractMap.SimpleEntry<String, Integer>(trimmed, indent);
    }

    static String removeComments(String input) {
        int start2;
        if (input.isEmpty()) {
            return input;
        }
        int length = input.length();
        for (start2 = 0; !(start2 >= length - 1 || StringUtils.contains(WHITESPACE_CHARS, input.charAt(start2)) && input.charAt(start2 + 1) == '#'); ++start2) {
        }
        return input.substring(0, start2 < length - 1 ? start2 : start2 + 1);
    }

    static boolean containsWhiteSpace(String input) {
        return StringUtils.findFirstIndexIn(input, WHITESPACE_CHARS) != -1;
    }

    private static int findFirstIndexNotIn(String input, int endIndex, char[] characters) {
        int start2;
        for (start2 = 0; start2 < endIndex && StringUtils.contains(characters, input.charAt(start2)); ++start2) {
        }
        return start2;
    }

    private static int findLastIndexNotIn(String input, int beginIndex, char[] characters) {
        int end2;
        for (end2 = input.length(); end2 > beginIndex && StringUtils.contains(characters, input.charAt(end2 - 1)); --end2) {
        }
        return end2;
    }

    private static int findFirstIndexIn(String input, char[] characters) {
        int length = input.length();
        for (int i2 = 0; i2 < length; ++i2) {
            if (!StringUtils.contains(characters, input.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    private static boolean contains(char[] characters, char c2) {
        for (char candidate : characters) {
            if (candidate != c2) continue;
            return true;
        }
        return false;
    }
}

