/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages;

import io.cucumber.messages.types.Envelope;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Objects;

public final class NdjsonToMessageIterable
implements Iterable<Envelope>,
AutoCloseable {
    private final BufferedReader reader;
    private final Deserializer deserializer;

    public NdjsonToMessageIterable(InputStream inputStream2, Deserializer deserializer) {
        this(new InputStreamReader(Objects.requireNonNull(inputStream2), StandardCharsets.UTF_8), Objects.requireNonNull(deserializer));
    }

    private NdjsonToMessageIterable(Reader reader2, Deserializer deserializer) {
        this(new BufferedReader(reader2), deserializer);
    }

    private NdjsonToMessageIterable(BufferedReader reader2, Deserializer deserializer) {
        this.reader = reader2;
        this.deserializer = deserializer;
    }

    @Override
    public Iterator<Envelope> iterator() {
        return new Iterator<Envelope>(){
            private Envelope next;

            @Override
            public boolean hasNext() {
                try {
                    String line = NdjsonToMessageIterable.this.reader.readLine();
                    if (line == null) {
                        return false;
                    }
                    if (line.trim().equals("")) {
                        return this.hasNext();
                    }
                    try {
                        this.next = NdjsonToMessageIterable.this.deserializer.readValue(line);
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(String.format("Could not parse JSON: %s", line), e2);
                    }
                    return true;
                }
                catch (IOException e3) {
                    throw new RuntimeException(e3);
                }
            }

            @Override
            public Envelope next() {
                if (this.next == null) {
                    throw new IllegalStateException("next() should only be called after a call to hasNext() that returns true");
                }
                return this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @FunctionalInterface
    public static interface Deserializer {
        public Envelope readValue(String var1) throws IOException;
    }
}

