/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Location;
import java.util.Objects;
import java.util.Optional;

public final class DocString {
    private final Location location;
    private final String mediaType;
    private final String content;
    private final String delimiter;

    public DocString(Location location, String mediaType, String content2, String delimiter) {
        this.location = Objects.requireNonNull(location, "DocString.location cannot be null");
        this.mediaType = mediaType;
        this.content = Objects.requireNonNull(content2, "DocString.content cannot be null");
        this.delimiter = Objects.requireNonNull(delimiter, "DocString.delimiter cannot be null");
    }

    public Location getLocation() {
        return this.location;
    }

    public Optional<String> getMediaType() {
        return Optional.ofNullable(this.mediaType);
    }

    public String getContent() {
        return this.content;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocString that = (DocString)o;
        return this.location.equals(that.location) && Objects.equals(this.mediaType, that.mediaType) && this.content.equals(that.content) && this.delimiter.equals(that.delimiter);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.mediaType, this.content, this.delimiter);
    }

    public String toString() {
        return "DocString{location=" + this.location + ", mediaType=" + this.mediaType + ", content=" + this.content + ", delimiter=" + this.delimiter + '}';
    }
}

