/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Comment;
import io.cucumber.messages.types.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class GherkinDocument {
    private final String uri;
    private final Feature feature;
    private final List<Comment> comments;

    public GherkinDocument(String uri2, Feature feature, List<Comment> comments) {
        this.uri = uri2;
        this.feature = feature;
        this.comments = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(comments, "GherkinDocument.comments cannot be null")));
    }

    public Optional<String> getUri() {
        return Optional.ofNullable(this.uri);
    }

    public Optional<Feature> getFeature() {
        return Optional.ofNullable(this.feature);
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GherkinDocument that = (GherkinDocument)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.feature, that.feature) && this.comments.equals(that.comments);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.feature, this.comments);
    }

    public String toString() {
        return "GherkinDocument{uri=" + this.uri + ", feature=" + this.feature + ", comments=" + this.comments + '}';
    }
}

