/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.PickleTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Pickle {
    private final String id;
    private final String uri;
    private final String name;
    private final String language;
    private final List<PickleStep> steps;
    private final List<PickleTag> tags;
    private final List<String> astNodeIds;

    public Pickle(String id, String uri2, String name, String language, List<PickleStep> steps, List<PickleTag> tags, List<String> astNodeIds) {
        this.id = Objects.requireNonNull(id, "Pickle.id cannot be null");
        this.uri = Objects.requireNonNull(uri2, "Pickle.uri cannot be null");
        this.name = Objects.requireNonNull(name, "Pickle.name cannot be null");
        this.language = Objects.requireNonNull(language, "Pickle.language cannot be null");
        this.steps = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(steps, "Pickle.steps cannot be null")));
        this.tags = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(tags, "Pickle.tags cannot be null")));
        this.astNodeIds = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(astNodeIds, "Pickle.astNodeIds cannot be null")));
    }

    public String getId() {
        return this.id;
    }

    public String getUri() {
        return this.uri;
    }

    public String getName() {
        return this.name;
    }

    public String getLanguage() {
        return this.language;
    }

    public List<PickleStep> getSteps() {
        return this.steps;
    }

    public List<PickleTag> getTags() {
        return this.tags;
    }

    public List<String> getAstNodeIds() {
        return this.astNodeIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pickle that = (Pickle)o;
        return this.id.equals(that.id) && this.uri.equals(that.uri) && this.name.equals(that.name) && this.language.equals(that.language) && this.steps.equals(that.steps) && this.tags.equals(that.tags) && this.astNodeIds.equals(that.astNodeIds);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uri, this.name, this.language, this.steps, this.tags, this.astNodeIds);
    }

    public String toString() {
        return "Pickle{id=" + this.id + ", uri=" + this.uri + ", name=" + this.name + ", language=" + this.language + ", steps=" + this.steps + ", tags=" + this.tags + ", astNodeIds=" + this.astNodeIds + '}';
    }
}

