/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import java.util.Objects;
import java.util.Optional;

public final class Product {
    private final String name;
    private final String version;

    public Product(String name, String version2) {
        this.name = Objects.requireNonNull(name, "Product.name cannot be null");
        this.version = version2;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Product that = (Product)o;
        return this.name.equals(that.name) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    public String toString() {
        return "Product{name=" + this.name + ", version=" + this.version + '}';
    }
}

