/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Duration;
import io.cucumber.messages.types.Exception;
import io.cucumber.messages.types.TestStepResultStatus;
import java.util.Objects;
import java.util.Optional;

public final class TestStepResult {
    private final Duration duration;
    private final String message;
    private final TestStepResultStatus status;
    private final Exception exception;

    public TestStepResult(Duration duration, String message, TestStepResultStatus status2, Exception exception) {
        this.duration = Objects.requireNonNull(duration, "TestStepResult.duration cannot be null");
        this.message = message;
        this.status = Objects.requireNonNull(status2, "TestStepResult.status cannot be null");
        this.exception = exception;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public TestStepResultStatus getStatus() {
        return this.status;
    }

    public Optional<Exception> getException() {
        return Optional.ofNullable(this.exception);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestStepResult that = (TestStepResult)o;
        return this.duration.equals(that.duration) && Objects.equals(this.message, that.message) && this.status.equals((Object)that.status) && Objects.equals(this.exception, that.exception);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.duration, this.message, this.status, this.exception});
    }

    public String toString() {
        return "TestStepResult{duration=" + this.duration + ", message=" + this.message + ", status=" + (Object)((Object)this.status) + ", exception=" + this.exception + '}';
    }
}

