/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0012B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/ktor/server/engine/OverridingClassLoader;", "Ljava/lang/ClassLoader;", "Ljava/io/Closeable;", "classpath", "", "Ljava/net/URL;", "parentClassLoader", "(Ljava/util/List;Ljava/lang/ClassLoader;)V", "childClassLoader", "Lio/ktor/server/engine/OverridingClassLoader$ChildURLClassLoader;", "close", "", "loadClass", "Ljava/lang/Class;", "name", "", "resolve", "", "ChildURLClassLoader", "ktor-server-host-common"})
@SourceDebugExtension(value={"SMAP\nOverridingClassLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverridingClassLoader.kt\nio/ktor/server/engine/OverridingClassLoader\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,70:1\n37#2,2:71\n*S KotlinDebug\n*F\n+ 1 OverridingClassLoader.kt\nio/ktor/server/engine/OverridingClassLoader\n*L\n18#1:71,2\n*E\n"})
public final class OverridingClassLoader
extends ClassLoader
implements Closeable {
    @NotNull
    private final ChildURLClassLoader childClassLoader;

    public OverridingClassLoader(@NotNull List<URL> classpath, @Nullable ClassLoader parentClassLoader) {
        Intrinsics.checkNotNullParameter(classpath, "classpath");
        super(parentClassLoader);
        Collection $this$toTypedArray$iv = classpath;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ClassLoader classLoader = this.getParent();
        Intrinsics.checkNotNullExpressionValue(classLoader, "parent");
        this.childClassLoader = new ChildURLClassLoader(thisCollection$iv.toArray(new URL[0]), classLoader);
    }

    @Override
    @NotNull
    protected synchronized Class<?> loadClass(@NotNull String name, boolean resolve2) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter(name, "name");
        try {
            clazz = this.childClassLoader.findClass(name);
        }
        catch (ClassNotFoundException e2) {
            Class<?> clazz2 = super.loadClass(name, resolve2);
            Intrinsics.checkNotNullExpressionValue(clazz2, "{\n        // didn't find\u2026lass(name, resolve)\n    }");
            clazz = clazz2;
        }
        return clazz;
    }

    @Override
    public void close() {
        this.childClassLoader.close();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/ktor/server/engine/OverridingClassLoader$ChildURLClassLoader;", "Ljava/net/URLClassLoader;", "urls", "", "Ljava/net/URL;", "realParent", "Ljava/lang/ClassLoader;", "([Ljava/net/URL;Ljava/lang/ClassLoader;)V", "findClass", "Ljava/lang/Class;", "name", "", "findResource", "findResources", "Ljava/util/Enumeration;", "getResource", "getResourceAsStream", "Ljava/io/InputStream;", "getResources", "ktor-server-host-common"})
    private static final class ChildURLClassLoader
    extends URLClassLoader {
        @NotNull
        private final ClassLoader realParent;

        public ChildURLClassLoader(@NotNull URL[] urls2, @NotNull ClassLoader realParent) {
            Intrinsics.checkNotNullParameter(urls2, "urls");
            Intrinsics.checkNotNullParameter(realParent, "realParent");
            super(urls2, (ClassLoader)null);
            this.realParent = realParent;
        }

        @Override
        @NotNull
        public Class<?> findClass(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            Class<?> loaded = super.findLoadedClass(name);
            if (loaded != null) {
                return loaded;
            }
            try {
                Class<?> clazz = super.findClass(name);
                Intrinsics.checkNotNullExpressionValue(clazz, "super.findClass(name)");
                return clazz;
            }
            catch (ClassNotFoundException e2) {
                Class<?> clazz = this.realParent.loadClass(name);
                Intrinsics.checkNotNullExpressionValue(clazz, "realParent.loadClass(name)");
                return clazz;
            }
        }

        @Override
        @NotNull
        public Enumeration<URL> getResources(@Nullable String name) {
            Enumeration<URL> enumeration = this.realParent.getResources(name);
            Intrinsics.checkNotNullExpressionValue(enumeration, "realParent.getResources(name)");
            return enumeration;
        }

        @Override
        @Nullable
        public URL getResource(@Nullable String name) {
            return this.realParent.getResource(name);
        }

        @Override
        @Nullable
        public InputStream getResourceAsStream(@Nullable String name) {
            return this.realParent.getResourceAsStream(name);
        }

        @Override
        @Nullable
        public URL findResource(@Nullable String name) {
            return null;
        }

        @Override
        @NotNull
        public Enumeration<URL> findResources(@Nullable String name) {
            Enumeration<URL> enumeration = Collections.emptyEnumeration();
            Intrinsics.checkNotNullExpressionValue(enumeration, "emptyEnumeration()");
            return enumeration;
        }
    }
}

