/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.http.content;

import io.ktor.http.CodecsKt;
import io.ktor.http.ContentType;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.URIFileContent;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.http.content.JarFileContent;
import io.ktor.server.http.content.LocalFileContent;
import io.ktor.server.http.content.StaticContentResolutionKt;
import io.ktor.server.plugins.BadRequestException;
import io.ktor.server.util.PathsKt;
import io.ktor.util.InternalAPI;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u001a.\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00032\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bH\u0007\u001a\f\u0010\r\u001a\u00020\u0003*\u00020\u0003H\u0000\u001aL\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\b\u0018\u00010\u000f*\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u00122\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bH\u0000\u001a@\u0010\u000e\u001a\u0004\u0018\u00010\b*\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u00122\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\u0014"}, d2={"findContainingJarFile", "Ljava/io/File;", "url", "", "normalisedPath", "resourcePackage", "path", "resourceClasspathResource", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "Ljava/net/URL;", "mimeResolve", "Lkotlin/Function1;", "Lio/ktor/http/ContentType;", "extension", "resolveResource", "Lkotlin/Pair;", "Lio/ktor/server/application/Application;", "classLoader", "Ljava/lang/ClassLoader;", "Lio/ktor/server/application/ApplicationCall;", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nStaticContentResolution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StaticContentResolution.kt\nio/ktor/server/http/content/StaticContentResolutionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
public final class StaticContentResolutionKt {
    @Nullable
    public static final OutgoingContent.ReadChannelContent resolveResource(@NotNull ApplicationCall $this$resolveResource, @NotNull String path2, @Nullable String resourcePackage, @NotNull ClassLoader classLoader, @NotNull Function1<? super String, ContentType> mimeResolve) {
        Intrinsics.checkNotNullParameter($this$resolveResource, "<this>");
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        Intrinsics.checkNotNullParameter(mimeResolve, "mimeResolve");
        if (StringsKt.endsWith$default(path2, "/", false, 2, null) || StringsKt.endsWith$default(path2, "\\", false, 2, null)) {
            return null;
        }
        String normalizedPath = StaticContentResolutionKt.normalisedPath(resourcePackage, path2);
        Enumeration<URL> enumeration = classLoader.getResources(normalizedPath);
        Intrinsics.checkNotNullExpressionValue(enumeration, "classLoader.getResources(normalizedPath)");
        Iterator<URL> iterator2 = SequencesKt.asSequence(CollectionsKt.iterator(enumeration)).iterator();
        while (iterator2.hasNext()) {
            URL url2 = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(url2, "url");
            OutgoingContent.ReadChannelContent readChannelContent = StaticContentResolutionKt.resourceClasspathResource(url2, normalizedPath, (Function1<? super URL, ContentType>)new Function1<URL, ContentType>(mimeResolve){
                final /* synthetic */ Function1<String, ContentType> $mimeResolve;
                {
                    this.$mimeResolve = $mimeResolve;
                    super(1);
                }

                @NotNull
                public final ContentType invoke(@NotNull URL it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    String string = it.getPath();
                    Intrinsics.checkNotNullExpressionValue(string, "it.path");
                    return this.$mimeResolve.invoke(StaticContentResolutionKt.extension(string));
                }
            });
            if (readChannelContent == null) continue;
            OutgoingContent.ReadChannelContent content2 = readChannelContent;
            boolean bl = false;
            return content2;
        }
        return null;
    }

    public static /* synthetic */ OutgoingContent.ReadChannelContent resolveResource$default(ApplicationCall applicationCall, String string, String string2, ClassLoader classLoader, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            classLoader = applicationCall.getApplication().getEnvironment().getClassLoader();
        }
        if ((n & 8) != 0) {
            function1 = resolveResource.1.INSTANCE;
        }
        return StaticContentResolutionKt.resolveResource(applicationCall, string, string2, classLoader, function1);
    }

    @Nullable
    public static final Pair<URL, OutgoingContent.ReadChannelContent> resolveResource(@NotNull Application $this$resolveResource, @NotNull String path2, @Nullable String resourcePackage, @NotNull ClassLoader classLoader, @NotNull Function1<? super URL, ContentType> mimeResolve) {
        Intrinsics.checkNotNullParameter($this$resolveResource, "<this>");
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        Intrinsics.checkNotNullParameter(mimeResolve, "mimeResolve");
        if (StringsKt.endsWith$default(path2, "/", false, 2, null) || StringsKt.endsWith$default(path2, "\\", false, 2, null)) {
            return null;
        }
        String normalizedPath = StaticContentResolutionKt.normalisedPath(resourcePackage, path2);
        Enumeration<URL> enumeration = classLoader.getResources(normalizedPath);
        Intrinsics.checkNotNullExpressionValue(enumeration, "classLoader.getResources(normalizedPath)");
        Iterator<URL> iterator2 = SequencesKt.asSequence(CollectionsKt.iterator(enumeration)).iterator();
        while (iterator2.hasNext()) {
            URL url2 = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(url2, "url");
            OutgoingContent.ReadChannelContent readChannelContent = StaticContentResolutionKt.resourceClasspathResource(url2, normalizedPath, mimeResolve);
            if (readChannelContent == null) continue;
            OutgoingContent.ReadChannelContent content2 = readChannelContent;
            boolean bl = false;
            return TuplesKt.to(url2, content2);
        }
        return null;
    }

    public static /* synthetic */ Pair resolveResource$default(Application application, String string, String string2, ClassLoader classLoader, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            classLoader = application.getEnvironment().getClassLoader();
        }
        return StaticContentResolutionKt.resolveResource(application, string, string2, classLoader, function1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InternalAPI
    @Nullable
    public static final OutgoingContent.ReadChannelContent resourceClasspathResource(@NotNull URL url2, @NotNull String path2, @NotNull Function1<? super URL, ContentType> mimeResolve) {
        Intrinsics.checkNotNullParameter(url2, "url");
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(mimeResolve, "mimeResolve");
        String string = url2.getProtocol();
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case 3143036: {
                if (string.equals("file")) {
                    n = 1;
                }
                break;
            }
            case -341064690: {
                if (string.equals("resource")) {
                    n = 2;
                }
                break;
            }
            case 104987: {
                if (string.equals("jar")) {
                    n = 3;
                }
                break;
            }
            case 105516: {
                if (string.equals("jrt")) {
                    n = 2;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                String string2 = url2.getPath();
                Intrinsics.checkNotNullExpressionValue(string2, "url.path");
                File file2 = new File(CodecsKt.decodeURLPart$default(string2, 0, 0, null, 7, null));
                OutgoingContent.ReadChannelContent readChannelContent = file2.isFile() ? new LocalFileContent(file2, mimeResolve.invoke(url2)) : null;
                return readChannelContent;
            }
            case 3: {
                JarFileContent jarFileContent;
                if (StringsKt.endsWith$default(path2, "/", false, 2, null)) {
                    jarFileContent = null;
                } else {
                    String string3 = url2.toString();
                    Intrinsics.checkNotNullExpressionValue(string3, "url.toString()");
                    File zipFile = StaticContentResolutionKt.findContainingJarFile(string3);
                    JarFileContent content2 = new JarFileContent(zipFile, path2, mimeResolve.invoke(url2));
                    jarFileContent = content2.isFile() ? content2 : null;
                }
                OutgoingContent.ReadChannelContent readChannelContent = jarFileContent;
                return readChannelContent;
            }
            case 2: {
                OutgoingContent.ReadChannelContent readChannelContent = new URIFileContent(url2, mimeResolve.invoke(url2));
                return readChannelContent;
            }
            default: {
                return null;
            }
        }
    }

    @NotNull
    public static final File findContainingJarFile(@NotNull String url2) {
        Intrinsics.checkNotNullParameter(url2, "url");
        if (StringsKt.startsWith$default(url2, "jar:file:", false, 2, null)) {
            int jarPathSeparator = StringsKt.indexOf$default((CharSequence)url2, "!", 9, false, 4, null);
            if (!(jarPathSeparator != -1)) {
                boolean bl = false;
                String string = "Jar path requires !/ separator but it is: " + url2;
                throw new IllegalArgumentException(string.toString());
            }
            String string = url2.substring(9, jarPathSeparator);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            return new File(CodecsKt.decodeURLPart$default(string, 0, 0, null, 7, null));
        }
        throw new IllegalArgumentException("Only local jars are supported (jar:file:)");
    }

    @NotNull
    public static final String extension(@NotNull String $this$extension) {
        String string;
        int n;
        Intrinsics.checkNotNullParameter($this$extension, "<this>");
        Integer n2 = StringsKt.lastIndexOf$default((CharSequence)$this$extension, '/', 0, false, 6, null);
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = it != -1 ? n2 : null;
        if (n3 != null) {
            n = n3;
        } else {
            Integer n4 = StringsKt.lastIndexOf$default((CharSequence)$this$extension, '\\', 0, false, 6, null);
            int it2 = ((Number)n4).intValue();
            boolean bl2 = false;
            Integer n5 = it2 != -1 ? n4 : null;
            n = n5 != null ? n5 : 0;
        }
        int indexOfName = n;
        int indexOfDot = StringsKt.indexOf$default((CharSequence)$this$extension, '.', indexOfName, false, 4, null);
        if (indexOfDot >= 0) {
            String string2 = $this$extension.substring(indexOfDot);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
        } else {
            string = "";
        }
        return string;
    }

    private static final String normalisedPath(String resourcePackage, String path2) {
        char[] cArray = new char[]{'/', '\\'};
        List pathComponents = StringsKt.split$default((CharSequence)path2, cArray, false, 0, 6, null);
        if (pathComponents.contains("..")) {
            throw new BadRequestException("Relative path should not contain path traversing characters: " + path2, null, 2, null);
        }
        String string = resourcePackage;
        if (string == null) {
            string = "";
        }
        cArray = new char[]{'.', '/', '\\'};
        return CollectionsKt.joinToString$default(PathsKt.normalizePathComponents(CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)string, cArray, false, 0, 6, null), (Iterable)pathComponents)), "/", null, null, 0, null, null, 62, null);
    }
}

