/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http2;

import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.netty.NettyApplicationRequest;
import io.ktor.server.netty.NettyApplicationRequestCookies;
import io.ktor.server.netty.http2.Http2LocalConnectionPoint;
import io.ktor.server.netty.http2.HttpFrameAdapterKt;
import io.ktor.server.request.RequestCookies;
import io.ktor.utils.io.ByteChannel;
import io.ktor.utils.io.ByteChannelKt;
import io.ktor.utils.io.ByteReadChannel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.ActorKt;
import kotlinx.coroutines.channels.ActorScope;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010&\u001a\u00020'H\u0014R\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006("}, d2={"Lio/ktor/server/netty/http2/NettyHttp2ApplicationRequest;", "Lio/ktor/server/netty/NettyApplicationRequest;", "call", "Lio/ktor/server/application/ApplicationCall;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "context", "Lio/netty/channel/ChannelHandlerContext;", "nettyHeaders", "Lio/netty/handler/codec/http2/Http2Headers;", "contentByteChannel", "Lio/ktor/utils/io/ByteChannel;", "(Lio/ktor/server/application/ApplicationCall;Lkotlin/coroutines/CoroutineContext;Lio/netty/channel/ChannelHandlerContext;Lio/netty/handler/codec/http2/Http2Headers;Lio/ktor/utils/io/ByteChannel;)V", "contentActor", "Lkotlinx/coroutines/channels/SendChannel;", "Lio/netty/handler/codec/http2/Http2DataFrame;", "getContentActor$annotations", "()V", "getContentActor", "()Lkotlinx/coroutines/channels/SendChannel;", "getContentByteChannel", "()Lio/ktor/utils/io/ByteChannel;", "cookies", "Lio/ktor/server/request/RequestCookies;", "getCookies", "()Lio/ktor/server/request/RequestCookies;", "headers", "Lio/ktor/http/Headers;", "getHeaders", "()Lio/ktor/http/Headers;", "headers$delegate", "Lkotlin/Lazy;", "local", "Lio/ktor/server/netty/http2/Http2LocalConnectionPoint;", "getLocal", "()Lio/ktor/server/netty/http2/Http2LocalConnectionPoint;", "getNettyHeaders", "()Lio/netty/handler/codec/http2/Http2Headers;", "newDecoder", "Lio/netty/handler/codec/http/multipart/HttpPostMultipartRequestDecoder;", "ktor-server-netty"})
public final class NettyHttp2ApplicationRequest
extends NettyApplicationRequest {
    @NotNull
    private final Http2Headers nettyHeaders;
    @NotNull
    private final ByteChannel contentByteChannel;
    @NotNull
    private final Lazy headers$delegate;
    @NotNull
    private final SendChannel<Http2DataFrame> contentActor;
    @NotNull
    private final Http2LocalConnectionPoint local;
    @NotNull
    private final RequestCookies cookies;

    public NettyHttp2ApplicationRequest(@NotNull ApplicationCall call, @NotNull CoroutineContext coroutineContext2, @NotNull ChannelHandlerContext context, @NotNull Http2Headers nettyHeaders, @NotNull ByteChannel contentByteChannel) {
        Intrinsics.checkNotNullParameter(call, "call");
        Intrinsics.checkNotNullParameter(coroutineContext2, "coroutineContext");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(nettyHeaders, "nettyHeaders");
        Intrinsics.checkNotNullParameter(contentByteChannel, "contentByteChannel");
        ByteReadChannel byteReadChannel = contentByteChannel;
        CharSequence charSequence = (CharSequence)nettyHeaders.get(":path");
        if (charSequence == null || (charSequence = ((Object)charSequence).toString()) == null) {
            charSequence = "/";
        }
        super(call, coroutineContext2, context, byteReadChannel, (String)charSequence, true);
        this.nettyHeaders = nettyHeaders;
        this.contentByteChannel = contentByteChannel;
        this.headers$delegate = LazyKt.lazy((Function0)new Function0<Headers>(this){
            final /* synthetic */ NettyHttp2ApplicationRequest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Headers invoke() {
                HeadersBuilder headersBuilder;
                Headers.Companion companion = Headers.Companion;
                NettyHttp2ApplicationRequest nettyHttp2ApplicationRequest = this.this$0;
                boolean $i$f$build = false;
                HeadersBuilder $this$invoke_u24lambda_u241 = headersBuilder = new HeadersBuilder(0, 1, null);
                boolean bl = false;
                Iterable $this$forEach$iv = nettyHttp2ApplicationRequest.getNettyHeaders();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(entry, "(name, value)");
                    CharSequence name = (CharSequence)entry.getKey();
                    CharSequence value2 = (CharSequence)entry.getValue();
                    Intrinsics.checkNotNullExpressionValue(name, "name");
                    if (!(name.length() > 0) || name.charAt(0) == ':') continue;
                    $this$invoke_u24lambda_u241.append(((Object)name).toString(), ((Object)value2).toString());
                }
                return headersBuilder.build();
            }
        });
        this.contentActor = ActorKt.actor$default(this, Dispatchers.getUnconfined(), Integer.MAX_VALUE, null, null, new Function2<ActorScope<Http2DataFrame>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ NettyHttp2ApplicationRequest this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        ActorScope $this$actor = (ActorScope)this.L$0;
                        this.label = 1;
                        Object object3 = HttpFrameAdapterKt.http2frameLoop($this$actor, this.this$0.getContentByteChannel(), this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                Function2<ActorScope<Http2DataFrame>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value2;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull ActorScope<Http2DataFrame> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 12, null);
        SocketAddress socketAddress = context.channel().localAddress();
        InetSocketAddress inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        socketAddress = context.channel().remoteAddress();
        this.local = new Http2LocalConnectionPoint(this.nettyHeaders, inetSocketAddress, socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null);
        this.cookies = new NettyApplicationRequestCookies(this);
    }

    public /* synthetic */ NettyHttp2ApplicationRequest(ApplicationCall applicationCall, CoroutineContext coroutineContext2, ChannelHandlerContext channelHandlerContext, Http2Headers http2Headers, ByteChannel byteChannel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            byteChannel = ByteChannelKt.ByteChannel$default(false, 1, null);
        }
        this(applicationCall, coroutineContext2, channelHandlerContext, http2Headers, byteChannel);
    }

    @NotNull
    public final Http2Headers getNettyHeaders() {
        return this.nettyHeaders;
    }

    @NotNull
    public final ByteChannel getContentByteChannel() {
        return this.contentByteChannel;
    }

    @Override
    @NotNull
    public Headers getHeaders() {
        Lazy lazy = this.headers$delegate;
        return (Headers)lazy.getValue();
    }

    @NotNull
    public final SendChannel<Http2DataFrame> getContentActor() {
        return this.contentActor;
    }

    public static /* synthetic */ void getContentActor$annotations() {
    }

    @Override
    @NotNull
    public Http2LocalConnectionPoint getLocal() {
        return this.local;
    }

    @Override
    @NotNull
    public RequestCookies getCookies() {
        return this.cookies;
    }

    @Override
    @NotNull
    protected HttpPostMultipartRequestDecoder newDecoder() {
        DefaultHttpHeaders hh = new DefaultHttpHeaders(false);
        for (Map.Entry<CharSequence, CharSequence> entry : this.nettyHeaders) {
            Intrinsics.checkNotNullExpressionValue(entry, "nettyHeaders");
            CharSequence name = entry.getKey();
            CharSequence value2 = entry.getValue();
            hh.add(name, (Object)value2);
        }
        DefaultHttpRequest request2 = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.getUri(), hh);
        return new HttpPostMultipartRequestDecoder(request2);
    }
}

