/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.response;

import io.ktor.http.Cookie;
import io.ktor.http.CookieEncoding;
import io.ktor.http.CookieKt;
import io.ktor.server.response.ApplicationResponse;
import io.ktor.server.response.ResponseHeaders;
import io.ktor.util.date.GMTDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJz\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\u00052\u0016\b\u0002\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0019H\u0007Jz\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u001a2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\u00052\u0016\b\u0002\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0019J(\u0010\u001b\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0007J\u0013\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/ktor/server/response/ResponseCookies;", "", "response", "Lio/ktor/server/response/ApplicationResponse;", "secureTransport", "", "(Lio/ktor/server/response/ApplicationResponse;Z)V", "append", "", "item", "Lio/ktor/http/Cookie;", "name", "", "value", "encoding", "Lio/ktor/http/CookieEncoding;", "maxAge", "", "expires", "Lio/ktor/util/date/GMTDate;", "domain", "path", "secure", "httpOnly", "extensions", "", "", "appendExpired", "get", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nResponseCookies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseCookies.kt\nio/ktor/server/response/ResponseCookies\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1549#2:98\n1620#2,3:99\n288#2,2:102\n*S KotlinDebug\n*F\n+ 1 ResponseCookies.kt\nio/ktor/server/response/ResponseCookies\n*L\n23#1:98\n23#1:99,3\n24#1:102,2\n*E\n"})
public final class ResponseCookies {
    @NotNull
    private final ApplicationResponse response;
    private final boolean secureTransport;

    public ResponseCookies(@NotNull ApplicationResponse response2, boolean secureTransport) {
        Intrinsics.checkNotNullParameter(response2, "response");
        this.response = response2;
        this.secureTransport = secureTransport;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Cookie get(@NotNull String name) {
        Object v0;
        block2: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(name, "name");
            Iterable $this$map$iv = this.response.getHeaders().values("Set-Cookie");
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CookieKt.parseServerSetCookieHeader((String)it));
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Cookie it = (Cookie)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), name)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    public final void append(@NotNull Cookie item) {
        Intrinsics.checkNotNullParameter(item, "item");
        ResponseHeaders.append$default(this.response.getHeaders(), "Set-Cookie", CookieKt.renderSetCookieHeader(item), false, 4, null);
    }

    @Deprecated(message="Convert maxAge to Long", level=DeprecationLevel.ERROR)
    public final void append(@NotNull String name, @NotNull String value2, @NotNull CookieEncoding encoding, int maxAge, @Nullable GMTDate expires, @Nullable String domain, @Nullable String path2, boolean secure, boolean httpOnly, @NotNull Map<String, String> extensions) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        this.append(name, value2, encoding, (long)maxAge, expires, domain, path2, secure, httpOnly, extensions);
    }

    public static /* synthetic */ void append$default(ResponseCookies responseCookies, String string, String string2, CookieEncoding cookieEncoding, int n, GMTDate gMTDate, String string3, String string4, boolean bl, boolean bl2, Map map2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            cookieEncoding = CookieEncoding.URI_ENCODING;
        }
        if ((n2 & 0x10) != 0) {
            gMTDate = null;
        }
        if ((n2 & 0x20) != 0) {
            string3 = null;
        }
        if ((n2 & 0x40) != 0) {
            string4 = null;
        }
        if ((n2 & 0x80) != 0) {
            bl = false;
        }
        if ((n2 & 0x100) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x200) != 0) {
            map2 = MapsKt.emptyMap();
        }
        responseCookies.append(string, string2, cookieEncoding, n, gMTDate, string3, string4, bl, bl2, map2);
    }

    public final void append(@NotNull String name, @NotNull String value2, @NotNull CookieEncoding encoding, long maxAge, @Nullable GMTDate expires, @Nullable String domain, @Nullable String path2, boolean secure, boolean httpOnly, @NotNull Map<String, String> extensions) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        this.append(new Cookie(name, value2, encoding, (int)RangesKt.coerceAtMost(maxAge, Integer.MAX_VALUE), expires, domain, path2, secure, httpOnly, extensions));
    }

    public static /* synthetic */ void append$default(ResponseCookies responseCookies, String string, String string2, CookieEncoding cookieEncoding, long l, GMTDate gMTDate, String string3, String string4, boolean bl, boolean bl2, Map map2, int n, Object object) {
        if ((n & 4) != 0) {
            cookieEncoding = CookieEncoding.URI_ENCODING;
        }
        if ((n & 8) != 0) {
            l = 0L;
        }
        if ((n & 0x10) != 0) {
            gMTDate = null;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        if ((n & 0x40) != 0) {
            string4 = null;
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        if ((n & 0x100) != 0) {
            bl2 = false;
        }
        if ((n & 0x200) != 0) {
            map2 = MapsKt.emptyMap();
        }
        responseCookies.append(string, string2, cookieEncoding, l, gMTDate, string3, string4, bl, bl2, map2);
    }

    @Deprecated(message="This method doesn't bypass all flags and extensions so it will be removed in future major release. Please consider using append with expires parameter instead.", replaceWith=@ReplaceWith(expression="append(name, \"\", CookieEncoding.URI_ENCODING, 0, GMTDate(), domain, path, secure, httpOnly, extensions)", imports={}))
    public final void appendExpired(@NotNull String name, @Nullable String domain, @Nullable String path2) {
        Intrinsics.checkNotNullParameter(name, "name");
        GMTDate gMTDate = GMTDate.Companion.getSTART();
        ResponseCookies.append$default(this, name, "", null, 0L, gMTDate, domain, path2, false, false, null, 908, null);
    }

    public static /* synthetic */ void appendExpired$default(ResponseCookies responseCookies, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        responseCookies.appendExpired(string, string2, string3);
    }
}

