/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.CodecsKt;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.ParametersKt;
import io.ktor.http.URLDecodeException;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.plugins.BadRequestException;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import io.ktor.server.routing.IgnoreTrailingSlashKt;
import io.ktor.server.routing.Route;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveResult;
import io.ktor.server.routing.RoutingResolveTrace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010!\u001a\u00020\"H\u0002J8\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00112\u0016\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u00192\u0006\u0010(\u001a\u00020$H\u0002J\u0016\u0010)\u001a\u00020\u00132\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00180\u0007H\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u0006\u0010,\u001a\u00020\u001dH\u0002J\u0006\u0010-\u001a\u00020\"J(\u0010.\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u000f2\u0016\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u0019H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lio/ktor/server/routing/RoutingResolveContext;", "", "routing", "Lio/ktor/server/routing/Route;", "call", "Lio/ktor/server/application/ApplicationCall;", "tracers", "", "Lkotlin/Function1;", "Lio/ktor/server/routing/RoutingResolveTrace;", "", "(Lio/ktor/server/routing/Route;Lio/ktor/server/application/ApplicationCall;Ljava/util/List;)V", "getCall", "()Lio/ktor/server/application/ApplicationCall;", "failedEvaluation", "Lio/ktor/server/routing/RouteSelectorEvaluation$Failure;", "failedEvaluationDepth", "", "hasTrailingSlash", "", "getHasTrailingSlash", "()Z", "resolveResult", "Ljava/util/ArrayList;", "Lio/ktor/server/routing/RoutingResolveResult$Success;", "Lkotlin/collections/ArrayList;", "getRouting", "()Lio/ktor/server/routing/Route;", "segments", "", "getSegments", "()Ljava/util/List;", "trace", "findBestRoute", "Lio/ktor/server/routing/RoutingResolveResult;", "handleRoute", "", "entry", "segmentIndex", "trait", "matchedQuality", "isBetterResolve", "new", "parse", "path", "resolve", "updateFailedEvaluation", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nRoutingResolveContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoutingResolveContext.kt\nio/ktor/server/routing/RoutingResolveContext\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n1099#2,3:246\n1#3:249\n1855#4,2:250\n1774#4,4:252\n1774#4,4:256\n1726#4,3:260\n*S KotlinDebug\n*F\n+ 1 RoutingResolveContext.kt\nio/ktor/server/routing/RoutingResolveContext\n*L\n57#1:246,3\n88#1:250,2\n224#1:252,4\n225#1:256,4\n235#1:260,3\n*E\n"})
public final class RoutingResolveContext {
    @NotNull
    private final Route routing;
    @NotNull
    private final ApplicationCall call;
    @NotNull
    private final List<Function1<RoutingResolveTrace, Unit>> tracers;
    @NotNull
    private final List<String> segments;
    private final boolean hasTrailingSlash;
    @Nullable
    private final RoutingResolveTrace trace;
    @NotNull
    private final ArrayList<RoutingResolveResult.Success> resolveResult;
    @Nullable
    private RouteSelectorEvaluation.Failure failedEvaluation;
    private int failedEvaluationDepth;

    public RoutingResolveContext(@NotNull Route routing, @NotNull ApplicationCall call, @NotNull List<? extends Function1<? super RoutingResolveTrace, Unit>> tracers) {
        Intrinsics.checkNotNullParameter(routing, "routing");
        Intrinsics.checkNotNullParameter(call, "call");
        Intrinsics.checkNotNullParameter(tracers, "tracers");
        this.routing = routing;
        this.call = call;
        this.tracers = tracers;
        this.hasTrailingSlash = StringsKt.endsWith$default((CharSequence)ApplicationRequestPropertiesKt.path(this.call.getRequest()), '/', false, 2, null);
        this.resolveResult = new ArrayList(16);
        this.failedEvaluation = RouteSelectorEvaluation.Companion.getFailedPath();
        try {
            this.segments = this.parse(ApplicationRequestPropertiesKt.path(this.call.getRequest()));
            this.trace = this.tracers.isEmpty() ? null : new RoutingResolveTrace(this.call, this.segments);
        }
        catch (URLDecodeException cause) {
            throw new BadRequestException("Url decode failed for " + ApplicationRequestPropertiesKt.getUri(this.call.getRequest()), cause);
        }
    }

    @NotNull
    public final Route getRouting() {
        return this.routing;
    }

    @NotNull
    public final ApplicationCall getCall() {
        return this.call;
    }

    @NotNull
    public final List<String> getSegments() {
        return this.segments;
    }

    public final boolean getHasTrailingSlash() {
        return this.hasTrailingSlash;
    }

    private final List<String> parse(String path2) {
        if (((CharSequence)path2).length() == 0 || Intrinsics.areEqual(path2, "/")) {
            return CollectionsKt.emptyList();
        }
        int length = path2.length();
        int beginSegment = 0;
        int nextSegment = 0;
        CharSequence $this$count$iv = path2;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i2 = 0; i2 < $this$count$iv.length(); ++i2) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i2);
            boolean bl = false;
            if (!(it == '/')) continue;
            ++count$iv;
        }
        int segmentCount = count$iv;
        ArrayList<String> segments2 = new ArrayList<String>(segmentCount);
        while (nextSegment < length) {
            nextSegment = StringsKt.indexOf$default((CharSequence)path2, '/', beginSegment, false, 4, null);
            if (nextSegment == -1) {
                nextSegment = length;
            }
            if (nextSegment == beginSegment) {
                beginSegment = nextSegment + 1;
                continue;
            }
            String segment = CodecsKt.decodeURLPart$default(path2, beginSegment, nextSegment, null, 4, null);
            segments2.add(segment);
            beginSegment = nextSegment + 1;
        }
        if (!IgnoreTrailingSlashKt.getIgnoreTrailingSlash(this.call) && StringsKt.endsWith$default(path2, "/", false, 2, null)) {
            segments2.add("");
        }
        return segments2;
    }

    @NotNull
    public final RoutingResolveResult resolve() {
        RoutingResolveResult resolveResult;
        block2: {
            RoutingResolveTrace routingResolveTrace;
            this.handleRoute(this.routing, 0, new ArrayList<RoutingResolveResult.Success>(), -1.7976931348623157E308);
            resolveResult = this.findBestRoute();
            RoutingResolveTrace routingResolveTrace2 = this.trace;
            if (routingResolveTrace2 != null) {
                routingResolveTrace2.registerFinalResult(resolveResult);
            }
            RoutingResolveTrace routingResolveTrace3 = this.trace;
            if (routingResolveTrace3 == null) break block2;
            RoutingResolveTrace $this$resolve_u24lambda_u242 = routingResolveTrace = routingResolveTrace3;
            boolean bl = false;
            Iterable $this$forEach$iv = this.tracers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl2 = false;
                it.invoke($this$resolve_u24lambda_u242);
            }
        }
        return resolveResult;
    }

    private final double handleRoute(Route entry, int segmentIndex, ArrayList<RoutingResolveResult.Success> trait, double matchedQuality) {
        double bestSucceedChildQuality;
        RouteSelectorEvaluation evaluation;
        block15: {
            int n;
            int childIndex;
            evaluation = entry.getSelector().evaluate(this, segmentIndex);
            if (evaluation instanceof RouteSelectorEvaluation.Failure) {
                RoutingResolveTrace routingResolveTrace = this.trace;
                if (routingResolveTrace != null) {
                    routingResolveTrace.skip(entry, segmentIndex, new RoutingResolveResult.Failure(entry, "Selector didn't match", ((RouteSelectorEvaluation.Failure)evaluation).getFailureStatusCode()));
                }
                if (segmentIndex == this.segments.size()) {
                    this.updateFailedEvaluation((RouteSelectorEvaluation.Failure)evaluation, trait);
                }
                return -1.7976931348623157E308;
            }
            if (!(evaluation instanceof RouteSelectorEvaluation.Success)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (!(((RouteSelectorEvaluation.Success)evaluation).getQuality() == -1.0) && ((RouteSelectorEvaluation.Success)evaluation).getQuality() < matchedQuality) {
                RoutingResolveTrace routingResolveTrace = this.trace;
                if (routingResolveTrace != null) {
                    routingResolveTrace.skip(entry, segmentIndex, new RoutingResolveResult.Failure(entry, "Better match was already found", HttpStatusCode.Companion.getNotFound()));
                }
                return -1.7976931348623157E308;
            }
            RoutingResolveResult.Success result2 = new RoutingResolveResult.Success(entry, ((RouteSelectorEvaluation.Success)evaluation).getParameters(), ((RouteSelectorEvaluation.Success)evaluation).getQuality());
            int newIndex = segmentIndex + ((RouteSelectorEvaluation.Success)evaluation).getSegmentIncrement();
            if (entry.getChildren().isEmpty() && newIndex != this.segments.size()) {
                RoutingResolveTrace routingResolveTrace = this.trace;
                if (routingResolveTrace != null) {
                    routingResolveTrace.skip(entry, newIndex, new RoutingResolveResult.Failure(entry, "Not all segments matched", HttpStatusCode.Companion.getNotFound()));
                }
                return -1.7976931348623157E308;
            }
            RoutingResolveTrace routingResolveTrace = this.trace;
            if (routingResolveTrace != null) {
                routingResolveTrace.begin(entry, newIndex);
            }
            trait.add(result2);
            boolean hasHandlers = !((Collection)entry.getHandlers$ktor_server_core()).isEmpty();
            bestSucceedChildQuality = -1.7976931348623157E308;
            if (hasHandlers && newIndex == this.segments.size()) {
                if (this.resolveResult.isEmpty() || this.isBetterResolve((List<RoutingResolveResult.Success>)trait)) {
                    bestSucceedChildQuality = ((RouteSelectorEvaluation.Success)evaluation).getQuality();
                    this.resolveResult.clear();
                    this.resolveResult.addAll((Collection<RoutingResolveResult.Success>)trait);
                    this.failedEvaluation = null;
                }
                RoutingResolveTrace routingResolveTrace2 = this.trace;
                if (routingResolveTrace2 != null) {
                    routingResolveTrace2.addCandidate((List<RoutingResolveResult.Success>)trait);
                }
            }
            if ((childIndex = 0) <= (n = CollectionsKt.getLastIndex(entry.getChildren()))) {
                while (true) {
                    Route child;
                    double childQuality;
                    if ((childQuality = this.handleRoute(child = entry.getChildren().get(childIndex), newIndex, trait, bestSucceedChildQuality)) > 0.0) {
                        bestSucceedChildQuality = Math.max(bestSucceedChildQuality, childQuality);
                    }
                    if (childIndex == n) break;
                    ++childIndex;
                }
            }
            CollectionsKt.removeLast((List)trait);
            RoutingResolveTrace routingResolveTrace3 = this.trace;
            if (routingResolveTrace3 == null) break block15;
            routingResolveTrace3.finish(entry, newIndex, result2);
        }
        return bestSucceedChildQuality > 0.0 ? ((RouteSelectorEvaluation.Success)evaluation).getQuality() : -1.7976931348623157E308;
    }

    private final RoutingResolveResult findBestRoute() {
        ArrayList<RoutingResolveResult.Success> finalResolve = this.resolveResult;
        if (finalResolve.isEmpty()) {
            Object object = this.failedEvaluation;
            if (object == null || (object = ((RouteSelectorEvaluation.Failure)object).getFailureStatusCode()) == null) {
                object = HttpStatusCode.Companion.getNotFound();
            }
            return new RoutingResolveResult.Failure(this.routing, "No matched subtrees found", (HttpStatusCode)object);
        }
        ParametersBuilder parameters2 = ParametersKt.ParametersBuilder$default(0, 1, null);
        double quality = Double.MAX_VALUE;
        int index = 0;
        int n = CollectionsKt.getLastIndex((List)finalResolve);
        if (index <= n) {
            while (true) {
                RoutingResolveResult.Success part2;
                Intrinsics.checkNotNullExpressionValue(finalResolve.get(index), "finalResolve[index]");
                parameters2.appendAll(part2.getParameters());
                double partQuality = part2.getQuality$ktor_server_core() == -1.0 ? 1.0 : part2.getQuality$ktor_server_core();
                quality = Math.min(quality, partQuality);
                if (index == n) break;
                ++index;
            }
        }
        return new RoutingResolveResult.Success(((RoutingResolveResult.Success)CollectionsKt.last((List)finalResolve)).getRoute(), parameters2.build(), quality);
    }

    private final boolean isBetterResolve(List<RoutingResolveResult.Success> list) {
        int n;
        int n2;
        int index1 = 0;
        int index2 = 0;
        ArrayList<RoutingResolveResult.Success> currentResolve = this.resolveResult;
        while (index1 < currentResolve.size() && index2 < list.size()) {
            double quality1 = currentResolve.get(index1).getQuality$ktor_server_core();
            double quality2 = list.get(index2).getQuality$ktor_server_core();
            if (quality1 == -1.0) {
                ++index1;
                continue;
            }
            if (quality2 == -1.0) {
                ++index2;
                continue;
            }
            if (!(quality1 == quality2)) {
                return quality2 > quality1;
            }
            ++index1;
            ++index2;
        }
        Iterable $this$count$iv = currentResolve;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                RoutingResolveResult.Success it = (RoutingResolveResult.Success)element$iv;
                boolean bl = false;
                if (!(!(it.getQuality$ktor_server_core() == -1.0)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int firstQuality = n2;
        Iterable $this$count$iv2 = list;
        boolean $i$f$count2 = false;
        if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv2) {
                RoutingResolveResult.Success it = (RoutingResolveResult.Success)element$iv;
                boolean bl = false;
                if (!(!(it.getQuality$ktor_server_core() == -1.0)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int secondQuality = n;
        return secondQuality > firstQuality;
    }

    private final void updateFailedEvaluation(RouteSelectorEvaluation.Failure failure, ArrayList<RoutingResolveResult.Success> trait) {
        RouteSelectorEvaluation.Failure failure2 = this.failedEvaluation;
        if (failure2 == null) {
            return;
        }
        RouteSelectorEvaluation.Failure current = failure2;
        if (current.getQuality() < failure.getQuality() || this.failedEvaluationDepth < trait.size()) {
            boolean bl;
            block6: {
                Iterable $this$all$iv = trait;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        RoutingResolveResult.Success it = (RoutingResolveResult.Success)element$iv;
                        boolean bl2 = false;
                        if (it.getQuality$ktor_server_core() == -1.0 || it.getQuality$ktor_server_core() == 1.0) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                this.failedEvaluation = failure;
                this.failedEvaluationDepth = trait.size();
            }
        }
    }
}

