/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.AbstractKQueueDatagramChannel;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueDomainDatagramChannelConfig;
import io.netty.channel.kqueue.KQueueEventLoop;
import io.netty.channel.kqueue.KQueueRecvByteAllocatorHandle;
import io.netty.channel.unix.DomainDatagramChannel;
import io.netty.channel.unix.DomainDatagramPacket;
import io.netty.channel.unix.DomainDatagramSocketAddress;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.UncheckedBooleanSupplier;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public final class KQueueDomainDatagramChannel
extends AbstractKQueueDatagramChannel
implements DomainDatagramChannel {
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DomainDatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + '<' + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(DomainSocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private volatile boolean connected;
    private volatile DomainSocketAddress local;
    private volatile DomainSocketAddress remote;
    private final KQueueDomainDatagramChannelConfig config = new KQueueDomainDatagramChannelConfig(this);

    public KQueueDomainDatagramChannel() {
        this(BsdSocket.newSocketDomainDgram(), false);
    }

    public KQueueDomainDatagramChannel(int fd) {
        this(new BsdSocket(fd), true);
    }

    private KQueueDomainDatagramChannel(BsdSocket socket, boolean active) {
        super(null, socket, active);
    }

    @Override
    public KQueueDomainDatagramChannelConfig config() {
        return this.config;
    }

    @Override
    protected void doBind(SocketAddress localAddress2) throws Exception {
        super.doBind(localAddress2);
        this.local = (DomainSocketAddress)localAddress2;
        this.active = true;
    }

    @Override
    protected void doClose() throws Exception {
        super.doClose();
        this.active = false;
        this.connected = false;
        this.local = null;
        this.remote = null;
    }

    @Override
    protected boolean doConnect(SocketAddress remoteAddress2, SocketAddress localAddress2) throws Exception {
        if (super.doConnect(remoteAddress2, localAddress2)) {
            if (localAddress2 != null) {
                this.local = (DomainSocketAddress)localAddress2;
            }
            this.remote = (DomainSocketAddress)remoteAddress2;
            this.connected = true;
            return true;
        }
        return false;
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    @Override
    protected boolean doWriteMessage(Object msg) throws Exception {
        long writtenBytes;
        DomainSocketAddress remoteAddress2;
        ByteBuf data2;
        if (msg instanceof AddressedEnvelope) {
            AddressedEnvelope envelope = (AddressedEnvelope)msg;
            data2 = (ByteBuf)envelope.content();
            remoteAddress2 = (DomainSocketAddress)envelope.recipient();
        } else {
            data2 = (ByteBuf)msg;
            remoteAddress2 = null;
        }
        int dataLen = data2.readableBytes();
        if (dataLen == 0) {
            return true;
        }
        if (data2.hasMemoryAddress()) {
            long memoryAddress = data2.memoryAddress();
            writtenBytes = remoteAddress2 == null ? (long)this.socket.writeAddress(memoryAddress, data2.readerIndex(), data2.writerIndex()) : (long)this.socket.sendToAddressDomainSocket(memoryAddress, data2.readerIndex(), data2.writerIndex(), remoteAddress2.path().getBytes(CharsetUtil.UTF_8));
        } else if (data2.nioBufferCount() > 1) {
            IovArray array = ((KQueueEventLoop)this.eventLoop()).cleanArray();
            array.add(data2, data2.readerIndex(), data2.readableBytes());
            int cnt = array.count();
            assert (cnt != 0);
            writtenBytes = remoteAddress2 == null ? this.socket.writevAddresses(array.memoryAddress(0), cnt) : (long)this.socket.sendToAddressesDomainSocket(array.memoryAddress(0), cnt, remoteAddress2.path().getBytes(CharsetUtil.UTF_8));
        } else {
            ByteBuffer nioData = data2.internalNioBuffer(data2.readerIndex(), data2.readableBytes());
            writtenBytes = remoteAddress2 == null ? (long)this.socket.write(nioData, nioData.position(), nioData.limit()) : (long)this.socket.sendToDomainSocket(nioData, nioData.position(), nioData.limit(), remoteAddress2.path().getBytes(CharsetUtil.UTF_8));
        }
        return writtenBytes > 0L;
    }

    @Override
    protected Object filterOutboundMessage(Object msg) {
        AddressedEnvelope<ByteBuf, DomainSocketAddress> e2;
        if (msg instanceof DomainDatagramPacket) {
            DomainDatagramPacket packet = (DomainDatagramPacket)msg;
            ByteBuf content2 = (ByteBuf)packet.content();
            return UnixChannelUtil.isBufferCopyNeededForWrite(content2) ? new DomainDatagramPacket(this.newDirectBuffer(packet, content2), (DomainSocketAddress)packet.recipient()) : msg;
        }
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            return UnixChannelUtil.isBufferCopyNeededForWrite(buf) ? this.newDirectBuffer(buf) : buf;
        }
        if (msg instanceof AddressedEnvelope && (e2 = (AddressedEnvelope<ByteBuf, DomainSocketAddress>)msg).content() instanceof ByteBuf && (e2.recipient() == null || e2.recipient() instanceof DomainSocketAddress)) {
            ByteBuf content3 = (ByteBuf)e2.content();
            return UnixChannelUtil.isBufferCopyNeededForWrite(content3) ? new DefaultAddressedEnvelope<ByteBuf, DomainSocketAddress>(this.newDirectBuffer(e2, content3), (DomainSocketAddress)e2.recipient()) : e2;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(msg) + EXPECTED_TYPES);
    }

    @Override
    public boolean isActive() {
        return this.socket.isOpen() && (this.config.getActiveOnOpen() && this.isRegistered() || this.active);
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public DomainSocketAddress localAddress() {
        return (DomainSocketAddress)super.localAddress();
    }

    @Override
    protected DomainSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected AbstractKQueueChannel.AbstractKQueueUnsafe newUnsafe() {
        return new KQueueDomainDatagramChannelUnsafe();
    }

    public PeerCredentials peerCredentials() throws IOException {
        return this.socket.getPeerCredentials();
    }

    @Override
    public DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    @Override
    protected DomainSocketAddress remoteAddress0() {
        return this.remote;
    }

    final class KQueueDomainDatagramChannelUnsafe
    extends AbstractKQueueChannel.AbstractKQueueUnsafe {
        KQueueDomainDatagramChannelUnsafe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void readReady(KQueueRecvByteAllocatorHandle allocHandle) {
            assert (KQueueDomainDatagramChannel.this.eventLoop().inEventLoop());
            KQueueDomainDatagramChannelConfig config2 = KQueueDomainDatagramChannel.this.config();
            if (KQueueDomainDatagramChannel.this.shouldBreakReadReady(config2)) {
                this.clearReadFilter0();
                return;
            }
            ChannelPipeline pipeline = KQueueDomainDatagramChannel.this.pipeline();
            ByteBufAllocator allocator = config2.getAllocator();
            allocHandle.reset(config2);
            this.readReadyBefore();
            Throwable exception = null;
            try {
                ReferenceCounted byteBuf = null;
                try {
                    boolean connected = KQueueDomainDatagramChannel.this.isConnected();
                    do {
                        DomainDatagramPacket packet;
                        byteBuf = allocHandle.allocate(allocator);
                        allocHandle.attemptedBytesRead(((ByteBuf)byteBuf).writableBytes());
                        if (connected) {
                            allocHandle.lastBytesRead(KQueueDomainDatagramChannel.this.doReadBytes((ByteBuf)byteBuf));
                            if (allocHandle.lastBytesRead() <= 0) {
                                byteBuf.release();
                                break;
                            }
                            packet = new DomainDatagramPacket((ByteBuf)byteBuf, (DomainSocketAddress)this.localAddress(), (DomainSocketAddress)this.remoteAddress());
                        } else {
                            DomainDatagramSocketAddress remoteAddress2;
                            if (((ByteBuf)byteBuf).hasMemoryAddress()) {
                                remoteAddress2 = KQueueDomainDatagramChannel.this.socket.recvFromAddressDomainSocket(((ByteBuf)byteBuf).memoryAddress(), ((ByteBuf)byteBuf).writerIndex(), ((ByteBuf)byteBuf).capacity());
                            } else {
                                ByteBuffer nioData = ((ByteBuf)byteBuf).internalNioBuffer(((ByteBuf)byteBuf).writerIndex(), ((ByteBuf)byteBuf).writableBytes());
                                remoteAddress2 = KQueueDomainDatagramChannel.this.socket.recvFromDomainSocket(nioData, nioData.position(), nioData.limit());
                            }
                            if (remoteAddress2 == null) {
                                allocHandle.lastBytesRead(-1);
                                byteBuf.release();
                                break;
                            }
                            DomainSocketAddress localAddress2 = remoteAddress2.localAddress();
                            if (localAddress2 == null) {
                                localAddress2 = (DomainSocketAddress)this.localAddress();
                            }
                            allocHandle.lastBytesRead(remoteAddress2.receivedAmount());
                            ((ByteBuf)byteBuf).writerIndex(((ByteBuf)byteBuf).writerIndex() + allocHandle.lastBytesRead());
                            packet = new DomainDatagramPacket((ByteBuf)byteBuf, localAddress2, remoteAddress2);
                        }
                        allocHandle.incMessagesRead(1);
                        this.readPending = false;
                        pipeline.fireChannelRead(packet);
                        byteBuf = null;
                    } while (allocHandle.continueReading(UncheckedBooleanSupplier.TRUE_SUPPLIER));
                }
                catch (Throwable t2) {
                    if (byteBuf != null) {
                        byteBuf.release();
                    }
                    exception = t2;
                }
                allocHandle.readComplete();
                pipeline.fireChannelReadComplete();
                if (exception != null) {
                    pipeline.fireExceptionCaught(exception);
                }
            }
            finally {
                this.readReadyFinally(config2);
            }
        }
    }
}

