/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoop;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.Deque;
import java.util.concurrent.Callable;

public class SimpleChannelPool
implements ChannelPool {
    private static final AttributeKey<SimpleChannelPool> POOL_KEY = AttributeKey.newInstance("io.netty.channel.pool.SimpleChannelPool");
    private final Deque<Channel> deque = PlatformDependent.newConcurrentDeque();
    private final ChannelPoolHandler handler;
    private final ChannelHealthChecker healthCheck;
    private final Bootstrap bootstrap;
    private final boolean releaseHealthCheck;
    private final boolean lastRecentUsed;

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler2) {
        this(bootstrap, handler2, ChannelHealthChecker.ACTIVE);
    }

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler2, ChannelHealthChecker healthCheck) {
        this(bootstrap, handler2, healthCheck, true);
    }

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler2, ChannelHealthChecker healthCheck, boolean releaseHealthCheck) {
        this(bootstrap, handler2, healthCheck, releaseHealthCheck, true);
    }

    public SimpleChannelPool(Bootstrap bootstrap, final ChannelPoolHandler handler2, ChannelHealthChecker healthCheck, boolean releaseHealthCheck, boolean lastRecentUsed) {
        this.handler = ObjectUtil.checkNotNull(handler2, "handler");
        this.healthCheck = ObjectUtil.checkNotNull(healthCheck, "healthCheck");
        this.releaseHealthCheck = releaseHealthCheck;
        this.bootstrap = ObjectUtil.checkNotNull(bootstrap, "bootstrap").clone();
        this.bootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                assert (ch.eventLoop().inEventLoop());
                handler2.channelCreated(ch);
            }
        });
        this.lastRecentUsed = lastRecentUsed;
    }

    protected Bootstrap bootstrap() {
        return this.bootstrap;
    }

    protected ChannelPoolHandler handler() {
        return this.handler;
    }

    protected ChannelHealthChecker healthChecker() {
        return this.healthCheck;
    }

    protected boolean releaseHealthCheck() {
        return this.releaseHealthCheck;
    }

    @Override
    public final Future<Channel> acquire() {
        return this.acquire(this.bootstrap.config().group().next().newPromise());
    }

    @Override
    public Future<Channel> acquire(Promise<Channel> promise) {
        return this.acquireHealthyFromPoolOrNew(ObjectUtil.checkNotNull(promise, "promise"));
    }

    private Future<Channel> acquireHealthyFromPoolOrNew(final Promise<Channel> promise) {
        try {
            final Channel ch = this.pollChannel();
            if (ch == null) {
                Bootstrap bs = this.bootstrap.clone();
                bs.attr(POOL_KEY, this);
                ChannelFuture f2 = this.connectChannel(bs);
                if (f2.isDone()) {
                    this.notifyConnect(f2, promise);
                } else {
                    f2.addListener((GenericFutureListener)new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture future) throws Exception {
                            SimpleChannelPool.this.notifyConnect(future, promise);
                        }
                    });
                }
            } else {
                EventLoop loop2 = ch.eventLoop();
                if (loop2.inEventLoop()) {
                    this.doHealthCheck(ch, promise);
                } else {
                    loop2.execute(new Runnable(){

                        @Override
                        public void run() {
                            SimpleChannelPool.this.doHealthCheck(ch, promise);
                        }
                    });
                }
            }
        }
        catch (Throwable cause) {
            promise.tryFailure(cause);
        }
        return promise;
    }

    private void notifyConnect(ChannelFuture future, Promise<Channel> promise) {
        Channel channel2 = null;
        try {
            if (future.isSuccess()) {
                channel2 = future.channel();
                this.handler.channelAcquired(channel2);
                if (!promise.trySuccess(channel2)) {
                    this.release(channel2);
                }
            } else {
                promise.tryFailure(future.cause());
            }
        }
        catch (Throwable cause) {
            this.closeAndFail(channel2, cause, promise);
        }
    }

    private void doHealthCheck(final Channel channel2, final Promise<Channel> promise) {
        try {
            assert (channel2.eventLoop().inEventLoop());
            Future<Boolean> f2 = this.healthCheck.isHealthy(channel2);
            if (f2.isDone()) {
                this.notifyHealthCheck(f2, channel2, promise);
            } else {
                f2.addListener((GenericFutureListener<Future<Boolean>>)new FutureListener<Boolean>(){

                    @Override
                    public void operationComplete(Future<Boolean> future) {
                        SimpleChannelPool.this.notifyHealthCheck(future, channel2, promise);
                    }
                });
            }
        }
        catch (Throwable cause) {
            this.closeAndFail(channel2, cause, promise);
        }
    }

    private void notifyHealthCheck(Future<Boolean> future, Channel channel2, Promise<Channel> promise) {
        try {
            assert (channel2.eventLoop().inEventLoop());
            if (future.isSuccess() && future.getNow().booleanValue()) {
                channel2.attr(POOL_KEY).set(this);
                this.handler.channelAcquired(channel2);
                promise.setSuccess(channel2);
            } else {
                this.closeChannel(channel2);
                this.acquireHealthyFromPoolOrNew(promise);
            }
        }
        catch (Throwable cause) {
            this.closeAndFail(channel2, cause, promise);
        }
    }

    protected ChannelFuture connectChannel(Bootstrap bs) {
        return bs.connect();
    }

    @Override
    public final Future<Void> release(Channel channel2) {
        return this.release(channel2, channel2.eventLoop().newPromise());
    }

    @Override
    public Future<Void> release(final Channel channel2, final Promise<Void> promise) {
        try {
            ObjectUtil.checkNotNull(channel2, "channel");
            ObjectUtil.checkNotNull(promise, "promise");
            EventLoop loop2 = channel2.eventLoop();
            if (loop2.inEventLoop()) {
                this.doReleaseChannel(channel2, promise);
            } else {
                loop2.execute(new Runnable(){

                    @Override
                    public void run() {
                        SimpleChannelPool.this.doReleaseChannel(channel2, promise);
                    }
                });
            }
        }
        catch (Throwable cause) {
            this.closeAndFail(channel2, cause, promise);
        }
        return promise;
    }

    private void doReleaseChannel(Channel channel2, Promise<Void> promise) {
        try {
            assert (channel2.eventLoop().inEventLoop());
            if (channel2.attr(POOL_KEY).getAndSet(null) != this) {
                this.closeAndFail(channel2, new IllegalArgumentException("Channel " + channel2 + " was not acquired from this ChannelPool"), promise);
            } else if (this.releaseHealthCheck) {
                this.doHealthCheckOnRelease(channel2, promise);
            } else {
                this.releaseAndOffer(channel2, promise);
            }
        }
        catch (Throwable cause) {
            this.closeAndFail(channel2, cause, promise);
        }
    }

    private void doHealthCheckOnRelease(final Channel channel2, final Promise<Void> promise) throws Exception {
        final Future<Boolean> f2 = this.healthCheck.isHealthy(channel2);
        if (f2.isDone()) {
            this.releaseAndOfferIfHealthy(channel2, promise, f2);
        } else {
            f2.addListener((GenericFutureListener<Future<Boolean>>)new FutureListener<Boolean>(){

                @Override
                public void operationComplete(Future<Boolean> future) throws Exception {
                    SimpleChannelPool.this.releaseAndOfferIfHealthy(channel2, promise, f2);
                }
            });
        }
    }

    private void releaseAndOfferIfHealthy(Channel channel2, Promise<Void> promise, Future<Boolean> future) {
        try {
            if (future.getNow().booleanValue()) {
                this.releaseAndOffer(channel2, promise);
            } else {
                this.handler.channelReleased(channel2);
                promise.setSuccess(null);
            }
        }
        catch (Throwable cause) {
            this.closeAndFail(channel2, cause, promise);
        }
    }

    private void releaseAndOffer(Channel channel2, Promise<Void> promise) throws Exception {
        if (this.offerChannel(channel2)) {
            this.handler.channelReleased(channel2);
            promise.setSuccess(null);
        } else {
            this.closeAndFail(channel2, new ChannelPoolFullException(), promise);
        }
    }

    private void closeChannel(Channel channel2) throws Exception {
        channel2.attr(POOL_KEY).getAndSet(null);
        channel2.close();
    }

    private void closeAndFail(Channel channel2, Throwable cause, Promise<?> promise) {
        if (channel2 != null) {
            try {
                this.closeChannel(channel2);
            }
            catch (Throwable t2) {
                promise.tryFailure(t2);
            }
        }
        promise.tryFailure(cause);
    }

    protected Channel pollChannel() {
        return this.lastRecentUsed ? this.deque.pollLast() : this.deque.pollFirst();
    }

    protected boolean offerChannel(Channel channel2) {
        return this.deque.offer(channel2);
    }

    @Override
    public void close() {
        Channel channel2;
        while ((channel2 = this.pollChannel()) != null) {
            channel2.close().awaitUninterruptibly();
        }
    }

    public Future<Void> closeAsync() {
        return GlobalEventExecutor.INSTANCE.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SimpleChannelPool.this.close();
                return null;
            }
        });
    }

    private static final class ChannelPoolFullException
    extends IllegalStateException {
        private ChannelPoolFullException() {
            super("ChannelPool full");
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

