/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.socket.SocketProtocolFamily;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ProtocolFamily;
import java.net.StandardProtocolFamily;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;

final class SelectorProviderUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SelectorProviderUtil.class);

    static Method findOpenMethod(String methodName) {
        if (PlatformDependent.javaVersion() >= 15) {
            try {
                return SelectorProvider.class.getMethod(methodName, ProtocolFamily.class);
            }
            catch (Throwable e2) {
                logger.debug("SelectorProvider.{}(ProtocolFamily) not available, will use default", (Object)methodName, (Object)e2);
            }
        }
        return null;
    }

    private static <C extends Channel> C newChannel(Method method2, SelectorProvider provider2, Object family) throws IOException {
        if (family != null && method2 != null) {
            try {
                Channel channel2 = (Channel)method2.invoke((Object)provider2, family);
                return (C)channel2;
            }
            catch (IllegalAccessException | InvocationTargetException e2) {
                throw new IOException(e2);
            }
        }
        return null;
    }

    static <C extends Channel> C newChannel(Method method2, SelectorProvider provider2, SocketProtocolFamily family) throws IOException {
        if (family != null) {
            return SelectorProviderUtil.newChannel(method2, provider2, family.toJdkFamily());
        }
        return null;
    }

    static <C extends Channel> C newDomainSocketChannel(Method method2, SelectorProvider provider2) throws IOException {
        return SelectorProviderUtil.newChannel(method2, provider2, StandardProtocolFamily.valueOf("UNIX"));
    }

    private SelectorProviderUtil() {
    }
}

