/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.CodecOutputList;
import io.netty.handler.codec.DecoderException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.TypeParameterMatcher;
import java.util.List;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class MessageToMessageDecoder<I>
extends ChannelInboundHandlerAdapter {
    private final TypeParameterMatcher matcher;
    private boolean decodeCalled;
    private boolean messageProduced;

    protected MessageToMessageDecoder() {
        this.matcher = TypeParameterMatcher.find(this, MessageToMessageDecoder.class, "I");
    }

    protected MessageToMessageDecoder(Class<? extends I> inboundMessageType) {
        this.matcher = TypeParameterMatcher.get(inboundMessageType);
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return this.matcher.match(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        CodecOutputList out2;
        block17: {
            this.decodeCalled = true;
            out2 = CodecOutputList.newInstance();
            try {
                if (this.acceptInboundMessage(msg)) {
                    Object cast = msg;
                    try {
                        this.decode(ctx, cast, out2);
                        break block17;
                    }
                    finally {
                        ReferenceCountUtil.release(cast);
                    }
                }
                out2.add(msg);
            }
            catch (DecoderException e2) {
                try {
                    throw e2;
                    catch (Exception e3) {
                        throw new DecoderException(e3);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        int size2 = out2.size();
                        this.messageProduced |= size2 > 0;
                        for (int i2 = 0; i2 < size2; ++i2) {
                            ctx.fireChannelRead(out2.getUnsafe(i2));
                        }
                        throw throwable;
                    }
                    finally {
                        out2.recycle();
                    }
                }
            }
        }
        try {
            int size3 = out2.size();
            this.messageProduced |= size3 > 0;
            for (int i3 = 0; i3 < size3; ++i3) {
                ctx.fireChannelRead(out2.getUnsafe(i3));
            }
            return;
        }
        finally {
            out2.recycle();
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (!this.isSharable()) {
            if (this.decodeCalled && !this.messageProduced && !ctx.channel().config().isAutoRead()) {
                ctx.read();
            }
            this.decodeCalled = false;
            this.messageProduced = false;
        }
        ctx.fireChannelReadComplete();
    }

    protected abstract void decode(ChannelHandlerContext var1, I var2, List<Object> var3) throws Exception;
}

