/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.CompressionUtil;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class ByteBufChecksum
implements Checksum {
    private final ByteProcessor updateProcessor = new ByteProcessor(){

        @Override
        public boolean process(byte value2) throws Exception {
            ByteBufChecksum.this.update(value2);
            return true;
        }
    };

    ByteBufChecksum() {
    }

    static ByteBufChecksum wrapChecksum(Checksum checksum) {
        ObjectUtil.checkNotNull(checksum, "checksum");
        if (checksum instanceof ByteBufChecksum) {
            return (ByteBufChecksum)checksum;
        }
        return new JdkByteBufChecksum(checksum);
    }

    public void update(ByteBuf b2, int off, int len2) {
        if (b2.hasArray()) {
            this.update(b2.array(), b2.arrayOffset() + off, len2);
        } else {
            b2.forEachByte(off, len2, this.updateProcessor);
        }
    }

    private static class JdkByteBufChecksum
    extends ByteBufChecksum {
        protected final Checksum checksum;
        private byte[] scratchBuffer;

        JdkByteBufChecksum(Checksum checksum) {
            this.checksum = checksum;
        }

        @Override
        public void update(int b2) {
            this.checksum.update(b2);
        }

        @Override
        public void update(ByteBuf b2, int off, int len2) {
            if (b2.hasArray()) {
                this.update(b2.array(), b2.arrayOffset() + off, len2);
            } else if (this.checksum instanceof CRC32) {
                ByteBuffer byteBuffer = this.getSafeBuffer(b2, off, len2);
                ((CRC32)this.checksum).update(byteBuffer);
            } else if (this.checksum instanceof Adler32) {
                ByteBuffer byteBuffer = this.getSafeBuffer(b2, off, len2);
                ((Adler32)this.checksum).update(byteBuffer);
            } else {
                super.update(b2, off, len2);
            }
        }

        private ByteBuffer getSafeBuffer(ByteBuf b2, int off, int len2) {
            ByteBuffer byteBuffer = CompressionUtil.safeNioBuffer(b2, off, len2);
            int javaVersion = PlatformDependent.javaVersion();
            if (javaVersion >= 22 && javaVersion < 25 && byteBuffer.isDirect()) {
                if (this.scratchBuffer == null || this.scratchBuffer.length < len2) {
                    this.scratchBuffer = new byte[len2];
                }
                ByteBuffer copy2 = ByteBuffer.wrap(this.scratchBuffer, 0, len2);
                copy2.put(byteBuffer).flip();
                return copy2;
            }
            return byteBuffer;
        }

        @Override
        public void update(byte[] b2, int off, int len2) {
            this.checksum.update(b2, off, len2);
        }

        @Override
        public long getValue() {
            return this.checksum.getValue();
        }

        @Override
        public void reset() {
            this.checksum.reset();
        }
    }
}

