/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.handler.codec.compression.JZlibDecoder;
import io.netty.handler.codec.compression.JZlibEncoder;
import io.netty.handler.codec.compression.JdkZlibDecoder;
import io.netty.handler.codec.compression.JdkZlibEncoder;
import io.netty.handler.codec.compression.ZlibDecoder;
import io.netty.handler.codec.compression.ZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ZlibCodecFactory {
    private static final InternalLogger logger;
    private static final int DEFAULT_JDK_WINDOW_SIZE = 15;
    private static final int DEFAULT_JDK_MEM_LEVEL = 8;
    private static final boolean noJdkZlibDecoder;
    private static final boolean noJdkZlibEncoder;
    private static final boolean JZLIB_AVAILABLE;

    public static boolean isSupportingWindowSizeAndMemLevel() {
        return JZLIB_AVAILABLE;
    }

    public static ZlibEncoder newZlibEncoder(int compressionLevel) {
        if (noJdkZlibEncoder) {
            return new JZlibEncoder(compressionLevel);
        }
        return new JdkZlibEncoder(compressionLevel);
    }

    public static ZlibEncoder newZlibEncoder(ZlibWrapper wrapper2) {
        if (noJdkZlibEncoder) {
            return new JZlibEncoder(wrapper2);
        }
        return new JdkZlibEncoder(wrapper2);
    }

    public static ZlibEncoder newZlibEncoder(ZlibWrapper wrapper2, int compressionLevel) {
        if (noJdkZlibEncoder) {
            return new JZlibEncoder(wrapper2, compressionLevel);
        }
        return new JdkZlibEncoder(wrapper2, compressionLevel);
    }

    public static ZlibEncoder newZlibEncoder(ZlibWrapper wrapper2, int compressionLevel, int windowBits, int memLevel) {
        if (noJdkZlibEncoder || windowBits != 15 || memLevel != 8) {
            return new JZlibEncoder(wrapper2, compressionLevel, windowBits, memLevel);
        }
        return new JdkZlibEncoder(wrapper2, compressionLevel);
    }

    public static ZlibEncoder newZlibEncoder(byte[] dictionary) {
        if (noJdkZlibEncoder) {
            return new JZlibEncoder(dictionary);
        }
        return new JdkZlibEncoder(dictionary);
    }

    public static ZlibEncoder newZlibEncoder(int compressionLevel, byte[] dictionary) {
        if (noJdkZlibEncoder) {
            return new JZlibEncoder(compressionLevel, dictionary);
        }
        return new JdkZlibEncoder(compressionLevel, dictionary);
    }

    public static ZlibEncoder newZlibEncoder(int compressionLevel, int windowBits, int memLevel, byte[] dictionary) {
        if (noJdkZlibEncoder || windowBits != 15 || memLevel != 8) {
            return new JZlibEncoder(compressionLevel, windowBits, memLevel, dictionary);
        }
        return new JdkZlibEncoder(compressionLevel, dictionary);
    }

    @Deprecated
    public static ZlibDecoder newZlibDecoder() {
        return ZlibCodecFactory.newZlibDecoder(0);
    }

    public static ZlibDecoder newZlibDecoder(int maxAllocation) {
        if (noJdkZlibDecoder) {
            return new JZlibDecoder(maxAllocation);
        }
        return new JdkZlibDecoder(true, maxAllocation);
    }

    @Deprecated
    public static ZlibDecoder newZlibDecoder(ZlibWrapper wrapper2) {
        return ZlibCodecFactory.newZlibDecoder(wrapper2, 0);
    }

    public static ZlibDecoder newZlibDecoder(ZlibWrapper wrapper2, int maxAllocation) {
        if (noJdkZlibDecoder) {
            return new JZlibDecoder(wrapper2, maxAllocation);
        }
        return new JdkZlibDecoder(wrapper2, true, maxAllocation);
    }

    @Deprecated
    public static ZlibDecoder newZlibDecoder(byte[] dictionary) {
        return ZlibCodecFactory.newZlibDecoder(dictionary, 0);
    }

    public static ZlibDecoder newZlibDecoder(byte[] dictionary, int maxAllocation) {
        if (noJdkZlibDecoder) {
            return new JZlibDecoder(dictionary, maxAllocation);
        }
        return new JdkZlibDecoder(dictionary, maxAllocation);
    }

    private ZlibCodecFactory() {
    }

    static {
        boolean jzlibAvailable;
        logger = InternalLoggerFactory.getInstance(ZlibCodecFactory.class);
        noJdkZlibDecoder = SystemPropertyUtil.getBoolean("io.netty.noJdkZlibDecoder", false);
        logger.debug("-Dio.netty.noJdkZlibDecoder: {}", (Object)noJdkZlibDecoder);
        noJdkZlibEncoder = SystemPropertyUtil.getBoolean("io.netty.noJdkZlibEncoder", false);
        logger.debug("-Dio.netty.noJdkZlibEncoder: {}", (Object)noJdkZlibEncoder);
        try {
            Class.forName("com.jcraft.jzlib.JZlib", false, PlatformDependent.getClassLoader(ZlibCodecFactory.class));
            jzlibAvailable = true;
        }
        catch (ClassNotFoundException t2) {
            jzlibAvailable = false;
            logger.debug("JZlib not in the classpath; the only window bits supported value will be 15");
        }
        JZLIB_AVAILABLE = jzlibAvailable;
    }
}

