/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieUtil;
import io.netty.handler.codec.http.DefaultCookie;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@Deprecated
public final class CookieDecoder {
    private final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    private static final CookieDecoder STRICT = new CookieDecoder(true);
    private static final CookieDecoder LAX = new CookieDecoder(false);
    private static final String COMMENT = "Comment";
    private static final String COMMENTURL = "CommentURL";
    private static final String DISCARD = "Discard";
    private static final String PORT = "Port";
    private static final String VERSION = "Version";
    private final boolean strict;

    public static Set<Cookie> decode(String header) {
        return CookieDecoder.decode(header, true);
    }

    public static Set<Cookie> decode(String header, boolean strict) {
        return (strict ? STRICT : LAX).doDecode(header);
    }

    private Set<Cookie> doDecode(String header) {
        int i2;
        ArrayList<String> names2 = new ArrayList<String>(8);
        ArrayList<String> values2 = new ArrayList<String>(8);
        CookieDecoder.extractKeyValuePairs(header, names2, values2);
        if (names2.isEmpty()) {
            return Collections.emptySet();
        }
        int version2 = 0;
        if (((String)names2.get(0)).equalsIgnoreCase(VERSION)) {
            try {
                version2 = Integer.parseInt((String)values2.get(0));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            i2 = 1;
        } else {
            i2 = 0;
        }
        if (names2.size() <= i2) {
            return Collections.emptySet();
        }
        TreeSet<Cookie> cookies2 = new TreeSet<Cookie>();
        while (i2 < names2.size()) {
            DefaultCookie c2;
            String name = (String)names2.get(i2);
            String value2 = (String)values2.get(i2);
            if (value2 == null) {
                value2 = "";
            }
            if ((c2 = this.initCookie(name, value2)) == null) break;
            boolean discard = false;
            boolean secure = false;
            boolean httpOnly = false;
            String comment = null;
            String commentURL = null;
            String domain = null;
            String path2 = null;
            long maxAge = Long.MIN_VALUE;
            ArrayList<Integer> ports = new ArrayList<Integer>(2);
            int j2 = i2 + 1;
            while (j2 < names2.size()) {
                name = (String)names2.get(j2);
                value2 = (String)values2.get(j2);
                if (DISCARD.equalsIgnoreCase(name)) {
                    discard = true;
                } else if ("Secure".equalsIgnoreCase(name)) {
                    secure = true;
                } else if ("HTTPOnly".equalsIgnoreCase(name)) {
                    httpOnly = true;
                } else if (COMMENT.equalsIgnoreCase(name)) {
                    comment = value2;
                } else if (COMMENTURL.equalsIgnoreCase(name)) {
                    commentURL = value2;
                } else if ("Domain".equalsIgnoreCase(name)) {
                    domain = value2;
                } else if ("Path".equalsIgnoreCase(name)) {
                    path2 = value2;
                } else if ("Expires".equalsIgnoreCase(name)) {
                    Date date = DateFormatter.parseHttpDate(value2);
                    if (date != null) {
                        long maxAgeMillis = date.getTime() - System.currentTimeMillis();
                        maxAge = maxAgeMillis / 1000L + (long)(maxAgeMillis % 1000L != 0L ? 1 : 0);
                    }
                } else if ("Max-Age".equalsIgnoreCase(name)) {
                    maxAge = Integer.parseInt(value2);
                } else if (VERSION.equalsIgnoreCase(name)) {
                    version2 = Integer.parseInt(value2);
                } else {
                    String[] portList;
                    if (!PORT.equalsIgnoreCase(name)) break;
                    for (String s1 : portList = value2.split(",")) {
                        try {
                            ports.add(Integer.valueOf(s1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                ++j2;
                ++i2;
            }
            c2.setVersion(version2);
            c2.setMaxAge(maxAge);
            c2.setPath(path2);
            c2.setDomain(domain);
            c2.setSecure(secure);
            c2.setHttpOnly(httpOnly);
            if (version2 > 0) {
                c2.setComment(comment);
            }
            if (version2 > 1) {
                c2.setCommentUrl(commentURL);
                c2.setPorts(ports);
                c2.setDiscard(discard);
            }
            cookies2.add(c2);
            ++i2;
        }
        return cookies2;
    }

    private static void extractKeyValuePairs(String header, List<String> names2, List<String> values2) {
        int headerLen = header.length();
        int i2 = 0;
        block10: while (i2 != headerLen) {
            switch (header.charAt(i2)) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ';': {
                    ++i2;
                    continue block10;
                }
            }
            while (i2 != headerLen) {
                String value2;
                String name;
                if (header.charAt(i2) == '$') {
                    ++i2;
                    continue;
                }
                if (i2 == headerLen) {
                    name = null;
                    value2 = null;
                } else {
                    int newNameStart = i2;
                    block12: while (true) {
                        switch (header.charAt(i2)) {
                            case ';': {
                                name = header.substring(newNameStart, i2);
                                value2 = null;
                                break block12;
                            }
                            case '=': {
                                name = header.substring(newNameStart, i2);
                                if (++i2 == headerLen) {
                                    value2 = "";
                                    break block12;
                                }
                                int newValueStart = i2;
                                char c2 = header.charAt(i2);
                                if (c2 == '\"' || c2 == '\'') {
                                    StringBuilder newValueBuf = new StringBuilder(header.length() - i2);
                                    char q = c2;
                                    boolean hadBackslash = false;
                                    ++i2;
                                    block13: while (true) {
                                        if (i2 == headerLen) {
                                            value2 = newValueBuf.toString();
                                            break block12;
                                        }
                                        if (hadBackslash) {
                                            hadBackslash = false;
                                            c2 = header.charAt(i2++);
                                            switch (c2) {
                                                case '\"': 
                                                case '\'': 
                                                case '\\': {
                                                    newValueBuf.setCharAt(newValueBuf.length() - 1, c2);
                                                    continue block13;
                                                }
                                            }
                                            newValueBuf.append(c2);
                                            continue;
                                        }
                                        if ((c2 = header.charAt(i2++)) == q) {
                                            value2 = newValueBuf.toString();
                                            break block12;
                                        }
                                        newValueBuf.append(c2);
                                        if (c2 != '\\') continue;
                                        hadBackslash = true;
                                    }
                                }
                                int semiPos = header.indexOf(59, i2);
                                if (semiPos > 0) {
                                    value2 = header.substring(newValueStart, semiPos);
                                    i2 = semiPos;
                                    break block12;
                                }
                                value2 = header.substring(newValueStart);
                                i2 = headerLen;
                                break block12;
                            }
                            default: {
                                if (++i2 != headerLen) continue block12;
                                name = header.substring(newNameStart);
                                value2 = null;
                                break block12;
                            }
                        }
                        break;
                    }
                }
                names2.add(name);
                values2.add(value2);
                continue block10;
            }
            break block10;
        }
    }

    private CookieDecoder(boolean strict) {
        this.strict = strict;
    }

    private DefaultCookie initCookie(String name, String value2) {
        boolean wrap2;
        int invalidOctetPos;
        if (name == null || name.length() == 0) {
            this.logger.debug("Skipping cookie with null name");
            return null;
        }
        if (value2 == null) {
            this.logger.debug("Skipping cookie with null value");
            return null;
        }
        CharSequence unwrappedValue = CookieUtil.unwrapValue(value2);
        if (unwrappedValue == null) {
            this.logger.debug("Skipping cookie because starting quotes are not properly balanced in '{}'", (Object)unwrappedValue);
            return null;
        }
        if (this.strict && (invalidOctetPos = CookieUtil.firstInvalidCookieNameOctet(name)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipping cookie because name '{}' contains invalid char '{}'", (Object)name, (Object)Character.valueOf(name.charAt(invalidOctetPos)));
            }
            return null;
        }
        boolean bl = wrap2 = unwrappedValue.length() != value2.length();
        if (this.strict && (invalidOctetPos = CookieUtil.firstInvalidCookieValueOctet(unwrappedValue)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipping cookie because value '{}' contains invalid char '{}'", (Object)unwrappedValue, (Object)Character.valueOf(unwrappedValue.charAt(invalidOctetPos)));
            }
            return null;
        }
        DefaultCookie cookie = new DefaultCookie(name, unwrappedValue.toString());
        cookie.setWrap(wrap2);
        return cookie;
    }
}

