/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpConstants;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryStringDecoder {
    private static final int DEFAULT_MAX_PARAMS = 1024;
    private final Charset charset;
    private final String uri;
    private final int maxParams;
    private final boolean semicolonIsNormalChar;
    private final boolean htmlQueryDecoding;
    private int pathEndIdx;
    private String path;
    private Map<String, List<String>> params;

    public QueryStringDecoder(String uri2) {
        this(QueryStringDecoder.builder(), uri2);
    }

    public QueryStringDecoder(String uri2, boolean hasPath) {
        this(QueryStringDecoder.builder().hasPath(hasPath), uri2);
    }

    public QueryStringDecoder(String uri2, Charset charset) {
        this(QueryStringDecoder.builder().charset(charset), uri2);
    }

    public QueryStringDecoder(String uri2, Charset charset, boolean hasPath) {
        this(QueryStringDecoder.builder().hasPath(hasPath).charset(charset), uri2);
    }

    public QueryStringDecoder(String uri2, Charset charset, boolean hasPath, int maxParams) {
        this(QueryStringDecoder.builder().hasPath(hasPath).charset(charset).maxParams(maxParams), uri2);
    }

    public QueryStringDecoder(String uri2, Charset charset, boolean hasPath, int maxParams, boolean semicolonIsNormalChar) {
        this(QueryStringDecoder.builder().hasPath(hasPath).charset(charset).maxParams(maxParams).semicolonIsNormalChar(semicolonIsNormalChar), uri2);
    }

    public QueryStringDecoder(URI uri2) {
        this(QueryStringDecoder.builder(), uri2);
    }

    public QueryStringDecoder(URI uri2, Charset charset) {
        this(QueryStringDecoder.builder().charset(charset), uri2);
    }

    public QueryStringDecoder(URI uri2, Charset charset, int maxParams) {
        this(QueryStringDecoder.builder().charset(charset).maxParams(maxParams), uri2);
    }

    public QueryStringDecoder(URI uri2, Charset charset, int maxParams, boolean semicolonIsNormalChar) {
        this(QueryStringDecoder.builder().charset(charset).maxParams(maxParams).semicolonIsNormalChar(semicolonIsNormalChar), uri2);
    }

    private QueryStringDecoder(Builder builder, String uri2) {
        this.uri = ObjectUtil.checkNotNull(uri2, "uri");
        this.charset = ObjectUtil.checkNotNull(builder.charset, "charset");
        this.maxParams = ObjectUtil.checkPositive(builder.maxParams, "maxParams");
        this.semicolonIsNormalChar = builder.semicolonIsNormalChar;
        this.htmlQueryDecoding = builder.htmlQueryDecoding;
        this.pathEndIdx = builder.hasPath ? -1 : 0;
    }

    private QueryStringDecoder(Builder builder, URI uri2) {
        String rawQuery;
        String rawPath = uri2.getRawPath();
        if (rawPath == null) {
            rawPath = "";
        }
        this.uri = (rawQuery = uri2.getRawQuery()) == null ? rawPath : rawPath + '?' + rawQuery;
        this.charset = ObjectUtil.checkNotNull(builder.charset, "charset");
        this.maxParams = ObjectUtil.checkPositive(builder.maxParams, "maxParams");
        this.semicolonIsNormalChar = builder.semicolonIsNormalChar;
        this.htmlQueryDecoding = builder.htmlQueryDecoding;
        this.pathEndIdx = rawPath.length();
    }

    public String toString() {
        return this.uri();
    }

    public String uri() {
        return this.uri;
    }

    public String path() {
        if (this.path == null) {
            this.path = QueryStringDecoder.decodeComponent(this.uri, 0, this.pathEndIdx(), this.charset, false);
        }
        return this.path;
    }

    public Map<String, List<String>> parameters() {
        if (this.params == null) {
            this.params = this.decodeParams(this.uri, this.pathEndIdx(), this.charset, this.maxParams);
        }
        return this.params;
    }

    public String rawPath() {
        return this.uri.substring(0, this.pathEndIdx());
    }

    public String rawQuery() {
        int start2 = this.pathEndIdx() + 1;
        return start2 < this.uri.length() ? this.uri.substring(start2) : "";
    }

    private int pathEndIdx() {
        if (this.pathEndIdx == -1) {
            this.pathEndIdx = QueryStringDecoder.findPathEndIndex(this.uri);
        }
        return this.pathEndIdx;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Map<String, List<String>> decodeParams(String s2, int from2, Charset charset, int paramsLimit) {
        int i2;
        int len2 = s2.length();
        if (from2 >= len2) {
            return Collections.emptyMap();
        }
        if (s2.charAt(from2) == '?') {
            ++from2;
        }
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        int nameStart = from2;
        int valueStart = -1;
        block6: for (i2 = from2; i2 < len2; ++i2) {
            switch (s2.charAt(i2)) {
                case '=': {
                    if (nameStart == i2) {
                        nameStart = i2 + 1;
                        break;
                    }
                    if (valueStart >= nameStart) break;
                    valueStart = i2 + 1;
                    break;
                }
                case ';': {
                    if (this.semicolonIsNormalChar) break;
                }
                case '&': {
                    if (this.addParam(s2, nameStart, valueStart, i2, params, charset) && --paramsLimit == 0) {
                        return params;
                    }
                    nameStart = i2 + 1;
                    break;
                }
                case '#': {
                    break block6;
                }
            }
        }
        this.addParam(s2, nameStart, valueStart, i2, params, charset);
        return params;
    }

    private boolean addParam(String s2, int nameStart, int valueStart, int valueEnd, Map<String, List<String>> params, Charset charset) {
        if (nameStart >= valueEnd) {
            return false;
        }
        if (valueStart <= nameStart) {
            valueStart = valueEnd + 1;
        }
        String name = QueryStringDecoder.decodeComponent(s2, nameStart, valueStart - 1, charset, this.htmlQueryDecoding);
        String value2 = QueryStringDecoder.decodeComponent(s2, valueStart, valueEnd, charset, this.htmlQueryDecoding);
        List<String> values2 = params.get(name);
        if (values2 == null) {
            values2 = new ArrayList<String>(1);
            params.put(name, values2);
        }
        values2.add(value2);
        return true;
    }

    public static String decodeComponent(String s2) {
        return QueryStringDecoder.decodeComponent(s2, HttpConstants.DEFAULT_CHARSET);
    }

    public static String decodeComponent(String s2, Charset charset) {
        if (s2 == null) {
            return "";
        }
        return QueryStringDecoder.decodeComponent(s2, 0, s2.length(), charset, true);
    }

    private static String decodeComponent(String s2, int from2, int toExcluded, Charset charset, boolean plusToSpace) {
        int len2 = toExcluded - from2;
        if (len2 <= 0) {
            return "";
        }
        int firstEscaped = -1;
        for (int i2 = from2; i2 < toExcluded; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 != '%' && (c2 != '+' || !plusToSpace)) continue;
            firstEscaped = i2;
            break;
        }
        if (firstEscaped == -1) {
            return s2.substring(from2, toExcluded);
        }
        int decodedCapacity = (toExcluded - firstEscaped) / 3;
        byte[] buf = PlatformDependent.allocateUninitializedArray(decodedCapacity);
        StringBuilder strBuf = new StringBuilder(len2);
        strBuf.append(s2, from2, firstEscaped);
        for (int i3 = firstEscaped; i3 < toExcluded; ++i3) {
            char c3 = s2.charAt(i3);
            if (c3 != '%') {
                strBuf.append(c3 != '+' || !plusToSpace ? c3 : (char)' ');
                continue;
            }
            int bufIdx = 0;
            do {
                if (i3 + 3 > toExcluded) {
                    throw new IllegalArgumentException("unterminated escape sequence at index " + i3 + " of: " + s2);
                }
                buf[bufIdx++] = StringUtil.decodeHexByte(s2, i3 + 1);
            } while ((i3 += 3) < toExcluded && s2.charAt(i3) == '%');
            --i3;
            strBuf.append(new String(buf, 0, bufIdx, charset));
        }
        return strBuf.toString();
    }

    private static int findPathEndIndex(String uri2) {
        int len2 = uri2.length();
        for (int i2 = 0; i2 < len2; ++i2) {
            char c2 = uri2.charAt(i2);
            if (c2 != '?' && c2 != '#') continue;
            return i2;
        }
        return len2;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean hasPath = true;
        private int maxParams = 1024;
        private boolean semicolonIsNormalChar;
        private Charset charset = HttpConstants.DEFAULT_CHARSET;
        private boolean htmlQueryDecoding = true;

        private Builder() {
        }

        public Builder hasPath(boolean hasPath) {
            this.hasPath = hasPath;
            return this;
        }

        public Builder maxParams(int maxParams) {
            this.maxParams = maxParams;
            return this;
        }

        public Builder semicolonIsNormalChar(boolean semicolonIsNormalChar) {
            this.semicolonIsNormalChar = semicolonIsNormalChar;
            return this;
        }

        public Builder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder htmlQueryDecoding(boolean htmlQueryDecoding) {
            this.htmlQueryDecoding = htmlQueryDecoding;
            return this;
        }

        public QueryStringDecoder build(String uri2) {
            return new QueryStringDecoder(this, uri2);
        }

        public QueryStringDecoder build(URI uri2) {
            return new QueryStringDecoder(this, uri2);
        }
    }
}

