/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelException;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.nio.charset.Charset;

public abstract class AbstractHttpData
extends AbstractReferenceCounted
implements HttpData {
    private final String name;
    protected long definedSize;
    protected long size;
    private Charset charset = HttpConstants.DEFAULT_CHARSET;
    private boolean completed;
    private long maxSize = -1L;

    protected AbstractHttpData(String name, Charset charset, long size2) {
        ObjectUtil.checkNotNull(name, "name");
        this.name = ObjectUtil.checkNonEmpty(AbstractHttpData.cleanName(name), "name");
        if (charset != null) {
            this.setCharset(charset);
        }
        this.definedSize = size2;
    }

    private static String cleanName(String name) {
        int start2;
        int len2 = name.length();
        StringBuilder sb = null;
        int end2 = len2;
        for (start2 = 0; start2 < end2 && Character.isWhitespace(name.charAt(start2)); ++start2) {
        }
        while (end2 > start2 && Character.isWhitespace(name.charAt(end2 - 1))) {
            --end2;
        }
        for (int i2 = start2; i2 < end2; ++i2) {
            char c2 = name.charAt(i2);
            if (c2 == '\n') {
                if (sb != null) continue;
                sb = new StringBuilder(len2);
                sb.append(name, start2, i2);
                continue;
            }
            if (c2 == '\r' || c2 == '\t') {
                if (sb == null) {
                    sb = new StringBuilder(len2);
                    sb.append(name, start2, i2);
                }
                sb.append(' ');
                continue;
            }
            if (sb == null) continue;
            sb.append(c2);
        }
        return sb == null ? name.substring(start2, end2) : sb.toString();
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(long maxSize2) {
        this.maxSize = maxSize2;
    }

    @Override
    public void checkSize(long newSize) throws IOException {
        if (this.maxSize >= 0L && newSize > this.maxSize) {
            throw new IOException("Size exceed allowed maximum capacity");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    protected void setCompleted() {
        this.setCompleted(true);
    }

    protected void setCompleted(boolean completed) {
        this.completed = completed;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(Charset charset) {
        this.charset = ObjectUtil.checkNotNull(charset, "charset");
    }

    @Override
    public long length() {
        return this.size;
    }

    @Override
    public long definedLength() {
        return this.definedSize;
    }

    @Override
    public ByteBuf content() {
        try {
            return this.getByteBuf();
        }
        catch (IOException e2) {
            throw new ChannelException(e2);
        }
    }

    @Override
    protected void deallocate() {
        this.delete();
    }

    @Override
    public HttpData retain() {
        super.retain();
        return this;
    }

    @Override
    public HttpData retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public abstract HttpData touch();

    @Override
    public abstract HttpData touch(Object var1);
}

