/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.HpackHeaderField;
import io.netty.handler.codec.http2.HpackHuffmanEncoder;
import io.netty.handler.codec.http2.HpackStaticTable;
import io.netty.handler.codec.http2.HpackUtil;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.MathUtil;
import java.util.Map;

final class HpackEncoder {
    static final int NOT_FOUND = -1;
    static final int HUFF_CODE_THRESHOLD = 512;
    private final NameEntry[] nameEntries;
    private final NameValueEntry[] nameValueEntries;
    private final NameValueEntry head;
    private NameValueEntry latest;
    private final HpackHuffmanEncoder hpackHuffmanEncoder;
    private final byte hashMask;
    private final boolean ignoreMaxHeaderListSize;
    private final int huffCodeThreshold;
    private long size;
    private long maxHeaderTableSize;
    private long maxHeaderListSize;

    HpackEncoder() {
        this(false);
    }

    HpackEncoder(boolean ignoreMaxHeaderListSize) {
        this(ignoreMaxHeaderListSize, 64, 512);
    }

    HpackEncoder(boolean ignoreMaxHeaderListSize, int arraySizeHint, int huffCodeThreshold) {
        this.latest = this.head = new NameValueEntry(-1, AsciiString.EMPTY_STRING, AsciiString.EMPTY_STRING, Integer.MAX_VALUE, null);
        this.hpackHuffmanEncoder = new HpackHuffmanEncoder();
        this.ignoreMaxHeaderListSize = ignoreMaxHeaderListSize;
        this.maxHeaderTableSize = 4096L;
        this.maxHeaderListSize = 0xFFFFFFFFL;
        this.nameEntries = new NameEntry[MathUtil.findNextPositivePowerOfTwo(Math.max(2, Math.min(arraySizeHint, 128)))];
        this.nameValueEntries = new NameValueEntry[this.nameEntries.length];
        this.hashMask = (byte)(this.nameEntries.length - 1);
        this.huffCodeThreshold = huffCodeThreshold;
    }

    public void encodeHeaders(int streamId, ByteBuf out2, Http2Headers headers2, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) throws Http2Exception {
        if (this.ignoreMaxHeaderListSize) {
            this.encodeHeadersIgnoreMaxHeaderListSize(out2, headers2, sensitivityDetector);
        } else {
            this.encodeHeadersEnforceMaxHeaderListSize(streamId, out2, headers2, sensitivityDetector);
        }
    }

    private void encodeHeadersEnforceMaxHeaderListSize(int streamId, ByteBuf out2, Http2Headers headers2, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) throws Http2Exception {
        long headerSize = 0L;
        for (Map.Entry<CharSequence, CharSequence> header : headers2) {
            CharSequence value2;
            CharSequence name = header.getKey();
            if ((headerSize += HpackHeaderField.sizeOf(name, value2 = header.getValue())) <= this.maxHeaderListSize) continue;
            Http2CodecUtil.headerListSizeExceeded(streamId, this.maxHeaderListSize, false);
        }
        this.encodeHeadersIgnoreMaxHeaderListSize(out2, headers2, sensitivityDetector);
    }

    private void encodeHeadersIgnoreMaxHeaderListSize(ByteBuf out2, Http2Headers headers2, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) {
        for (Map.Entry<CharSequence, CharSequence> header : headers2) {
            CharSequence name = header.getKey();
            CharSequence value2 = header.getValue();
            this.encodeHeader(out2, name, value2, sensitivityDetector.isSensitive(name, value2), HpackHeaderField.sizeOf(name, value2));
        }
    }

    private void encodeHeader(ByteBuf out2, CharSequence name, CharSequence value2, boolean sensitive, long headerSize) {
        int valueHash;
        if (sensitive) {
            int nameIndex = this.getNameIndex(name);
            this.encodeLiteral(out2, name, value2, HpackUtil.IndexType.NEVER, nameIndex);
            return;
        }
        if (this.maxHeaderTableSize == 0L) {
            int staticTableIndex = HpackStaticTable.getIndexInsensitive(name, value2);
            if (staticTableIndex == -1) {
                int nameIndex = HpackStaticTable.getIndex(name);
                this.encodeLiteral(out2, name, value2, HpackUtil.IndexType.NONE, nameIndex);
            } else {
                HpackEncoder.encodeInteger(out2, 128, 7, staticTableIndex);
            }
            return;
        }
        if (headerSize > this.maxHeaderTableSize) {
            int nameIndex = this.getNameIndex(name);
            this.encodeLiteral(out2, name, value2, HpackUtil.IndexType.NONE, nameIndex);
            return;
        }
        int nameHash = AsciiString.hashCode(name);
        NameValueEntry headerField = this.getEntryInsensitive(name, nameHash, value2, valueHash = AsciiString.hashCode(value2));
        if (headerField != null) {
            HpackEncoder.encodeInteger(out2, 128, 7, this.getIndexPlusOffset(headerField.counter));
        } else {
            int staticTableIndex = HpackStaticTable.getIndexInsensitive(name, value2);
            if (staticTableIndex != -1) {
                HpackEncoder.encodeInteger(out2, 128, 7, staticTableIndex);
            } else {
                this.ensureCapacity(headerSize);
                this.encodeAndAddEntries(out2, name, nameHash, value2, valueHash);
                this.size += headerSize;
            }
        }
    }

    private void encodeAndAddEntries(ByteBuf out2, CharSequence name, int nameHash, CharSequence value2, int valueHash) {
        int staticTableIndex = HpackStaticTable.getIndex(name);
        int nextCounter = this.latestCounter() - 1;
        if (staticTableIndex == -1) {
            NameEntry e2 = this.getEntry(name, nameHash);
            if (e2 == null) {
                this.encodeLiteral(out2, name, value2, HpackUtil.IndexType.INCREMENTAL, -1);
                this.addNameEntry(name, nameHash, nextCounter);
                this.addNameValueEntry(name, value2, nameHash, valueHash, nextCounter);
            } else {
                this.encodeLiteral(out2, name, value2, HpackUtil.IndexType.INCREMENTAL, this.getIndexPlusOffset(e2.counter));
                this.addNameValueEntry(e2.name, value2, nameHash, valueHash, nextCounter);
                e2.counter = nextCounter;
            }
        } else {
            this.encodeLiteral(out2, name, value2, HpackUtil.IndexType.INCREMENTAL, staticTableIndex);
            this.addNameValueEntry(HpackStaticTable.getEntry((int)staticTableIndex).name, value2, nameHash, valueHash, nextCounter);
        }
    }

    public void setMaxHeaderTableSize(ByteBuf out2, long maxHeaderTableSize) throws Http2Exception {
        if (maxHeaderTableSize < 0L || maxHeaderTableSize > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, maxHeaderTableSize);
        }
        if (this.maxHeaderTableSize == maxHeaderTableSize) {
            return;
        }
        this.maxHeaderTableSize = maxHeaderTableSize;
        this.ensureCapacity(0L);
        HpackEncoder.encodeInteger(out2, 32, 5, maxHeaderTableSize);
    }

    public long getMaxHeaderTableSize() {
        return this.maxHeaderTableSize;
    }

    public void setMaxHeaderListSize(long maxHeaderListSize) throws Http2Exception {
        if (maxHeaderListSize < 0L || maxHeaderListSize > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header List Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, maxHeaderListSize);
        }
        this.maxHeaderListSize = maxHeaderListSize;
    }

    public long getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    private static void encodeInteger(ByteBuf out2, int mask, int n, int i2) {
        HpackEncoder.encodeInteger(out2, mask, n, (long)i2);
    }

    private static void encodeInteger(ByteBuf out2, int mask, int n, long i2) {
        assert (n >= 0 && n <= 8) : "N: " + n;
        int nbits = 255 >>> 8 - n;
        if (i2 < (long)nbits) {
            out2.writeByte((int)((long)mask | i2));
        } else {
            out2.writeByte(mask | nbits);
            long length = i2 - (long)nbits;
            while ((length & 0xFFFFFFFFFFFFFF80L) != 0L) {
                out2.writeByte((int)(length & 0x7FL | 0x80L));
                length >>>= 7;
            }
            out2.writeByte((int)length);
        }
    }

    private void encodeStringLiteral(ByteBuf out2, CharSequence string) {
        int huffmanLength;
        if (string.length() >= this.huffCodeThreshold && (huffmanLength = this.hpackHuffmanEncoder.getEncodedLength(string)) < string.length()) {
            HpackEncoder.encodeInteger(out2, 128, 7, huffmanLength);
            this.hpackHuffmanEncoder.encode(out2, string);
        } else {
            HpackEncoder.encodeInteger(out2, 0, 7, string.length());
            if (string instanceof AsciiString) {
                AsciiString asciiString = (AsciiString)string;
                out2.writeBytes(asciiString.array(), asciiString.arrayOffset(), asciiString.length());
            } else {
                out2.writeCharSequence(string, CharsetUtil.ISO_8859_1);
            }
        }
    }

    private void encodeLiteral(ByteBuf out2, CharSequence name, CharSequence value2, HpackUtil.IndexType indexType, int nameIndex) {
        boolean nameIndexValid = nameIndex != -1;
        switch (indexType) {
            case INCREMENTAL: {
                HpackEncoder.encodeInteger(out2, 64, 6, nameIndexValid ? nameIndex : 0);
                break;
            }
            case NONE: {
                HpackEncoder.encodeInteger(out2, 0, 4, nameIndexValid ? nameIndex : 0);
                break;
            }
            case NEVER: {
                HpackEncoder.encodeInteger(out2, 16, 4, nameIndexValid ? nameIndex : 0);
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        if (!nameIndexValid) {
            this.encodeStringLiteral(out2, name);
        }
        this.encodeStringLiteral(out2, value2);
    }

    private int getNameIndex(CharSequence name) {
        int index = HpackStaticTable.getIndex(name);
        if (index != -1) {
            return index;
        }
        NameEntry e2 = this.getEntry(name, AsciiString.hashCode(name));
        return e2 == null ? -1 : this.getIndexPlusOffset(e2.counter);
    }

    private void ensureCapacity(long headerSize) {
        while (this.maxHeaderTableSize - this.size < headerSize) {
            this.remove();
        }
    }

    int length() {
        return this.isEmpty() ? 0 : this.getIndex(this.head.after.counter);
    }

    long size() {
        return this.size;
    }

    HpackHeaderField getHeaderField(int index) {
        NameValueEntry entry = this.head;
        while (index++ < this.length()) {
            entry = entry.after;
        }
        return entry;
    }

    private NameValueEntry getEntryInsensitive(CharSequence name, int nameHash, CharSequence value2, int valueHash) {
        int h2 = HpackEncoder.hash(nameHash, valueHash);
        NameValueEntry e2 = this.nameValueEntries[this.bucket(h2)];
        while (e2 != null) {
            if (e2.hash == h2 && HpackUtil.equalsVariableTime(value2, e2.value) && HpackUtil.equalsVariableTime(name, e2.name)) {
                return e2;
            }
            e2 = e2.next;
        }
        return null;
    }

    private NameEntry getEntry(CharSequence name, int nameHash) {
        NameEntry e2 = this.nameEntries[this.bucket(nameHash)];
        while (e2 != null) {
            if (e2.hash == nameHash && HpackUtil.equalsConstantTime(name, e2.name) != 0) {
                return e2;
            }
            e2 = e2.next;
        }
        return null;
    }

    private int getIndexPlusOffset(int counter2) {
        return this.getIndex(counter2) + HpackStaticTable.length;
    }

    private int getIndex(int counter2) {
        return counter2 - this.latestCounter() + 1;
    }

    private int latestCounter() {
        return this.latest.counter;
    }

    private void addNameEntry(CharSequence name, int nameHash, int nextCounter) {
        int bucket = this.bucket(nameHash);
        this.nameEntries[bucket] = new NameEntry(nameHash, name, nextCounter, this.nameEntries[bucket]);
    }

    private void addNameValueEntry(CharSequence name, CharSequence value2, int nameHash, int valueHash, int nextCounter) {
        NameValueEntry e2;
        int hash = HpackEncoder.hash(nameHash, valueHash);
        int bucket = this.bucket(hash);
        this.nameValueEntries[bucket] = e2 = new NameValueEntry(hash, name, value2, nextCounter, this.nameValueEntries[bucket]);
        this.latest.after = e2;
        this.latest = e2;
    }

    private void remove() {
        NameValueEntry eldest = this.head.after;
        this.removeNameValueEntry(eldest);
        this.removeNameEntryMatchingCounter(eldest.name, eldest.counter);
        this.head.after = eldest.after;
        eldest.unlink();
        this.size -= (long)eldest.size();
        if (this.isEmpty()) {
            this.latest = this.head;
        }
    }

    private boolean isEmpty() {
        return this.size == 0L;
    }

    private void removeNameValueEntry(NameValueEntry eldest) {
        int bucket = this.bucket(eldest.hash);
        NameValueEntry e2 = this.nameValueEntries[bucket];
        if (e2 == eldest) {
            this.nameValueEntries[bucket] = eldest.next;
        } else {
            while (e2.next != eldest) {
                e2 = e2.next;
            }
            e2.next = eldest.next;
        }
    }

    private void removeNameEntryMatchingCounter(CharSequence name, int counter2) {
        int hash = AsciiString.hashCode(name);
        int bucket = this.bucket(hash);
        NameEntry e2 = this.nameEntries[bucket];
        if (e2 == null) {
            return;
        }
        if (counter2 == e2.counter) {
            this.nameEntries[bucket] = e2.next;
            e2.unlink();
        } else {
            NameEntry prev = e2;
            e2 = e2.next;
            while (e2 != null) {
                if (counter2 == e2.counter) {
                    prev.next = e2.next;
                    e2.unlink();
                    break;
                }
                prev = e2;
                e2 = e2.next;
            }
        }
    }

    private int bucket(int h2) {
        return h2 & this.hashMask;
    }

    private static int hash(int nameHash, int valueHash) {
        return 31 * nameHash + valueHash;
    }

    private static final class NameValueEntry
    extends HpackHeaderField {
        NameValueEntry after;
        NameValueEntry next;
        final int hash;
        final int counter;

        NameValueEntry(int hash, CharSequence name, CharSequence value2, int counter2, NameValueEntry next2) {
            super(name, value2);
            this.next = next2;
            this.hash = hash;
            this.counter = counter2;
        }

        void unlink() {
            this.after = null;
            this.next = null;
        }
    }

    private static final class NameEntry {
        NameEntry next;
        final CharSequence name;
        final int hash;
        int counter;

        NameEntry(int hash, CharSequence name, int counter2, NameEntry next2) {
            this.hash = hash;
            this.name = name;
            this.counter = counter2;
            this.next = next2;
        }

        void unlink() {
            this.next = null;
        }
    }
}

