/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.util.collection.CharObjectHashMap;
import io.netty.util.internal.ObjectUtil;

public final class Http2Settings
extends CharObjectHashMap<Long> {
    private static final int DEFAULT_CAPACITY = 15;
    private static final Long FALSE = 0L;
    private static final Long TRUE = 1L;

    public Http2Settings() {
        this(15);
    }

    public Http2Settings(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public Http2Settings(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public Long put(char key2, Long value2) {
        Http2Settings.verifyStandardSetting(key2, value2);
        return super.put(key2, value2);
    }

    public Long headerTableSize() {
        return (Long)this.get('\u0001');
    }

    public Http2Settings headerTableSize(long value2) {
        this.put('\u0001', value2);
        return this;
    }

    public Boolean pushEnabled() {
        Long value2 = (Long)this.get('\u0002');
        if (value2 == null) {
            return null;
        }
        return TRUE.equals(value2);
    }

    public Http2Settings pushEnabled(boolean enabled) {
        this.put('\u0002', enabled ? TRUE : FALSE);
        return this;
    }

    public Long maxConcurrentStreams() {
        return (Long)this.get('\u0003');
    }

    public Http2Settings maxConcurrentStreams(long value2) {
        this.put('\u0003', value2);
        return this;
    }

    public Integer initialWindowSize() {
        return this.getIntValue('\u0004');
    }

    public Http2Settings initialWindowSize(int value2) {
        this.put('\u0004', Long.valueOf(value2));
        return this;
    }

    public Integer maxFrameSize() {
        return this.getIntValue('\u0005');
    }

    public Http2Settings maxFrameSize(int value2) {
        this.put('\u0005', Long.valueOf(value2));
        return this;
    }

    public Long maxHeaderListSize() {
        return (Long)this.get('\u0006');
    }

    public Http2Settings maxHeaderListSize(long value2) {
        this.put('\u0006', value2);
        return this;
    }

    public Boolean connectProtocolEnabled() {
        Long value2 = (Long)this.get('\b');
        if (value2 == null) {
            return null;
        }
        return TRUE.equals(value2);
    }

    public Http2Settings connectProtocolEnabled(boolean enabled) {
        this.put('\b', enabled ? TRUE : FALSE);
        return this;
    }

    public Http2Settings copyFrom(Http2Settings settings) {
        this.clear();
        this.putAll(settings);
        return this;
    }

    public Integer getIntValue(char key2) {
        Long value2 = (Long)this.get(key2);
        if (value2 == null) {
            return null;
        }
        return value2.intValue();
    }

    private static void verifyStandardSetting(int key2, Long value2) {
        ObjectUtil.checkNotNull(value2, "value");
        switch (key2) {
            case 1: {
                if (value2 >= 0L && value2 <= 0xFFFFFFFFL) break;
                throw new IllegalArgumentException("Setting HEADER_TABLE_SIZE is invalid: " + value2 + ", expected [" + 0L + ", " + 0xFFFFFFFFL + ']');
            }
            case 2: {
                if (value2 == 0L || value2 == 1L) break;
                throw new IllegalArgumentException("Setting ENABLE_PUSH is invalid: " + value2 + ", expected [0, 1]");
            }
            case 3: {
                if (value2 >= 0L && value2 <= 0xFFFFFFFFL) break;
                throw new IllegalArgumentException("Setting MAX_CONCURRENT_STREAMS is invalid: " + value2 + ", expected [" + 0L + ", " + 0xFFFFFFFFL + ']');
            }
            case 4: {
                if (value2 >= 0L && value2 <= Integer.MAX_VALUE) break;
                throw new IllegalArgumentException("Setting INITIAL_WINDOW_SIZE is invalid: " + value2 + ", expected [" + 0 + ", " + Integer.MAX_VALUE + ']');
            }
            case 5: {
                if (Http2CodecUtil.isMaxFrameSizeValid(value2.intValue())) break;
                throw new IllegalArgumentException("Setting MAX_FRAME_SIZE is invalid: " + value2 + ", expected [" + 16384 + ", " + 0xFFFFFF + ']');
            }
            case 6: {
                if (value2 >= 0L && value2 <= 0xFFFFFFFFL) break;
                throw new IllegalArgumentException("Setting MAX_HEADER_LIST_SIZE is invalid: " + value2 + ", expected [" + 0L + ", " + 0xFFFFFFFFL + ']');
            }
            case 8: {
                if (value2 == 0L || value2 == 1L) break;
                throw new IllegalArgumentException("Setting ENABLE_CONNECT_PROTOCOL is invalid: " + value2 + ", expected [0, 1]");
            }
            default: {
                if (value2 >= 0L && value2 <= 0xFFFFFFFFL) break;
                throw new IllegalArgumentException("Non-standard setting 0x" + Integer.toHexString(key2) + " is invalid: " + value2 + ", expected unsigned 32-bit value");
            }
        }
    }

    @Override
    protected String keyToString(char key2) {
        switch (key2) {
            case '\u0001': {
                return "HEADER_TABLE_SIZE";
            }
            case '\u0002': {
                return "ENABLE_PUSH";
            }
            case '\u0003': {
                return "MAX_CONCURRENT_STREAMS";
            }
            case '\u0004': {
                return "INITIAL_WINDOW_SIZE";
            }
            case '\u0005': {
                return "MAX_FRAME_SIZE";
            }
            case '\u0006': {
                return "MAX_HEADER_LIST_SIZE";
            }
            case '\b': {
                return "ENABLE_CONNECT_PROTOCOL";
            }
        }
        return "0x" + Integer.toHexString(key2);
    }

    public static Http2Settings defaultSettings() {
        return new Http2Settings().maxHeaderListSize(8192L);
    }
}

