/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.UnsupportedValueConverter;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.CharSequenceMap;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class HttpConversionUtil {
    private static final CharSequenceMap<AsciiString> HTTP_TO_HTTP2_HEADER_BLACKLIST = new CharSequenceMap();
    public static final HttpMethod OUT_OF_MESSAGE_SEQUENCE_METHOD;
    public static final String OUT_OF_MESSAGE_SEQUENCE_PATH = "";
    public static final HttpResponseStatus OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE;
    private static final AsciiString EMPTY_REQUEST_PATH;

    private HttpConversionUtil() {
    }

    public static HttpResponseStatus parseStatus(CharSequence status2) throws Http2Exception {
        HttpResponseStatus result2;
        try {
            result2 = HttpResponseStatus.parseLine(status2);
            if (result2 == HttpResponseStatus.SWITCHING_PROTOCOLS) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Invalid HTTP/2 status code '%d'", result2.code());
            }
        }
        catch (Http2Exception e2) {
            throw e2;
        }
        catch (Throwable t2) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, t2, "Unrecognized HTTP status code '%s' encountered in translation to HTTP/1.x", status2);
        }
        return result2;
    }

    public static FullHttpResponse toFullHttpResponse(int streamId, Http2Headers http2Headers, ByteBufAllocator alloc, boolean validateHttpHeaders) throws Http2Exception {
        return HttpConversionUtil.toFullHttpResponse(streamId, http2Headers, alloc.buffer(), validateHttpHeaders);
    }

    public static FullHttpResponse toFullHttpResponse(int streamId, Http2Headers http2Headers, ByteBuf content2, boolean validateHttpHeaders) throws Http2Exception {
        HttpResponseStatus status2 = HttpConversionUtil.parseStatus(http2Headers.status());
        DefaultFullHttpResponse msg = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status2, content2, validateHttpHeaders);
        try {
            HttpConversionUtil.addHttp2ToHttpHeaders(streamId, http2Headers, msg, false);
        }
        catch (Http2Exception e2) {
            msg.release();
            throw e2;
        }
        catch (Throwable t2) {
            msg.release();
            throw Http2Exception.streamError(streamId, Http2Error.PROTOCOL_ERROR, t2, "HTTP/2 to HTTP/1.x headers conversion error", new Object[0]);
        }
        return msg;
    }

    public static FullHttpRequest toFullHttpRequest(int streamId, Http2Headers http2Headers, ByteBufAllocator alloc, boolean validateHttpHeaders) throws Http2Exception {
        return HttpConversionUtil.toFullHttpRequest(streamId, http2Headers, alloc.buffer(), validateHttpHeaders);
    }

    private static String extractPath(CharSequence method2, Http2Headers headers2) {
        if (HttpMethod.CONNECT.asciiName().contentEqualsIgnoreCase(method2)) {
            return ObjectUtil.checkNotNull(headers2.authority(), "authority header cannot be null in the conversion to HTTP/1.x").toString();
        }
        return ObjectUtil.checkNotNull(headers2.path(), "path header cannot be null in conversion to HTTP/1.x").toString();
    }

    public static FullHttpRequest toFullHttpRequest(int streamId, Http2Headers http2Headers, ByteBuf content2, boolean validateHttpHeaders) throws Http2Exception {
        CharSequence method2 = ObjectUtil.checkNotNull(http2Headers.method(), "method header cannot be null in conversion to HTTP/1.x");
        String path2 = HttpConversionUtil.extractPath(method2, http2Headers);
        DefaultFullHttpRequest msg = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf(method2.toString()), path2.toString(), content2, validateHttpHeaders);
        try {
            HttpConversionUtil.addHttp2ToHttpHeaders(streamId, http2Headers, msg, false);
        }
        catch (Http2Exception e2) {
            msg.release();
            throw e2;
        }
        catch (Throwable t2) {
            msg.release();
            throw Http2Exception.streamError(streamId, Http2Error.PROTOCOL_ERROR, t2, "HTTP/2 to HTTP/1.x headers conversion error", new Object[0]);
        }
        return msg;
    }

    public static HttpRequest toHttpRequest(int streamId, Http2Headers http2Headers, boolean validateHttpHeaders) throws Http2Exception {
        CharSequence method2 = ObjectUtil.checkNotNull(http2Headers.method(), "method header cannot be null in conversion to HTTP/1.x");
        String path2 = HttpConversionUtil.extractPath(method2, http2Headers);
        DefaultHttpRequest msg = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf(method2.toString()), path2.toString(), validateHttpHeaders);
        try {
            HttpConversionUtil.addHttp2ToHttpHeaders(streamId, http2Headers, msg.headers(), msg.protocolVersion(), false, true);
        }
        catch (Http2Exception e2) {
            throw e2;
        }
        catch (Throwable t2) {
            throw Http2Exception.streamError(streamId, Http2Error.PROTOCOL_ERROR, t2, "HTTP/2 to HTTP/1.x headers conversion error", new Object[0]);
        }
        return msg;
    }

    public static HttpResponse toHttpResponse(int streamId, Http2Headers http2Headers, boolean validateHttpHeaders) throws Http2Exception {
        HttpResponseStatus status2 = HttpConversionUtil.parseStatus(http2Headers.status());
        DefaultHttpResponse msg = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status2, validateHttpHeaders);
        try {
            HttpConversionUtil.addHttp2ToHttpHeaders(streamId, http2Headers, msg.headers(), msg.protocolVersion(), false, false);
        }
        catch (Http2Exception e2) {
            throw e2;
        }
        catch (Throwable t2) {
            throw Http2Exception.streamError(streamId, Http2Error.PROTOCOL_ERROR, t2, "HTTP/2 to HTTP/1.x headers conversion error", new Object[0]);
        }
        return msg;
    }

    public static void addHttp2ToHttpHeaders(int streamId, Http2Headers inputHeaders, FullHttpMessage destinationMessage, boolean addToTrailer) throws Http2Exception {
        HttpConversionUtil.addHttp2ToHttpHeaders(streamId, inputHeaders, addToTrailer ? destinationMessage.trailingHeaders() : destinationMessage.headers(), destinationMessage.protocolVersion(), addToTrailer, destinationMessage instanceof HttpRequest);
    }

    public static void addHttp2ToHttpHeaders(int streamId, Http2Headers inputHeaders, HttpHeaders outputHeaders, HttpVersion httpVersion, boolean isTrailer, boolean isRequest) throws Http2Exception {
        Http2ToHttpHeaderTranslator translator = new Http2ToHttpHeaderTranslator(streamId, outputHeaders, isRequest);
        try {
            translator.translateHeaders(inputHeaders);
        }
        catch (Http2Exception ex) {
            throw ex;
        }
        catch (Throwable t2) {
            throw Http2Exception.streamError(streamId, Http2Error.PROTOCOL_ERROR, t2, "HTTP/2 to HTTP/1.x headers conversion error", new Object[0]);
        }
        outputHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING);
        outputHeaders.remove(HttpHeaderNames.TRAILER);
        if (!isTrailer) {
            outputHeaders.setInt(ExtensionHeaderNames.STREAM_ID.text(), streamId);
            HttpUtil.setKeepAlive(outputHeaders, httpVersion, true);
        }
    }

    public static Http2Headers toHttp2Headers(HttpMessage in, boolean validateHeaders) {
        HttpHeaders inHeaders = in.headers();
        DefaultHttp2Headers out2 = new DefaultHttp2Headers(validateHeaders, inHeaders.size());
        if (in instanceof HttpRequest) {
            HttpRequest request2 = (HttpRequest)in;
            String host2 = inHeaders.getAsString(HttpHeaderNames.HOST);
            if (HttpUtil.isOriginForm(request2.uri()) || HttpUtil.isAsteriskForm(request2.uri())) {
                out2.path(new AsciiString(request2.uri()));
                HttpConversionUtil.setHttp2Scheme(inHeaders, out2);
            } else {
                URI requestTargetUri = URI.create(request2.uri());
                out2.path(HttpConversionUtil.toHttp2Path(requestTargetUri));
                host2 = StringUtil.isNullOrEmpty(host2) ? requestTargetUri.getAuthority() : host2;
                HttpConversionUtil.setHttp2Scheme(inHeaders, requestTargetUri, out2);
            }
            HttpConversionUtil.setHttp2Authority(host2, out2);
            out2.method(request2.method().asciiName());
        } else if (in instanceof HttpResponse) {
            HttpResponse response2 = (HttpResponse)in;
            out2.status(response2.status().codeAsText());
        }
        HttpConversionUtil.toHttp2Headers(inHeaders, out2);
        return out2;
    }

    public static Http2Headers toHttp2Headers(HttpHeaders inHeaders, boolean validateHeaders) {
        if (inHeaders.isEmpty()) {
            return EmptyHttp2Headers.INSTANCE;
        }
        DefaultHttp2Headers out2 = new DefaultHttp2Headers(validateHeaders, inHeaders.size());
        HttpConversionUtil.toHttp2Headers(inHeaders, out2);
        return out2;
    }

    private static CharSequenceMap<AsciiString> toLowercaseMap(Iterator<? extends CharSequence> valuesIter, int arraySizeHint) {
        UnsupportedValueConverter valueConverter = UnsupportedValueConverter.instance();
        CharSequenceMap<AsciiString> result2 = new CharSequenceMap<AsciiString>(true, valueConverter, arraySizeHint);
        while (valuesIter.hasNext()) {
            AsciiString lowerCased = AsciiString.of(valuesIter.next()).toLowerCase();
            try {
                int index = lowerCased.forEachByte(ByteProcessor.FIND_COMMA);
                if (index != -1) {
                    int start2 = 0;
                    do {
                        result2.add(lowerCased.subSequence(start2, index, false).trim(), AsciiString.EMPTY_STRING);
                    } while ((start2 = index + 1) < lowerCased.length() && (index = lowerCased.forEachByte(start2, lowerCased.length() - start2, ByteProcessor.FIND_COMMA)) != -1);
                    result2.add(lowerCased.subSequence(start2, lowerCased.length(), false).trim(), AsciiString.EMPTY_STRING);
                    continue;
                }
                result2.add(lowerCased.trim(), AsciiString.EMPTY_STRING);
            }
            catch (Exception e2) {
                throw new IllegalStateException(e2);
            }
        }
        return result2;
    }

    private static void toHttp2HeadersFilterTE(Map.Entry<CharSequence, CharSequence> entry, Http2Headers out2) {
        block2: {
            block1: {
                if (AsciiString.indexOf(entry.getValue(), ',', 0) != -1) break block1;
                if (!AsciiString.contentEqualsIgnoreCase(AsciiString.trim(entry.getValue()), HttpHeaderValues.TRAILERS)) break block2;
                out2.add(HttpHeaderNames.TE, HttpHeaderValues.TRAILERS);
                break block2;
            }
            List<CharSequence> teValues = StringUtil.unescapeCsvFields(entry.getValue());
            for (CharSequence teValue : teValues) {
                if (!AsciiString.contentEqualsIgnoreCase(AsciiString.trim(teValue), HttpHeaderValues.TRAILERS)) continue;
                out2.add(HttpHeaderNames.TE, HttpHeaderValues.TRAILERS);
                break;
            }
        }
    }

    public static void toHttp2Headers(HttpHeaders inHeaders, Http2Headers out2) {
        Iterator<Map.Entry<CharSequence, CharSequence>> iter = inHeaders.iteratorCharSequence();
        CharSequenceMap<AsciiString> connectionBlacklist = HttpConversionUtil.toLowercaseMap(inHeaders.valueCharSequenceIterator(HttpHeaderNames.CONNECTION), 8);
        while (iter.hasNext()) {
            Map.Entry<CharSequence, CharSequence> entry = iter.next();
            AsciiString aName = AsciiString.of(entry.getKey()).toLowerCase();
            if (HTTP_TO_HTTP2_HEADER_BLACKLIST.contains(aName) || connectionBlacklist.contains(aName)) continue;
            if (aName.contentEqualsIgnoreCase(HttpHeaderNames.TE)) {
                HttpConversionUtil.toHttp2HeadersFilterTE(entry, out2);
                continue;
            }
            if (aName.contentEqualsIgnoreCase(HttpHeaderNames.COOKIE)) {
                CharSequence valueCs = entry.getValue();
                boolean invalid = false;
                for (int i2 = 0; i2 < valueCs.length(); ++i2) {
                    char c2 = valueCs.charAt(i2);
                    if (c2 == ';') {
                        if (i2 + 1 >= valueCs.length() || valueCs.charAt(i2 + 1) != ' ') {
                            invalid = true;
                            break;
                        }
                        ++i2;
                        continue;
                    }
                    if (c2 <= '\u00ff') continue;
                    invalid = true;
                    break;
                }
                if (invalid) {
                    out2.add(HttpHeaderNames.COOKIE, valueCs);
                    continue;
                }
                HttpConversionUtil.splitValidCookieHeader(out2, valueCs);
                continue;
            }
            out2.add(aName, entry.getValue());
        }
    }

    private static void splitValidCookieHeader(Http2Headers out2, CharSequence valueCs) {
        try {
            AsciiString value2 = AsciiString.of(valueCs);
            int index = value2.forEachByte(ByteProcessor.FIND_SEMI_COLON);
            if (index != -1) {
                int start2 = 0;
                do {
                    out2.add(HttpHeaderNames.COOKIE, value2.subSequence(start2, index, false));
                    assert (index + 1 < value2.length());
                    assert (value2.charAt(index + 1) == ' ');
                } while ((start2 = index + 2) < value2.length() && (index = value2.forEachByte(start2, value2.length() - start2, ByteProcessor.FIND_SEMI_COLON)) != -1);
                assert (start2 < value2.length());
                out2.add(HttpHeaderNames.COOKIE, value2.subSequence(start2, value2.length(), false));
            } else {
                out2.add(HttpHeaderNames.COOKIE, value2);
            }
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
    }

    private static AsciiString toHttp2Path(URI uri2) {
        String path2;
        StringBuilder pathBuilder = new StringBuilder(StringUtil.length(uri2.getRawPath()) + StringUtil.length(uri2.getRawQuery()) + StringUtil.length(uri2.getRawFragment()) + 2);
        if (!StringUtil.isNullOrEmpty(uri2.getRawPath())) {
            pathBuilder.append(uri2.getRawPath());
        }
        if (!StringUtil.isNullOrEmpty(uri2.getRawQuery())) {
            pathBuilder.append('?');
            pathBuilder.append(uri2.getRawQuery());
        }
        if (!StringUtil.isNullOrEmpty(uri2.getRawFragment())) {
            pathBuilder.append('#');
            pathBuilder.append(uri2.getRawFragment());
        }
        return (path2 = pathBuilder.toString()).isEmpty() ? EMPTY_REQUEST_PATH : new AsciiString(path2);
    }

    static void setHttp2Authority(String authority, Http2Headers out2) {
        if (authority != null) {
            if (authority.isEmpty()) {
                out2.authority(AsciiString.EMPTY_STRING);
            } else {
                int start2 = authority.indexOf(64) + 1;
                int length = authority.length() - start2;
                if (length == 0) {
                    throw new IllegalArgumentException("authority: " + authority);
                }
                out2.authority(new AsciiString(authority, start2, length));
            }
        }
    }

    private static void setHttp2Scheme(HttpHeaders in, Http2Headers out2) {
        HttpConversionUtil.setHttp2Scheme(in, URI.create(OUT_OF_MESSAGE_SEQUENCE_PATH), out2);
    }

    private static void setHttp2Scheme(HttpHeaders in, URI uri2, Http2Headers out2) {
        String value2 = uri2.getScheme();
        if (!StringUtil.isNullOrEmpty(value2)) {
            out2.scheme(new AsciiString(value2));
            return;
        }
        String cValue = in.get(ExtensionHeaderNames.SCHEME.text());
        if (cValue != null) {
            out2.scheme(AsciiString.of(cValue));
            return;
        }
        if (uri2.getPort() == HttpScheme.HTTPS.port()) {
            out2.scheme(HttpScheme.HTTPS.name());
        } else if (uri2.getPort() == HttpScheme.HTTP.port()) {
            out2.scheme(HttpScheme.HTTP.name());
        } else {
            throw new IllegalArgumentException(":scheme must be specified. see https://tools.ietf.org/html/rfc7540#section-8.1.2.3");
        }
    }

    static {
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.CONNECTION, AsciiString.EMPTY_STRING);
        AsciiString keepAlive = HttpHeaderNames.KEEP_ALIVE;
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(keepAlive, AsciiString.EMPTY_STRING);
        AsciiString proxyConnection = HttpHeaderNames.PROXY_CONNECTION;
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(proxyConnection, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.TRANSFER_ENCODING, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.HOST, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.UPGRADE, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(ExtensionHeaderNames.STREAM_ID.text(), AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(ExtensionHeaderNames.SCHEME.text(), AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(ExtensionHeaderNames.PATH.text(), AsciiString.EMPTY_STRING);
        OUT_OF_MESSAGE_SEQUENCE_METHOD = HttpMethod.OPTIONS;
        OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE = HttpResponseStatus.OK;
        EMPTY_REQUEST_PATH = AsciiString.cached("/");
    }

    private static final class Http2ToHttpHeaderTranslator {
        private static final CharSequenceMap<AsciiString> REQUEST_HEADER_TRANSLATIONS = new CharSequenceMap();
        private static final CharSequenceMap<AsciiString> RESPONSE_HEADER_TRANSLATIONS = new CharSequenceMap();
        private final int streamId;
        private final HttpHeaders output;
        private final CharSequenceMap<AsciiString> translations;

        Http2ToHttpHeaderTranslator(int streamId, HttpHeaders output, boolean request2) {
            this.streamId = streamId;
            this.output = output;
            this.translations = request2 ? REQUEST_HEADER_TRANSLATIONS : RESPONSE_HEADER_TRANSLATIONS;
        }

        void translateHeaders(Iterable<Map.Entry<CharSequence, CharSequence>> inputHeaders) throws Http2Exception {
            StringBuilder cookies2 = null;
            for (Map.Entry<CharSequence, CharSequence> entry : inputHeaders) {
                CharSequence name = entry.getKey();
                CharSequence value2 = entry.getValue();
                AsciiString translatedName = (AsciiString)this.translations.get(name);
                if (translatedName != null) {
                    this.output.add((CharSequence)translatedName, (Object)AsciiString.of(value2));
                    continue;
                }
                if (Http2Headers.PseudoHeaderName.isPseudoHeader(name)) continue;
                if (name.length() == 0 || name.charAt(0) == ':') {
                    throw Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, "Invalid HTTP/2 header '%s' encountered in translation to HTTP/1.x", name);
                }
                if (HttpHeaderNames.COOKIE.equals(name)) {
                    if (cookies2 == null) {
                        cookies2 = InternalThreadLocalMap.get().stringBuilder();
                    } else if (cookies2.length() > 0) {
                        cookies2.append("; ");
                    }
                    cookies2.append(value2);
                    continue;
                }
                this.output.add(name, (Object)value2);
            }
            if (cookies2 != null) {
                this.output.add((CharSequence)HttpHeaderNames.COOKIE, (Object)cookies2.toString());
            }
        }

        static {
            RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers.PseudoHeaderName.AUTHORITY.value(), HttpHeaderNames.HOST);
            RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers.PseudoHeaderName.SCHEME.value(), ExtensionHeaderNames.SCHEME.text());
            REQUEST_HEADER_TRANSLATIONS.add(RESPONSE_HEADER_TRANSLATIONS);
            RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers.PseudoHeaderName.PATH.value(), ExtensionHeaderNames.PATH.text());
        }
    }

    public static enum ExtensionHeaderNames {
        STREAM_ID("x-http2-stream-id"),
        SCHEME("x-http2-scheme"),
        PATH("x-http2-path"),
        STREAM_PROMISE_ID("x-http2-stream-promise-id"),
        STREAM_DEPENDENCY_ID("x-http2-stream-dependency-id"),
        STREAM_WEIGHT("x-http2-stream-weight");

        private final AsciiString text;

        private ExtensionHeaderNames(String text) {
            this.text = AsciiString.cached(text);
        }

        public AsciiString text() {
            return this.text;
        }
    }
}

