/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.json;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JsonObjectDecoder
extends ByteToMessageDecoder {
    private static final int ST_CORRUPTED = -1;
    private static final int ST_INIT = 0;
    private static final int ST_DECODING_NORMAL = 1;
    private static final int ST_DECODING_ARRAY_STREAM = 2;
    private int openBraces;
    private int idx;
    private int lastReaderIndex;
    private int state;
    private boolean insideString;
    private final int maxObjectLength;
    private final boolean streamArrayElements;

    public JsonObjectDecoder() {
        this(0x100000);
    }

    public JsonObjectDecoder(int maxObjectLength) {
        this(maxObjectLength, false);
    }

    public JsonObjectDecoder(boolean streamArrayElements) {
        this(0x100000, streamArrayElements);
    }

    public JsonObjectDecoder(int maxObjectLength, boolean streamArrayElements) {
        this.maxObjectLength = ObjectUtil.checkPositive(maxObjectLength, "maxObjectLength");
        this.streamArrayElements = streamArrayElements;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out2) throws Exception {
        int idx;
        int wrtIdx;
        if (this.state == -1) {
            in.skipBytes(in.readableBytes());
            return;
        }
        if (this.idx > in.readerIndex() && this.lastReaderIndex != in.readerIndex()) {
            this.idx = in.readerIndex() + (this.idx - this.lastReaderIndex);
        }
        if ((wrtIdx = in.writerIndex()) > this.maxObjectLength) {
            in.skipBytes(in.readableBytes());
            this.reset();
            throw new TooLongFrameException("object length exceeds " + this.maxObjectLength + ": " + wrtIdx + " bytes discarded");
        }
        for (idx = this.idx; idx < wrtIdx; ++idx) {
            byte c2 = in.getByte(idx);
            if (this.state == 1) {
                this.decodeByte(c2, in, idx);
                if (this.openBraces != 0) continue;
                ByteBuf json2 = this.extractObject(ctx, in, in.readerIndex(), idx + 1 - in.readerIndex());
                if (json2 != null) {
                    out2.add(json2);
                }
                in.readerIndex(idx + 1);
                this.reset();
                continue;
            }
            if (this.state == 2) {
                int idxNoSpaces;
                this.decodeByte(c2, in, idx);
                if (this.insideString || (this.openBraces != 1 || c2 != 44) && (this.openBraces != 0 || c2 != 93)) continue;
                int i2 = in.readerIndex();
                while (Character.isWhitespace(in.getByte(i2))) {
                    in.skipBytes(1);
                    ++i2;
                }
                for (idxNoSpaces = idx - 1; idxNoSpaces >= in.readerIndex() && Character.isWhitespace(in.getByte(idxNoSpaces)); --idxNoSpaces) {
                }
                ByteBuf json3 = this.extractObject(ctx, in, in.readerIndex(), idxNoSpaces + 1 - in.readerIndex());
                if (json3 != null) {
                    out2.add(json3);
                }
                in.readerIndex(idx + 1);
                if (c2 != 93) continue;
                this.reset();
                continue;
            }
            if (c2 == 123 || c2 == 91) {
                this.initDecoding(c2);
                if (this.state != 2) continue;
                in.skipBytes(1);
                continue;
            }
            if (Character.isWhitespace(c2)) {
                in.skipBytes(1);
                continue;
            }
            this.state = -1;
            throw new CorruptedFrameException("invalid JSON received at byte position " + idx + ": " + ByteBufUtil.hexDump(in));
        }
        this.idx = in.readableBytes() == 0 ? 0 : idx;
        this.lastReaderIndex = in.readerIndex();
    }

    protected ByteBuf extractObject(ChannelHandlerContext ctx, ByteBuf buffer, int index, int length) {
        return buffer.retainedSlice(index, length);
    }

    private void decodeByte(byte c2, ByteBuf in, int idx) {
        if (!(c2 != 123 && c2 != 91 || this.insideString)) {
            ++this.openBraces;
        } else if (!(c2 != 125 && c2 != 93 || this.insideString)) {
            --this.openBraces;
        } else if (c2 == 34) {
            if (!this.insideString) {
                this.insideString = true;
            } else {
                int backslashCount = 0;
                --idx;
                while (idx >= 0 && in.getByte(idx) == 92) {
                    ++backslashCount;
                    --idx;
                }
                if (backslashCount % 2 == 0) {
                    this.insideString = false;
                }
            }
        }
    }

    private void initDecoding(byte openingBrace) {
        this.openBraces = 1;
        this.state = openingBrace == 91 && this.streamArrayElements ? 2 : 1;
    }

    private void reset() {
        this.insideString = false;
        this.state = 0;
        this.openBraces = 0;
    }
}

