/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.protobuf;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;

@ChannelHandler.Sharable
public class ProtobufVarint32LengthFieldPrepender
extends MessageToByteEncoder<ByteBuf> {
    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out2) throws Exception {
        int bodyLen = msg.readableBytes();
        int headerLen = ProtobufVarint32LengthFieldPrepender.computeRawVarint32Size(bodyLen);
        out2.ensureWritable(headerLen + bodyLen);
        ProtobufVarint32LengthFieldPrepender.writeRawVarint32(out2, bodyLen);
        out2.writeBytes(msg, msg.readerIndex(), bodyLen);
    }

    static void writeRawVarint32(ByteBuf out2, int value2) {
        while (true) {
            if ((value2 & 0xFFFFFF80) == 0) {
                out2.writeByte(value2);
                return;
            }
            out2.writeByte(value2 & 0x7F | 0x80);
            value2 >>>= 7;
        }
    }

    static int computeRawVarint32Size(int value2) {
        if ((value2 & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value2 & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value2 & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value2 & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }
}

