/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.handler.codec.spdy.SpdyUnknownFrame;
import io.netty.util.internal.StringUtil;

public final class DefaultSpdyUnknownFrame
extends DefaultByteBufHolder
implements SpdyUnknownFrame {
    private final int frameType;
    private final byte flags;

    public DefaultSpdyUnknownFrame(int frameType, byte flags, ByteBuf data2) {
        super(data2);
        this.frameType = frameType;
        this.flags = flags;
    }

    @Override
    public int frameType() {
        return this.frameType;
    }

    @Override
    public byte flags() {
        return this.flags;
    }

    @Override
    public DefaultSpdyUnknownFrame copy() {
        return this.replace(this.content().copy());
    }

    @Override
    public DefaultSpdyUnknownFrame duplicate() {
        return this.replace(this.content().duplicate());
    }

    @Override
    public DefaultSpdyUnknownFrame retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    @Override
    public DefaultSpdyUnknownFrame replace(ByteBuf content2) {
        return new DefaultSpdyUnknownFrame(this.frameType, this.flags, content2);
    }

    @Override
    public DefaultSpdyUnknownFrame retain() {
        super.retain();
        return this;
    }

    @Override
    public DefaultSpdyUnknownFrame retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public DefaultSpdyUnknownFrame touch() {
        super.touch();
        return this;
    }

    @Override
    public DefaultSpdyUnknownFrame touch(Object hint) {
        super.touch(hint);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DefaultSpdyUnknownFrame)) {
            return false;
        }
        DefaultSpdyUnknownFrame that = (DefaultSpdyUnknownFrame)o;
        return this.frameType == that.frameType && this.flags == that.flags && super.equals(that);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.frameType;
        result2 = 31 * result2 + this.flags;
        return result2;
    }

    @Override
    public String toString() {
        return StringUtil.simpleClassName(this) + "(frameType=" + this.frameType + ", flags=" + this.flags + ", content=" + this.contentToString() + ')';
    }
}

