/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.IntObjectMap;
import io.netty.util.internal.MathUtil;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IntObjectHashMap<V>
implements IntObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private int[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Integer> keySet = new KeySet();
    private final Set<Map.Entry<Integer, V>> entrySet = new EntrySet();
    private final Iterable<IntObjectMap.PrimitiveEntry<V>> entries = new Iterable<IntObjectMap.PrimitiveEntry<V>>(){

        @Override
        public Iterator<IntObjectMap.PrimitiveEntry<V>> iterator() {
            return new PrimitiveIterator();
        }
    };

    public IntObjectHashMap() {
        this(8, 0.5f);
    }

    public IntObjectHashMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public IntObjectHashMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = loadFactor;
        int capacity = MathUtil.safeFindNextPositivePowerOfTwo(initialCapacity);
        this.mask = capacity - 1;
        this.keys = new int[capacity];
        Object[] temp = new Object[capacity];
        this.values = temp;
        this.maxSize = this.calcMaxSize(capacity);
    }

    private static <T> T toExternal(T value2) {
        assert (value2 != null) : "null is not a legitimate internal value. Concurrent Modification?";
        return value2 == NULL_VALUE ? null : (T)value2;
    }

    private static <T> T toInternal(T value2) {
        return (T)(value2 == null ? NULL_VALUE : value2);
    }

    @Override
    public V get(int key2) {
        int index = this.indexOf(key2);
        return index == -1 ? null : (V)IntObjectHashMap.toExternal(this.values[index]);
    }

    @Override
    public V put(int key2, V value2) {
        int startIndex;
        int index = startIndex = this.hashIndex(key2);
        do {
            if (this.values[index] == null) {
                this.keys[index] = key2;
                this.values[index] = IntObjectHashMap.toInternal(value2);
                this.growSize();
                return null;
            }
            if (this.keys[index] != key2) continue;
            V previousValue = this.values[index];
            this.values[index] = IntObjectHashMap.toInternal(value2);
            return IntObjectHashMap.toExternal(previousValue);
        } while ((index = this.probeNext(index)) != startIndex);
        throw new IllegalStateException("Unable to insert");
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> sourceMap) {
        if (sourceMap instanceof IntObjectHashMap) {
            IntObjectHashMap source2 = (IntObjectHashMap)sourceMap;
            for (int i2 = 0; i2 < source2.values.length; ++i2) {
                V sourceValue = source2.values[i2];
                if (sourceValue == null) continue;
                this.put(source2.keys[i2], sourceValue);
            }
            return;
        }
        for (Map.Entry<Integer, V> entry : sourceMap.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(int key2) {
        int index = this.indexOf(key2);
        if (index == -1) {
            return null;
        }
        V prev = this.values[index];
        this.removeAt(index);
        return IntObjectHashMap.toExternal(prev);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(int key2) {
        return this.indexOf(key2) >= 0;
    }

    @Override
    public boolean containsValue(Object value2) {
        Object v1 = IntObjectHashMap.toInternal(value2);
        for (V v2 : this.values) {
            if (v2 == null || !v2.equals(v1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<IntObjectMap.PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    final PrimitiveIterator iter;
                    {
                        this.iter = new PrimitiveIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.iter.next().value();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return IntObjectHashMap.this.size;
            }
        };
    }

    @Override
    public int hashCode() {
        int hash = this.size;
        for (int key2 : this.keys) {
            hash ^= IntObjectHashMap.hashCode(key2);
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntObjectMap)) {
            return false;
        }
        IntObjectMap other = (IntObjectMap)obj;
        if (this.size != other.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V value2 = this.values[i2];
            if (value2 == null) continue;
            int key2 = this.keys[i2];
            Object otherValue = other.get(key2);
            if (!(value2 == NULL_VALUE ? otherValue != null : !value2.equals(otherValue))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.containsKey(this.objectToKey(key2));
    }

    @Override
    public V get(Object key2) {
        return this.get(this.objectToKey(key2));
    }

    @Override
    public V put(Integer key2, V value2) {
        return this.put(this.objectToKey(key2), value2);
    }

    @Override
    public V remove(Object key2) {
        return this.remove(this.objectToKey(key2));
    }

    @Override
    public Set<Integer> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        return this.entrySet;
    }

    private int objectToKey(Object key2) {
        return (Integer)key2;
    }

    private int indexOf(int key2) {
        int startIndex;
        int index = startIndex = this.hashIndex(key2);
        do {
            if (this.values[index] == null) {
                return -1;
            }
            if (key2 != this.keys[index]) continue;
            return index;
        } while ((index = this.probeNext(index)) != startIndex);
        return -1;
    }

    private int hashIndex(int key2) {
        return IntObjectHashMap.hashCode(key2) & this.mask;
    }

    private static int hashCode(int key2) {
        return key2;
    }

    private int probeNext(int index) {
        return index + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private boolean removeAt(int index) {
        --this.size;
        this.keys[index] = 0;
        this.values[index] = null;
        int nextFree = index;
        int i2 = this.probeNext(index);
        V value2 = this.values[i2];
        while (value2 != null) {
            int key2 = this.keys[i2];
            int bucket = this.hashIndex(key2);
            if (i2 < bucket && (bucket <= nextFree || nextFree <= i2) || bucket <= nextFree && nextFree <= i2) {
                this.keys[nextFree] = key2;
                this.values[nextFree] = value2;
                this.keys[i2] = 0;
                this.values[i2] = null;
                nextFree = i2;
            }
            i2 = this.probeNext(i2);
            value2 = this.values[i2];
        }
        return nextFree != index;
    }

    private int calcMaxSize(int capacity) {
        int upperBound = capacity - 1;
        return Math.min(upperBound, (int)((float)capacity * this.loadFactor));
    }

    private void rehash(int newCapacity) {
        int[] oldKeys = this.keys;
        V[] oldVals = this.values;
        this.keys = new int[newCapacity];
        Object[] temp = new Object[newCapacity];
        this.values = temp;
        this.maxSize = this.calcMaxSize(newCapacity);
        this.mask = newCapacity - 1;
        block0: for (int i2 = 0; i2 < oldVals.length; ++i2) {
            V oldVal = oldVals[i2];
            if (oldVal == null) continue;
            int oldKey = oldKeys[i2];
            int index = this.hashIndex(oldKey);
            while (true) {
                if (this.values[index] == null) {
                    this.keys[index] = oldKey;
                    this.values[index] = oldVal;
                    continue block0;
                }
                index = this.probeNext(index);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder(4 * this.size);
        sb.append('{');
        boolean first2 = true;
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V value2 = this.values[i2];
            if (value2 == null) continue;
            if (!first2) {
                sb.append(", ");
            }
            sb.append(this.keyToString(this.keys[i2])).append('=').append((Object)(value2 == this ? "(this Map)" : IntObjectHashMap.toExternal(value2)));
            first2 = false;
        }
        return sb.append('}').toString();
    }

    protected String keyToString(int key2) {
        return Integer.toString(key2);
    }

    final class MapEntry
    implements Map.Entry<Integer, V> {
        private final int entryIndex;

        MapEntry(int entryIndex) {
            this.entryIndex = entryIndex;
        }

        @Override
        public Integer getKey() {
            this.verifyExists();
            return IntObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public V getValue() {
            this.verifyExists();
            return IntObjectHashMap.toExternal(IntObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public V setValue(V value2) {
            this.verifyExists();
            Object prevValue = IntObjectHashMap.toExternal(IntObjectHashMap.this.values[this.entryIndex]);
            ((IntObjectHashMap)IntObjectHashMap.this).values[this.entryIndex] = IntObjectHashMap.toInternal(value2);
            return prevValue;
        }

        private void verifyExists() {
            if (IntObjectHashMap.this.values[this.entryIndex] == null) {
                throw new IllegalStateException("The map entry has been removed");
            }
        }
    }

    private final class MapIterator
    implements Iterator<Map.Entry<Integer, V>> {
        private final PrimitiveIterator iter;

        private MapIterator() {
            this.iter = new PrimitiveIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map.Entry<Integer, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.iter.next();
            return new MapEntry(this.iter.entryIndex);
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    private final class PrimitiveIterator
    implements Iterator<IntObjectMap.PrimitiveEntry<V>>,
    IntObjectMap.PrimitiveEntry<V> {
        private int prevIndex = -1;
        private int nextIndex = -1;
        private int entryIndex = -1;

        private PrimitiveIterator() {
        }

        private void scanNext() {
            while (++this.nextIndex != IntObjectHashMap.this.values.length && IntObjectHashMap.this.values[this.nextIndex] == null) {
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                this.scanNext();
            }
            return this.nextIndex != IntObjectHashMap.this.values.length;
        }

        @Override
        public IntObjectMap.PrimitiveEntry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prevIndex = this.nextIndex;
            this.scanNext();
            this.entryIndex = this.prevIndex;
            return this;
        }

        @Override
        public void remove() {
            if (this.prevIndex == -1) {
                throw new IllegalStateException("next must be called before each remove.");
            }
            if (IntObjectHashMap.this.removeAt(this.prevIndex)) {
                this.nextIndex = this.prevIndex;
            }
            this.prevIndex = -1;
        }

        @Override
        public int key() {
            return IntObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public V value() {
            return IntObjectHashMap.toExternal(IntObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public void setValue(V value2) {
            ((IntObjectHashMap)IntObjectHashMap.this).values[this.entryIndex] = IntObjectHashMap.toInternal(value2);
        }
    }

    private final class KeySet
    extends AbstractSet<Integer> {
        private KeySet() {
        }

        @Override
        public int size() {
            return IntObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return IntObjectHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return IntObjectHashMap.this.remove(o) != null;
        }

        @Override
        public boolean retainAll(Collection<?> retainedKeys) {
            boolean changed = false;
            Iterator iter = IntObjectHashMap.this.entries().iterator();
            while (iter.hasNext()) {
                IntObjectMap.PrimitiveEntry entry = iter.next();
                if (retainedKeys.contains(entry.key())) continue;
                changed = true;
                iter.remove();
            }
            return changed;
        }

        @Override
        public void clear() {
            IntObjectHashMap.this.clear();
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                private final Iterator<Map.Entry<Integer, V>> iter;
                {
                    this.iter = IntObjectHashMap.this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Integer next() {
                    return this.iter.next().getKey();
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Integer, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, V>> iterator() {
            return new MapIterator();
        }

        @Override
        public int size() {
            return IntObjectHashMap.this.size();
        }
    }
}

