/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;

class Log4J2Logger
extends ExtendedLoggerWrapper
implements InternalLogger {
    private static final long serialVersionUID = 5485418394879791397L;
    private static final boolean VARARGS_ONLY = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                Logger.class.getMethod("debug", String.class, Object.class);
                return false;
            }
            catch (NoSuchMethodException ignore) {
                return true;
            }
            catch (SecurityException ignore) {
                return false;
            }
        }
    });

    Log4J2Logger(Logger logger) {
        super((ExtendedLogger)logger, logger.getName(), (MessageFactory)logger.getMessageFactory());
        if (VARARGS_ONLY) {
            throw new UnsupportedOperationException("Log4J2 version mismatch");
        }
    }

    @Override
    public String name() {
        return this.getName();
    }

    @Override
    public void trace(Throwable t2) {
        this.log(Level.TRACE, "Unexpected exception:", t2);
    }

    @Override
    public void debug(Throwable t2) {
        this.log(Level.DEBUG, "Unexpected exception:", t2);
    }

    @Override
    public void info(Throwable t2) {
        this.log(Level.INFO, "Unexpected exception:", t2);
    }

    @Override
    public void warn(Throwable t2) {
        this.log(Level.WARN, "Unexpected exception:", t2);
    }

    @Override
    public void error(Throwable t2) {
        this.log(Level.ERROR, "Unexpected exception:", t2);
    }

    @Override
    public boolean isEnabled(InternalLogLevel level) {
        return this.isEnabled(Log4J2Logger.toLevel(level));
    }

    @Override
    public void log(InternalLogLevel level, String msg) {
        this.log(Log4J2Logger.toLevel(level), msg);
    }

    @Override
    public void log(InternalLogLevel level, String format2, Object arg) {
        this.log(Log4J2Logger.toLevel(level), format2, arg);
    }

    @Override
    public void log(InternalLogLevel level, String format2, Object argA, Object argB) {
        this.log(Log4J2Logger.toLevel(level), format2, argA, argB);
    }

    @Override
    public void log(InternalLogLevel level, String format2, Object ... arguments) {
        this.log(Log4J2Logger.toLevel(level), format2, arguments);
    }

    @Override
    public void log(InternalLogLevel level, String msg, Throwable t2) {
        this.log(Log4J2Logger.toLevel(level), msg, t2);
    }

    @Override
    public void log(InternalLogLevel level, Throwable t2) {
        this.log(Log4J2Logger.toLevel(level), "Unexpected exception:", t2);
    }

    private static Level toLevel(InternalLogLevel level) {
        switch (level) {
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case TRACE: {
                return Level.TRACE;
            }
        }
        throw new Error();
    }
}

