/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.conversions;

import io.specmatic.conversions.OpenAPISecuritySchemeKt;
import io.specmatic.conversions.Warning;
import io.specmatic.core.HttpHeadersPattern;
import io.specmatic.core.HttpRequestPattern;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.core.pattern.ExactValuePattern;
import io.specmatic.core.pattern.GrammarKt;
import io.specmatic.core.pattern.Pattern;
import io.specmatic.core.pattern.Row;
import io.specmatic.core.value.StringValue;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a6\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0000\u001a0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0000\u00a8\u0006\u0012"}, d2={"addToHeaderType", "Lio/specmatic/core/HttpRequestPattern;", "headerName", "", "row", "Lio/specmatic/core/pattern/Row;", "requestPattern", "printWarningsForOverriddenSecurityParameters", "", "matchingParameters", "", "Lio/swagger/v3/oas/models/parameters/Parameter;", "securitySchemeDescription", "httpParameterType", "method", "path", "warningsForOverriddenSecurityParameters", "Lio/specmatic/conversions/Warning;", "specmatic-core"})
public final class OpenAPISecuritySchemeKt {
    @NotNull
    public static final HttpRequestPattern addToHeaderType(@NotNull String headerName, @NotNull Row row, @NotNull HttpRequestPattern requestPattern) {
        Intrinsics.checkNotNullParameter(headerName, "headerName");
        Intrinsics.checkNotNullParameter(row, "row");
        Intrinsics.checkNotNullParameter(requestPattern, "requestPattern");
        String it = row.getField(headerName);
        boolean bl = false;
        Pattern headerValueType = GrammarKt.isPatternToken(it) ? GrammarKt.parsedPattern$default(it, null, null, 6, null) : (Pattern)new ExactValuePattern(new StringValue(it), null, false, 6, null);
        return HttpRequestPattern.copy$default(requestPattern, HttpHeadersPattern.copy$default(requestPattern.getHeadersPattern(), MapsKt.plus(requestPattern.getHeadersPattern().getPattern(), TuplesKt.to(headerName, headerValueType)), null, null, 6, null), null, null, null, null, null, null, null, 254, null);
    }

    public static final void printWarningsForOverriddenSecurityParameters(@NotNull List<? extends Parameter> matchingParameters, @NotNull String securitySchemeDescription, @NotNull String httpParameterType, @NotNull String method2, @NotNull String path2) {
        Intrinsics.checkNotNullParameter(matchingParameters, "matchingParameters");
        Intrinsics.checkNotNullParameter(securitySchemeDescription, "securitySchemeDescription");
        Intrinsics.checkNotNullParameter(httpParameterType, "httpParameterType");
        Intrinsics.checkNotNullParameter(method2, "method");
        Intrinsics.checkNotNullParameter(path2, "path");
        String parameterNames2 = CollectionsKt.joinToString$default(matchingParameters, ", ", null, null, 0, null, printWarningsForOverriddenSecurityParameters.parameterNames.1.INSTANCE, 30, null);
        Warning warningMsg = OpenAPISecuritySchemeKt.warningsForOverriddenSecurityParameters(parameterNames2, securitySchemeDescription, httpParameterType, method2, path2);
        LoggingKt.getLogger().log(warningMsg);
        LoggingKt.getLogger().boundary();
    }

    @NotNull
    public static final Warning warningsForOverriddenSecurityParameters(@NotNull String matchingParameters, @NotNull String securitySchemeDescription, @NotNull String httpParameterType, @NotNull String method2, @NotNull String path2) {
        Intrinsics.checkNotNullParameter(matchingParameters, "matchingParameters");
        Intrinsics.checkNotNullParameter(securitySchemeDescription, "securitySchemeDescription");
        Intrinsics.checkNotNullParameter(httpParameterType, "httpParameterType");
        Intrinsics.checkNotNullParameter(method2, "method");
        Intrinsics.checkNotNullParameter(path2, "path");
        return new Warning("Security scheme " + securitySchemeDescription + " is defined in the OpenAPI specification, but conflicting " + httpParameterType + " parameter(s) " + matchingParameters + " have been defined in the " + method2 + " operation for path '" + path2 + "'.", "This may lead to confusion or conflicts.", "Consider removing the conflicting " + httpParameterType + " parameter(s) or updating the security scheme definition to avoid conflicts.");
    }
}

