/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.conversions;

import io.specmatic.conversions.OpenAPISecurityScheme;
import io.specmatic.conversions.Warning;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0001H\u0000\u001a \u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001H\u0000\u001a6\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010 2\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\t\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\"\u001a\u0010\u000e\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"BEARER_SECURITY_SCHEME", "", "HINT_BOUNDARY_TESTING_ENABLED", "HINT_VALUE_DELIMITERS", "", "OBJECT_TYPE", "SERVICE_TYPE_HTTP", "SPECMATIC_TEST_WITH_NO_REQ_EX", "X_SPECMATIC_HINT", "missingRequestExampleErrorMessageForTest", "getMissingRequestExampleErrorMessageForTest", "()Ljava/lang/String;", "setMissingRequestExampleErrorMessageForTest", "(Ljava/lang/String;)V", "missingResponseExampleErrorMessageForTest", "getMissingResponseExampleErrorMessageForTest", "setMissingResponseExampleErrorMessageForTest", "testDirectoryEnvironmentVariable", "testDirectoryProperty", "createWarningForRefAndSchemaSiblings", "Lio/specmatic/conversions/Warning;", "schemaDescriptor", "ref", "type", "getEmptySchemaWarning", "contentType", "breadCrumb", "valueType", "exampleName", "validateSecuritySchemeParameterDuplication", "", "securitySchemes", "", "Lio/specmatic/conversions/OpenAPISecurityScheme;", "parameters", "Lio/swagger/v3/oas/models/parameters/Parameter;", "method", "path", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nOpenApiSpecification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenApiSpecification.kt\nio/specmatic/conversions/OpenApiSpecificationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,2441:1\n1855#2,2:2442\n*S KotlinDebug\n*F\n+ 1 OpenApiSpecification.kt\nio/specmatic/conversions/OpenApiSpecificationKt\n*L\n2418#1:2442,2\n*E\n"})
public final class OpenApiSpecificationKt {
    @NotNull
    private static final String BEARER_SECURITY_SCHEME = "bearer";
    @NotNull
    public static final String OBJECT_TYPE = "object";
    @NotNull
    public static final String SERVICE_TYPE_HTTP = "HTTP";
    @NotNull
    private static final String X_SPECMATIC_HINT = "x-specmatic-hint";
    @NotNull
    private static final String HINT_BOUNDARY_TESTING_ENABLED = "boundary_testing_enabled";
    @NotNull
    private static final char[] HINT_VALUE_DELIMITERS;
    @NotNull
    public static final String testDirectoryEnvironmentVariable = "SPECMATIC_TESTS_DIRECTORY";
    @NotNull
    public static final String testDirectoryProperty = "specmaticTestsDirectory";
    @NotNull
    private static String missingRequestExampleErrorMessageForTest;
    @NotNull
    private static String missingResponseExampleErrorMessageForTest;
    @NotNull
    private static final String SPECMATIC_TEST_WITH_NO_REQ_EX = "SPECMATIC-TEST-WITH-NO-REQ-EX";

    @NotNull
    public static final String getMissingRequestExampleErrorMessageForTest() {
        return missingRequestExampleErrorMessageForTest;
    }

    public static final void setMissingRequestExampleErrorMessageForTest(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        missingRequestExampleErrorMessageForTest = string;
    }

    @NotNull
    public static final String getMissingResponseExampleErrorMessageForTest() {
        return missingResponseExampleErrorMessageForTest;
    }

    public static final void setMissingResponseExampleErrorMessageForTest(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        missingResponseExampleErrorMessageForTest = string;
    }

    @NotNull
    public static final String missingRequestExampleErrorMessageForTest(@NotNull String exampleName) {
        Intrinsics.checkNotNullParameter(exampleName, "exampleName");
        String string = missingRequestExampleErrorMessageForTest;
        Object[] objectArray = new Object[]{exampleName, exampleName};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public static final String missingResponseExampleErrorMessageForTest(@NotNull String exampleName) {
        Intrinsics.checkNotNullParameter(exampleName, "exampleName");
        String string = missingResponseExampleErrorMessageForTest;
        Object[] objectArray = new Object[]{exampleName, exampleName};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public static final Warning getEmptySchemaWarning(@NotNull String contentType2, @NotNull String breadCrumb, @NotNull String valueType) {
        Intrinsics.checkNotNullParameter(contentType2, "contentType");
        Intrinsics.checkNotNullParameter(breadCrumb, "breadCrumb");
        Intrinsics.checkNotNullParameter(valueType, "valueType");
        return new Warning("The specification contains media type " + contentType2 + " with no definition for " + breadCrumb + ".", "It will be treated as a " + valueType + " when generating tests, in mocks, etc. Thus, any " + valueType + " will satisfy the requirements of this schema, and you will lose feedback about broken consumer expectations.", "Please provide a media type with a schema.");
    }

    public static final void validateSecuritySchemeParameterDuplication(@NotNull List<? extends OpenAPISecurityScheme> securitySchemes, @Nullable List<? extends Parameter> parameters2, @NotNull String method2, @NotNull String path2) {
        Intrinsics.checkNotNullParameter(securitySchemes, "securitySchemes");
        Intrinsics.checkNotNullParameter(method2, "method");
        Intrinsics.checkNotNullParameter(path2, "path");
        Iterable $this$forEach$iv = securitySchemes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OpenAPISecurityScheme securityScheme = (OpenAPISecurityScheme)element$iv;
            boolean bl = false;
            List<Parameter> list = parameters2;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            securityScheme.warnIfExistsInParameters(list, method2, path2);
        }
    }

    @NotNull
    public static final Warning createWarningForRefAndSchemaSiblings(@NotNull String schemaDescriptor, @NotNull String ref, @NotNull String type2) {
        Intrinsics.checkNotNullParameter(schemaDescriptor, "schemaDescriptor");
        Intrinsics.checkNotNullParameter(ref, "ref");
        Intrinsics.checkNotNullParameter(type2, "type");
        String openApiLink = "https://spec.openapis.org/oas/v3.0.4.html#fixed-fields-19";
        return new Warning(((CharSequence)schemaDescriptor).length() == 0 ? "A schema has both $ref (" + ref + ") and a type " + type2 + " defined." : "Schema at " + schemaDescriptor + " has both $ref (" + ref + ") and a type " + type2 + " defined.", "As per the OpenAPI specification format (" + openApiLink + "), when both are present, only $ref will be used when generating tests, mock responses, etc, and the neighboring type will be ignored.", "To resolve this, remove either the " + ref + " or the " + type2 + " type.");
    }

    public static final /* synthetic */ char[] access$getHINT_VALUE_DELIMITERS$p() {
        return HINT_VALUE_DELIMITERS;
    }

    static {
        char[] cArray = new char[]{','};
        HINT_VALUE_DELIMITERS = cArray;
        missingRequestExampleErrorMessageForTest = "WARNING: Ignoring response example named %s for test or stub data, because no associated request example named %s was found.";
        missingResponseExampleErrorMessageForTest = "WARNING: Ignoring request example named %s for test or stub data, because no associated response example named %s was found.";
    }
}

